/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;

public class AutoFormatVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        J.CompilationUnit cu = (J.CompilationUnit)cursor.firstEnclosingOrThrow(J.CompilationUnit.class);
        J t = (J)new NormalizeFormatVisitor().visit(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor().visit(t, p, cursor.fork());
        t = (J)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)cu.getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new SpacesVisitor(Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.stopAfter).visit(t, p, cursor.fork());
        t = new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, (Object)p, cursor.fork());
        return t;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit t = (J.CompilationUnit)new RemoveTrailingWhitespaceVisitor().visit(cu, p);
        t = (J.CompilationUnit)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)cu.getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.stopAfter).visit((Tree)t, (Object)p);
        t = (J.CompilationUnit)new SpacesVisitor(Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), this.stopAfter).visit((Tree)t, (Object)p);
        t = (J.CompilationUnit)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.stopAfter).visit((Tree)t, (Object)p);
        t = (J.CompilationUnit)new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, (Object)p);
        assert (t != null);
        return t;
    }
}

