/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class PrimitiveWrapperClassConstructorToValueOf
extends Recipe {
    private static final ThreadLocal<JavaParser> JAVA_PARSER_THREAD_LOCAL = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().build());

    public String getDisplayName() {
        return "Use primitive wrapper `valueOf` method";
    }

    public String getDescription() {
        return "The constructor of all primitive types has been deprecated in favor of using the static factory method `valueOf` available for each of the primitive type wrappers.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesType("java.lang.Boolean"));
                this.doAfterVisit(new UsesType("java.lang.Byte"));
                this.doAfterVisit(new UsesType("java.lang.Character"));
                this.doAfterVisit(new UsesType("java.lang.Double"));
                this.doAfterVisit(new UsesType("java.lang.Float"));
                this.doAfterVisit(new UsesType("java.lang.Integer"));
                this.doAfterVisit(new UsesType("java.lang.Long"));
                this.doAfterVisit(new UsesType("java.lang.Short"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J j = super.visitNewClass(newClass, executionContext);
                J.NewClass nc = (J.NewClass)j;
                if (nc.getType() instanceof JavaType.FullyQualified && nc.getArguments() != null && nc.getArguments().size() == 1) {
                    JavaType.FullyQualified fqn = (JavaType.FullyQualified)nc.getType();
                    switch (fqn.getFullyQualifiedName()) {
                        case "java.lang.Boolean": 
                        case "java.lang.Byte": 
                        case "java.lang.Character": 
                        case "java.lang.Double": 
                        case "java.lang.Float": 
                        case "java.lang.Integer": 
                        case "java.lang.Long": 
                        case "java.lang.Short": {
                            j = nc.withTemplate(this.template(fqn.getClassName() + ".valueOf(#{});").javaParser((JavaParser)JAVA_PARSER_THREAD_LOCAL.get()).build(), nc.getCoordinates().replace(), nc.getArguments().get(0));
                            break;
                        }
                    }
                }
                return j;
            }
        };
    }
}

