/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseObjectNotifyAll
extends Recipe {
    private static final MethodMatcher OBJECT_NOTIFY = new MethodMatcher("java.lang.Object notify()");

    public String getDisplayName() {
        return "Replaces `Object.notify()` with `Object.notifyAll()`";
    }

    public String getDescription() {
        return "`Object.notifyAll()` and `Object.notify()` both wake up sleeping threads, but `Object.notify()` only rouses one while `Object.notifyAll()` rouses all of them. Since `Object.notify()` might not wake up the right thread, `Object.notifyAll()` should be used instead. See [this](https://wiki.sei.cmu.edu/confluence/display/java/THI02-J.+Notify+all+waiting+threads+rather+than+a+single+thread) for more information.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2446");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(OBJECT_NOTIFY);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J invocation = super.visitMethodInvocation(method, context);
                if (OBJECT_NOTIFY.matches(method)) {
                    return ((J.MethodInvocation)invocation).withName(((J.MethodInvocation)invocation).getName().withSimpleName("notifyAll"));
                }
                return invocation;
            }
        };
    }
}

