/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.java.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Autodetect detect(List<? extends JavaSourceFile> cus) {
        Builder builder = Autodetect.builder();
        for (JavaSourceFile javaSourceFile : cus) {
            builder.phase1(javaSourceFile);
        }
        for (JavaSourceFile javaSourceFile : cus) {
            builder.phase2(javaSourceFile);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static long getTotalCharCount(IndentStatistic indentStatistic) {
        return indentStatistic.depthToSpaceIndentFrequencies.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).mapToLong(entry -> (long)((Integer)entry.getKey()).intValue() * (Long)entry.getValue()).sum();
    }

    private static int getBiggestGroupOfTabSize(IndentStatistic deltaSpaces) {
        Map<Integer, Integer> tabSizeToFrequencyMap = deltaSpaces.depthToSpaceIndentFrequencies.entrySet().stream().filter(entry -> ((IndentStatistic.DepthCoordinate)entry.getKey()).indentDepth != 0).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(spaceCountToFrequency -> new AbstractMap.SimpleEntry<Integer, Integer>((int)Math.round((double)((Integer)spaceCountToFrequency.getKey()).intValue() / (double)((IndentStatistic.DepthCoordinate)entry.getKey()).indentDepth), ((Long)spaceCountToFrequency.getValue()).intValue()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingInt(Map.Entry::getValue)));
        return tabSizeToFrequencyMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(0);
    }

    private static int getClosestEven(double num) {
        int integerPart = (int)num;
        if (integerPart % 2 == 0) {
            return integerPart;
        }
        int lowerEven = integerPart - 1;
        int upperEven = integerPart + 1;
        if (Math.abs(num - (double)lowerEven) < Math.abs(num - (double)upperEven)) {
            return lowerEven;
        }
        return upperEven;
    }

    private static class IndentStatistic {
        Map<DepthCoordinate, Map<Integer, Long>> depthToSpaceIndentFrequencies = new ConcurrentHashMap<DepthCoordinate, Map<Integer, Long>>();

        public void record(int indentDepth, int continuationDepth, int charCount) {
            this.record(new DepthCoordinate(indentDepth, continuationDepth), charCount);
        }

        public void record(DepthCoordinate depth, int charCount) {
            if (charCount <= 0) {
                return;
            }
            this.depthToSpaceIndentFrequencies.compute(depth, (n, map) -> {
                if (map == null) {
                    map = new ConcurrentHashMap<Integer, Long>();
                }
                map.compute(charCount, (m, count) -> {
                    if (count == null) {
                        count = 0L;
                    }
                    return count + 1L;
                });
                return map;
            });
        }

        public int commonIndent() {
            Map<Integer, Long> map = this.depthToSpaceIndentFrequencies.entrySet().stream().flatMap(it -> {
                int depth = ((DepthCoordinate)it.getKey()).getIndentDepth();
                return ((Map)it.getValue()).entrySet().stream().map(charsToOccurrence -> new AbstractMap.SimpleEntry<Integer, Long>((Integer)charsToOccurrence.getKey() / depth, (Long)charsToOccurrence.getValue()));
            }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, Long::sum));
            return map.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(4);
        }

        public int continuationIndent(int commonIndent) {
            Map<Integer, Long> map = this.depthToSpaceIndentFrequencies.entrySet().stream().flatMap(it -> {
                int depth = ((DepthCoordinate)it.getKey()).getIndentDepth();
                int continuationDepth = ((DepthCoordinate)it.getKey()).getContinuationDepth();
                return ((Map)it.getValue()).entrySet().stream().map(charsToOccurrence -> new AbstractMap.SimpleEntry<Integer, Long>(((Integer)charsToOccurrence.getKey() - depth * commonIndent) / continuationDepth, (Long)charsToOccurrence.getValue()));
            }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, Long::sum));
            return map.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(commonIndent * 2);
        }

        public Map<DepthCoordinate, Map<Integer, Long>> getDepthToSpaceIndentFrequencies() {
            return this.depthToSpaceIndentFrequencies;
        }

        public void setDepthToSpaceIndentFrequencies(Map<DepthCoordinate, Map<Integer, Long>> depthToSpaceIndentFrequencies) {
            this.depthToSpaceIndentFrequencies = depthToSpaceIndentFrequencies;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndentStatistic)) {
                return false;
            }
            IndentStatistic other = (IndentStatistic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<DepthCoordinate, Map<Integer, Long>> this$depthToSpaceIndentFrequencies = this.getDepthToSpaceIndentFrequencies();
            Map<DepthCoordinate, Map<Integer, Long>> other$depthToSpaceIndentFrequencies = other.getDepthToSpaceIndentFrequencies();
            return !(this$depthToSpaceIndentFrequencies == null ? other$depthToSpaceIndentFrequencies != null : !((Object)this$depthToSpaceIndentFrequencies).equals(other$depthToSpaceIndentFrequencies));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof IndentStatistic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<DepthCoordinate, Map<Integer, Long>> $depthToSpaceIndentFrequencies = this.getDepthToSpaceIndentFrequencies();
            result = result * 59 + ($depthToSpaceIndentFrequencies == null ? 43 : ((Object)$depthToSpaceIndentFrequencies).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "Autodetect.IndentStatistic(depthToSpaceIndentFrequencies=" + this.getDepthToSpaceIndentFrequencies() + ")";
        }

        private static final class DepthCoordinate {
            private final int indentDepth;
            private final int continuationDepth;

            public DepthCoordinate(int indentDepth, int continuationDepth) {
                this.indentDepth = indentDepth;
                this.continuationDepth = continuationDepth;
            }

            public int getIndentDepth() {
                return this.indentDepth;
            }

            public int getContinuationDepth() {
                return this.continuationDepth;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DepthCoordinate)) {
                    return false;
                }
                DepthCoordinate other = (DepthCoordinate)o;
                if (this.getIndentDepth() != other.getIndentDepth()) {
                    return false;
                }
                return this.getContinuationDepth() == other.getContinuationDepth();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getIndentDepth();
                result = result * 59 + this.getContinuationDepth();
                return result;
            }

            @NonNull
            public String toString() {
                return "Autodetect.IndentStatistic.DepthCoordinate(indentDepth=" + this.getIndentDepth() + ", continuationDepth=" + this.getContinuationDepth() + ")";
            }
        }
    }

    public static class Builder {
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final ImportLayoutStatistics importLayoutStatistics = new ImportLayoutStatistics();
        private final SpacesStatistics spacesStatistics = new SpacesStatistics();
        private final WrappingAndBracesStatistics wrappingAndBracesStatistics = new WrappingAndBracesStatistics();
        private final GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();
        private final NavigableSet<String> importedPackages = new TreeSet<String>();

        public void phase1(JavaSourceFile cu) {
            for (J.Import anImport : cu.getImports()) {
                this.importedPackages.add(anImport.getPackageName() + ".");
            }
            this.importLayoutStatistics.mapBlockPatterns(this.importedPackages);
        }

        public void phase2(JavaSourceFile cu) {
            new FindIndentJavaVisitor().visitNonNull(cu, this.indentStatistics);
            new FindImportLayout().visitNonNull(cu, this.importLayoutStatistics);
            new FindSpacesStyle().visitNonNull(cu, this.spacesStatistics);
            new FindWrappingAndBracesStyle().visitNonNull(cu, this.wrappingAndBracesStatistics);
            new FindLineFormatJavaVisitor().visitNonNull(cu, this.generalFormatStatistics);
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.importLayoutStatistics.getImportLayoutStyle(), this.spacesStatistics.getSpacesStyle(), this.wrappingAndBracesStatistics.getWrappingAndBracesStyle(), this.generalFormatStatistics.getFormatStyle()));
        }
    }

    private static class FindWrappingAndBracesStyle
    extends JavaIsoVisitor<WrappingAndBracesStatistics> {
        private FindWrappingAndBracesStyle() {
        }

        @Override
        public J.If.Else visitElse(J.If.Else elze, WrappingAndBracesStatistics stats) {
            stats.elseOnNewLine += this.hasNewLine(elze.getPrefix());
            return super.visitElse(elze, stats);
        }

        private int hasNewLine(Space space) {
            return space.getWhitespace().contains("\n") ? 1 : -1;
        }
    }

    private static class WrappingAndBracesStatistics {
        int elseOnNewLine = 0;

        private WrappingAndBracesStatistics() {
        }

        public WrappingAndBracesStyle getWrappingAndBracesStyle() {
            WrappingAndBracesStyle wrappingAndBracesStyle = IntelliJ.wrappingAndBraces();
            return wrappingAndBracesStyle.withIfStatement(new WrappingAndBracesStyle.IfStatement(this.elseOnNewLine > 0));
        }
    }

    private static class FindSpacesStyle
    extends JavaIsoVisitor<SpacesStatistics> {
        private FindSpacesStyle() {
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, SpacesStatistics stats) {
            stats.afterTypeCast += this.hasSpace(typeCast.getExpression().getPrefix());
            return super.visitTypeCast(typeCast, stats);
        }

        @Override
        public J.Try.Catch visitCatch(J.Try.Catch _catch, SpacesStatistics stats) {
            stats.beforeCatch += this.hasSpace(_catch.getParameter().getPrefix());
            return super.visitCatch(_catch, stats);
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(doWhileLoop.getWhileCondition().getPrefix());
            return super.visitDoWhileLoop(doWhileLoop, stats);
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            stats.beforeColonInForEach += this.hasSpace(forLoop.getControl().getPadding().getVariable().getAfter());
            return super.visitForEachLoop(forLoop, stats);
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            stats.beforeForSemiColon += this.hasSpace(forLoop.getControl().getPadding().getInit().get(forLoop.getControl().getInit().size() - 1).getAfter());
            stats.beforeForSemiColon += this.hasSpace(forLoop.getControl().getPadding().getCondition().getAfter());
            stats.afterForSemiColon += this.hasSpace(forLoop.getControl().getInit().get(forLoop.getControl().getInit().size() - 1).getPrefix());
            stats.afterForSemiColon += this.hasSpace(forLoop.getControl().getCondition().getPrefix());
            return super.visitForLoop(forLoop, stats);
        }

        @Override
        public J.If visitIf(J.If iff, SpacesStatistics stats) {
            stats.beforeIf += this.hasSpace(iff.getIfCondition().getPrefix());
            return super.visitIf(iff, stats);
        }

        @Override
        public J.Lambda visitLambda(J.Lambda lambda, SpacesStatistics stats) {
            List<J> parameters = lambda.getParameters().getParameters();
            if (parameters.size() > 1) {
                int i;
                List<JRightPadded<J>> paddedParameters = lambda.getParameters().getPadding().getParams();
                for (i = 0; i < paddedParameters.size() - 1; ++i) {
                    stats.beforeComma += this.hasSpace(paddedParameters.get(i).getAfter());
                }
                for (i = 1; i < parameters.size(); ++i) {
                    stats.afterComma += this.hasSpace(parameters.get(i).getPrefix());
                }
            }
            return super.visitLambda(lambda, stats);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, SpacesStatistics stats) {
            stats.beforeMethodDeclaration += this.hasSpace(method.getPadding().getParameters().getBefore());
            List<Statement> parameters = method.getParameters();
            if (parameters.size() > 1) {
                int i;
                List<JRightPadded<Statement>> paddedParameters = method.getPadding().getParameters().getPadding().getElements();
                for (i = 0; i < paddedParameters.size() - 1; ++i) {
                    stats.beforeComma += this.hasSpace(paddedParameters.get(i).getAfter());
                }
                for (i = 1; i < parameters.size(); ++i) {
                    stats.afterComma += this.hasSpace(parameters.get(i).getPrefix());
                }
            }
            return super.visitMethodDeclaration(method, stats);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, SpacesStatistics stats) {
            stats.beforeMethodCall += this.hasSpace(method.getPadding().getArguments().getBefore());
            List<Expression> arguments = method.getArguments();
            if (arguments.size() > 1) {
                int i;
                List<JRightPadded<Expression>> paddedArguments = method.getPadding().getArguments().getPadding().getElements();
                stats.withinMethodCallParentheses += this.hasSpace(paddedArguments.get(0).getElement().getPrefix());
                stats.withinMethodCallParentheses += this.hasSpace(paddedArguments.get(method.getArguments().size() - 1).getAfter());
                for (i = 0; i < paddedArguments.size() - 1; ++i) {
                    JRightPadded<Expression> elem = paddedArguments.get(i);
                    stats.beforeComma += this.hasSpace(elem.getAfter());
                }
                for (i = 1; i < arguments.size(); ++i) {
                    stats.afterComma += this.hasSpace(arguments.get(i).getPrefix());
                }
            }
            return super.visitMethodInvocation(method, stats);
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray newArray, SpacesStatistics stats) {
            JContainer<Expression> initializer = newArray.getPadding().getInitializer();
            List<Expression> elements = newArray.getInitializer();
            if (elements != null && initializer != null && elements.size() > 1) {
                int i;
                List<JRightPadded<Expression>> paddedElements = initializer.getPadding().getElements();
                for (i = 0; i < paddedElements.size() - 1; ++i) {
                    stats.beforeComma += this.hasSpace(paddedElements.get(i).getAfter());
                }
                for (i = 1; i < elements.size(); ++i) {
                    stats.afterComma += this.hasSpace(elements.get(i).getPrefix());
                }
            }
            return super.visitNewArray(newArray, stats);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, SpacesStatistics stats) {
            stats.beforeMethodCall += this.hasSpace(newClass.getPadding().getArguments().getBefore());
            List<Expression> arguments = newClass.getArguments();
            if (arguments.size() > 1) {
                int i;
                List<JRightPadded<Expression>> paddedArguments = newClass.getPadding().getArguments().getPadding().getElements();
                stats.withinMethodCallParentheses += this.hasSpace(paddedArguments.get(0).getElement().getPrefix());
                stats.withinMethodCallParentheses += this.hasSpace(paddedArguments.get(newClass.getArguments().size() - 1).getAfter());
                for (i = 0; i < paddedArguments.size() - 1; ++i) {
                    JRightPadded<Expression> elem = paddedArguments.get(i);
                    stats.beforeComma += this.hasSpace(elem.getAfter());
                }
                for (i = 1; i < arguments.size(); ++i) {
                    stats.afterComma += this.hasSpace(arguments.get(i).getPrefix());
                }
            }
            return super.visitNewClass(newClass, stats);
        }

        @Override
        public J.Switch visitSwitch(J.Switch _switch, SpacesStatistics stats) {
            stats.beforeSwitch += this.hasSpace(_switch.getSelector().getPrefix());
            return super.visitSwitch(_switch, stats);
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, SpacesStatistics stats) {
            stats.beforeSynchronized += this.hasSpace(_sync.getLock().getPrefix());
            return super.visitSynchronized(_sync, stats);
        }

        @Override
        public J.Try visitTry(J.Try _try, SpacesStatistics stats) {
            if (_try.getPadding().getResources() != null) {
                stats.beforeTry += this.hasSpace(_try.getPadding().getResources().getBefore());
            }
            return super.visitTry(_try, stats);
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(whileLoop.getCondition().getPrefix());
            return super.visitWhileLoop(whileLoop, stats);
        }

        private int hasSpace(Space space) {
            return space.getWhitespace().contains(" ") ? 1 : -1;
        }
    }

    private static class SpacesStatistics {
        int beforeIf = 1;
        int beforeMethodCall = 0;
        int beforeMethodDeclaration = 0;
        int beforeFor = 1;
        int beforeWhile = 1;
        int beforeSwitch = 1;
        int beforeTry = 1;
        int beforeCatch = 1;
        int beforeSynchronized = 1;
        int beforeComma = 0;
        int afterComma = 1;
        int beforeColonInForEach = 1;
        int beforeForSemiColon = 0;
        int afterForSemiColon = 0;
        int afterTypeCast = 0;
        int withinMethodCallParentheses = 0;

        private SpacesStatistics() {
        }

        public SpacesStyle getSpacesStyle() {
            SpacesStyle spaces = IntelliJ.spaces();
            return spaces.withBeforeParentheses(new SpacesStyle.BeforeParentheses(this.beforeMethodDeclaration > 0, this.beforeMethodCall > 0, this.beforeIf > 0, this.beforeFor > 0 || this.beforeWhile > 0, this.beforeWhile > 0 || this.beforeFor > 0, this.beforeSwitch > 0, this.beforeTry > 0 || this.beforeCatch > 0, this.beforeTry > 0 || this.beforeCatch > 0, this.beforeSynchronized > 0, false)).withWithin(new SpacesStyle.Within(spaces.getWithin().getCodeBraces(), spaces.getWithin().getBrackets(), spaces.getWithin().getArrayInitializerBraces(), spaces.getWithin().getEmptyArrayInitializerBraces(), spaces.getWithin().getGroupingParentheses(), spaces.getWithin().getMethodDeclarationParentheses(), spaces.getWithin().getEmptyMethodDeclarationParentheses(), this.withinMethodCallParentheses > 0, spaces.getWithin().getEmptyMethodCallParentheses(), spaces.getWithin().getIfParentheses(), spaces.getWithin().getForParentheses(), spaces.getWithin().getWhileParentheses(), spaces.getWithin().getSwitchParentheses(), spaces.getWithin().getTryParentheses(), spaces.getWithin().getCatchParentheses(), spaces.getWithin().getSynchronizedParentheses(), spaces.getWithin().getTypeCastParentheses(), spaces.getWithin().getAnnotationParentheses(), spaces.getWithin().getAngleBrackets(), spaces.getWithin().getRecordHeader())).withOther(new SpacesStyle.Other(this.beforeComma > 0, this.afterComma >= 1, this.beforeForSemiColon > 0, this.afterForSemiColon >= 0, this.afterTypeCast > 0, this.beforeColonInForEach > 0, false));
        }
    }

    private static class FindImportLayout
    extends JavaIsoVisitor<ImportLayoutStatistics> {
        private FindImportLayout() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ImportLayoutStatistics importLayoutStatistics) {
            LinkedHashSet<ImportLayoutStatistics.Block> blocks = new LinkedHashSet<ImportLayoutStatistics.Block>();
            importLayoutStatistics.staticAtBotCount = importLayoutStatistics.staticAtBotCount + (cu.getImports().size() > 0 && cu.getImports().get(cu.getImports().size() - 1).isStatic() ? 1 : 0);
            importLayoutStatistics.staticAtTopCount = importLayoutStatistics.staticAtTopCount + (cu.getImports().size() > 0 && cu.getImports().get(0).isStatic() ? 1 : 0);
            boolean staticBlock = false;
            int blockStart = 0;
            int i = 0;
            String previousPkg = "";
            int previousPkgCount = 1;
            int javaPos = Integer.MAX_VALUE;
            int javaxPos = Integer.MAX_VALUE;
            HashMap<ImportLayoutStatistics.Block, Integer> referenceCount = new HashMap<ImportLayoutStatistics.Block, Integer>();
            for (J.Import anImport : cu.getImports()) {
                boolean containsNewLine;
                previousPkgCount += previousPkg.equals(importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + ".")) ? 1 : 0;
                boolean bl = containsNewLine = anImport.getPrefix().getWhitespace().contains("\n\n") || anImport.getPrefix().getWhitespace().contains("\r\n\r\n");
                if (containsNewLine || i > 0 && importLayoutStatistics.pkgToBlockPattern.containsKey(anImport.getPackageName() + ".") && !previousPkg.equals(importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + "."))) {
                    if (i - blockStart > 0) {
                        ImportLayoutStatistics.Block block = new ImportLayoutStatistics.Block(staticBlock ? ImportLayoutStatistics.BlockType.ImportStatic : ImportLayoutStatistics.BlockType.Import, previousPkg, containsNewLine);
                        javaPos = "java.*".equals(block.pattern) && javaPos > blockStart ? blockStart : javaPos;
                        int n = javaxPos = "javax.*".equals(block.pattern) && javaxPos > blockStart ? blockStart : javaxPos;
                        if (blocks.contains(block) && previousPkgCount > (Integer)referenceCount.get(block)) {
                            blocks.remove(block);
                        }
                        blocks.add(block);
                        referenceCount.put(block, previousPkgCount + 1);
                        previousPkgCount = 1;
                    }
                    blockStart = i;
                }
                if (anImport.getQualid().getSimpleName().equals("*")) {
                    JavaType.FullyQualified fq;
                    if (anImport.isStatic()) {
                        int count = 0;
                        for (JavaType.Variable variable : cu.getTypesInUse().getVariables()) {
                            fq = TypeUtils.asFullyQualified(variable.getType());
                            if (fq == null || !anImport.getTypeName().equals(fq.getFullyQualifiedName())) continue;
                            ++count;
                        }
                        importLayoutStatistics.minimumFoldedStaticImports = Math.min(importLayoutStatistics.minimumFoldedStaticImports, count);
                    } else {
                        HashSet<String> fqns = new HashSet<String>();
                        for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                            if (!(type instanceof JavaType.FullyQualified)) continue;
                            fq = (JavaType.FullyQualified)type;
                            if (!anImport.getPackageName().equals(fq.getPackageName())) continue;
                            fqns.add(fq.getFullyQualifiedName());
                        }
                        importLayoutStatistics.minimumFoldedImports = Math.min(importLayoutStatistics.minimumFoldedImports, fqns.size());
                    }
                }
                staticBlock = anImport.isStatic();
                ++i;
                previousPkg = importLayoutStatistics.pkgToBlockPattern.getOrDefault(anImport.getPackageName() + ".", "");
            }
            if (i - blockStart > 0) {
                ImportLayoutStatistics.Block block = new ImportLayoutStatistics.Block(staticBlock ? ImportLayoutStatistics.BlockType.ImportStatic : ImportLayoutStatistics.BlockType.Import, previousPkg, false);
                if (blocks.contains(block) && previousPkgCount > (Integer)referenceCount.get(block)) {
                    blocks.remove(block);
                }
                javaPos = "java.*".equals(block.pattern) ? blockStart : javaPos;
                javaxPos = "javax.*".equals(block.pattern) ? blockStart : javaxPos;
                blocks.add(block);
            }
            if (javaPos != Integer.MAX_VALUE && javaxPos != Integer.MAX_VALUE) {
                importLayoutStatistics.javaBeforeJavaxCount = importLayoutStatistics.javaBeforeJavaxCount + (javaPos < javaxPos ? 1 : 0);
                importLayoutStatistics.javaxBeforeJavaCount = importLayoutStatistics.javaxBeforeJavaCount + (javaxPos < javaPos ? 1 : 0);
            }
            importLayoutStatistics.blocksPerSourceFile.add(new ArrayList(blocks));
            return cu;
        }
    }

    private static class ImportLayoutStatistics {
        List<List<Block>> blocksPerSourceFile = new ArrayList<List<Block>>();
        Map<String, String> pkgToBlockPattern = new LinkedHashMap<String, String>();
        int staticAtTopCount = 0;
        int staticAtBotCount = 0;
        int javaBeforeJavaxCount = 0;
        int javaxBeforeJavaCount = 0;
        int minimumFoldedImports = Integer.MAX_VALUE;
        int minimumFoldedStaticImports = Integer.MAX_VALUE;

        private ImportLayoutStatistics() {
        }

        public boolean isStaticImportsAtBot() {
            return this.staticAtBotCount >= this.staticAtTopCount;
        }

        public boolean isJavaxBeforeJava() {
            return this.javaxBeforeJavaCount >= this.javaBeforeJavaxCount;
        }

        public ImportLayoutStyle getImportLayoutStyle() {
            return this.blocksPerSourceFile.stream().max(Comparator.comparing(List::size).thenComparing(blocks -> blocks.stream().filter(b -> "all other imports".equals(((Block)b).pattern)).count())).map(longestBlocks -> {
                Block block;
                int i;
                ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
                boolean insertAllOthers = false;
                boolean insertStaticAllOthers = false;
                boolean containsJava = false;
                boolean containsJavax = false;
                int insertAllOtherAtIndex = 0;
                int insertStaticAllOtherAtIndex = 0;
                int nonStaticMaxCount = Integer.MIN_VALUE;
                int staticMaxCount = Integer.MIN_VALUE;
                int nonStaticCountPos = 0;
                int staticCountPos = 0;
                int nonStaticPos = 0;
                int staticPos = 0;
                ArrayList<Block> nonStaticBlocks = new ArrayList<Block>();
                ArrayList<Block> staticBlocks = new ArrayList<Block>();
                ArrayList<Integer> countOfBlocksInNonStaticGroups = new ArrayList<Integer>();
                ArrayList<Integer> countOfBlocksInStaticGroups = new ArrayList<Integer>();
                for (Block block2 : longestBlocks) {
                    if (BlockType.ImportStatic.equals((Object)block2.type)) {
                        staticBlocks.add(block2);
                        countOfBlocksInStaticGroups.add(0);
                        countOfBlocksInStaticGroups.set(staticCountPos, (Integer)countOfBlocksInStaticGroups.get(staticCountPos) + 1);
                        if (staticMaxCount < (Integer)countOfBlocksInStaticGroups.get(staticCountPos)) {
                            staticMaxCount = (Integer)countOfBlocksInStaticGroups.get(staticCountPos);
                            insertStaticAllOtherAtIndex = staticCountPos;
                            insertStaticAllOthers = true;
                        }
                        if (block2.addBlankLine) {
                            staticCountPos = staticPos + 1;
                        }
                        ++staticPos;
                        continue;
                    }
                    if (!containsJava && "java.*".equals(block2.pattern)) {
                        containsJava = true;
                    }
                    if (!containsJavax && "javax.*".equals(block2.pattern)) {
                        containsJavax = true;
                    }
                    nonStaticBlocks.add(block2);
                    countOfBlocksInNonStaticGroups.add(0);
                    countOfBlocksInNonStaticGroups.set(nonStaticCountPos, (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos) + 1);
                    if (nonStaticMaxCount < (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos)) {
                        nonStaticMaxCount = (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos);
                        insertAllOtherAtIndex = nonStaticCountPos;
                        insertAllOthers = true;
                    }
                    if (block2.addBlankLine) {
                        nonStaticCountPos = nonStaticPos + 1;
                    }
                    ++nonStaticPos;
                }
                boolean addNewLine = false;
                if (!this.isStaticImportsAtBot()) {
                    if (!insertStaticAllOthers) {
                        builder = builder.importStaticAllOthers();
                    }
                    for (int i2 = 0; i2 < staticBlocks.size(); ++i2) {
                        if (insertStaticAllOthers) {
                            if (i2 == insertStaticAllOtherAtIndex) {
                                builder = builder.importStaticAllOthers();
                                addNewLine = true;
                                continue;
                            }
                            if (i2 > insertStaticAllOtherAtIndex) {
                                if ((Integer)countOfBlocksInStaticGroups.get(i2) == 0) continue;
                                insertStaticAllOthers = false;
                            }
                        }
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        Block block3 = (Block)staticBlocks.get(i2);
                        builder.staticImportPackage(block3.pattern);
                        if (!block3.addBlankLine || i2 == staticBlocks.size() - 1) continue;
                        builder = builder.blankLine();
                    }
                }
                boolean bl = addNewLine = !this.isStaticImportsAtBot();
                if (!insertAllOthers) {
                    if (addNewLine) {
                        builder = builder.blankLine();
                    }
                    builder = builder.importAllOthers();
                    if (!containsJava && !containsJavax) {
                        builder = builder.blankLine();
                        if (this.isJavaxBeforeJava()) {
                            builder = builder.importPackage("javax.*");
                            builder = builder.importPackage("java.*");
                        } else {
                            builder = builder.importPackage("java.*");
                            builder = builder.importPackage("javax.*");
                        }
                    }
                    addNewLine = true;
                }
                boolean addJavaOrJavax = true;
                for (i = 0; i < nonStaticBlocks.size(); ++i) {
                    if (insertAllOthers) {
                        if (i == insertAllOtherAtIndex) {
                            if (addNewLine) {
                                builder = builder.blankLine();
                                addNewLine = false;
                            }
                            builder = builder.importAllOthers();
                            if (containsJava || containsJavax) continue;
                            builder = builder.blankLine();
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                                continue;
                            }
                            builder = builder.importPackage("java.*");
                            builder = builder.importPackage("javax.*");
                            continue;
                        }
                        if (i > insertAllOtherAtIndex) {
                            if ((Integer)countOfBlocksInNonStaticGroups.get(i) == 0) continue;
                            insertAllOthers = false;
                            addNewLine = true;
                        }
                    }
                    block = (Block)nonStaticBlocks.get(i);
                    if (addJavaOrJavax && "java.*".equals(block.pattern)) {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        if (!(i - 1 >= 0 && "javax.*".equals(((Block)nonStaticBlocks.get(i - 1)).pattern) || i + 1 < nonStaticBlocks.size() && "javax.*".equals(((Block)nonStaticBlocks.get(i + 1)).pattern))) {
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                            } else {
                                builder = builder.importPackage("java.*");
                                builder = builder.importPackage("javax.*");
                            }
                            addNewLine = true;
                            addJavaOrJavax = false;
                        } else {
                            builder = builder.importPackage(block.pattern);
                        }
                    } else if (addJavaOrJavax && "javax.*".equals(block.pattern)) {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        if (!(i - 1 >= 0 && "java.*".equals(((Block)nonStaticBlocks.get(i - 1)).pattern) || i + 1 < nonStaticBlocks.size() - 1 && "java.*".equals(((Block)nonStaticBlocks.get(i + 1)).pattern))) {
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                            } else {
                                builder = builder.importPackage("java.*");
                                builder = builder.importPackage("javax.*");
                            }
                            addNewLine = true;
                            addJavaOrJavax = false;
                        } else {
                            builder = builder.importPackage(block.pattern);
                        }
                    } else {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        builder = builder.importPackage(block.pattern);
                    }
                    if (!block.addBlankLine || i == nonStaticBlocks.size() - 1) continue;
                    builder = builder.blankLine();
                }
                if (this.isStaticImportsAtBot()) {
                    builder = builder.blankLine();
                    addNewLine = false;
                    if (!insertStaticAllOthers) {
                        builder = builder.importStaticAllOthers();
                    }
                    for (i = 0; i < staticBlocks.size(); ++i) {
                        if (insertStaticAllOthers) {
                            if (i == insertStaticAllOtherAtIndex) {
                                builder = builder.importStaticAllOthers();
                                continue;
                            }
                            if (i > insertStaticAllOtherAtIndex) {
                                if ((Integer)countOfBlocksInStaticGroups.get(i) == 0) continue;
                                insertStaticAllOthers = false;
                                addNewLine = true;
                            }
                        }
                        block = (Block)staticBlocks.get(i);
                        if (addNewLine || i > 0 && ((Block)staticBlocks.get(i - 1)).addBlankLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        builder = builder.staticImportPackage(block.pattern);
                    }
                }
                if (longestBlocks.isEmpty()) {
                    builder.importAllOthers();
                    builder.blankLine();
                    if (this.isJavaxBeforeJava()) {
                        builder = builder.importPackage("javax.*");
                        builder = builder.importPackage("java.*");
                    } else {
                        builder = builder.importPackage("java.*");
                        builder = builder.importPackage("javax.*");
                    }
                    builder.blankLine();
                    builder.importStaticAllOthers();
                }
                builder.classCountToUseStarImport(Math.max(this.minimumFoldedImports, 5));
                builder.nameCountToUseStarImport(Math.max(this.minimumFoldedStaticImports, 3));
                return builder.build();
            }).orElse(IntelliJ.importLayout());
        }

        public void mapBlockPatterns(NavigableSet<String> importedPackages) {
            String longestCommonPrefix = null;
            String prevLCP = null;
            ArrayList<String> prevPackages = new ArrayList<String>();
            for (String pkg : importedPackages) {
                longestCommonPrefix = this.longestCommonPrefix(pkg, longestCommonPrefix);
                if (!prevPackages.isEmpty() && longestCommonPrefix.chars().filter(c -> c == 46).count() <= 1L && !StringUtils.isNullOrEmpty((String)prevLCP)) {
                    for (String prev : prevPackages) {
                        if (prevLCP.startsWith("java.")) {
                            prevLCP = "java.";
                        } else if (prevLCP.startsWith("javax.")) {
                            prevLCP = "javax.";
                        }
                        this.pkgToBlockPattern.put(prev, prevLCP + "*");
                    }
                    longestCommonPrefix = pkg;
                    prevPackages.clear();
                }
                prevPackages.add(pkg);
                prevLCP = longestCommonPrefix;
            }
            for (String prev : prevPackages) {
                this.pkgToBlockPattern.put(prev, prevLCP + "*");
            }
        }

        private String longestCommonPrefix(String pkg, @Nullable String lcp) {
            int i;
            if (lcp == null) {
                return pkg;
            }
            char[] p1 = pkg.toCharArray();
            char[] p2 = lcp.toCharArray();
            for (i = 0; i < p1.length && i < p2.length && p1[i] == p2[i]; ++i) {
            }
            return lcp.substring(0, i);
        }

        static class Block {
            private final BlockType type;
            private final String pattern;
            private final boolean addBlankLine;

            Block(BlockType type, String pattern, boolean addBlankLine) {
                this.type = type;
                this.pattern = pattern;
                this.addBlankLine = addBlankLine;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Block)) {
                    return false;
                }
                Block other = (Block)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.addBlankLine != other.addBlankLine) {
                    return false;
                }
                BlockType this$type = this.type;
                BlockType other$type = other.type;
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$pattern = this.pattern;
                String other$pattern = other.pattern;
                return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Block;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.addBlankLine ? 79 : 97);
                BlockType $type = this.type;
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $pattern = this.pattern;
                result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
                return result;
            }
        }

        static enum BlockType {
            Import,
            ImportStatic;

        }
    }

    private static class FindIndentJavaVisitor
    extends JavaIsoVisitor<IndentStatistics> {
        private FindIndentJavaVisitor() {
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, IndentStatistics stats) {
            this.visitStatement((Statement)cd, stats);
            this.visit(cd.getBody(), stats);
            return cd;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, IndentStatistics stats) {
            if (method.getParameters().size() > 1) {
                int alignTo;
                if (method.getParameters().get(0).getPrefix().getLastWhitespace().contains("\n")) {
                    alignTo = method.getParameters().get(0).getPrefix().getLastWhitespace().length() - 1;
                } else {
                    String source = method.print(this.getCursor().getParentOrThrow());
                    alignTo = source.indexOf(method.getParameters().get(0).print(this.getCursor())) - 1;
                }
                List<Statement> parameters = method.getParameters();
                for (int i = 1; i < parameters.size(); ++i) {
                    if (!parameters.get(i).getPrefix().getLastWhitespace().contains("\n")) continue;
                    if (alignTo == parameters.get(i).getPrefix().getLastWhitespace().length()) {
                        stats.multilineAlignedToFirstArgument++;
                        continue;
                    }
                    stats.multilineNotAlignedToFirstArgument++;
                }
            }
            this.visitStatement((Statement)method, stats);
            ListUtils.map(method.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, stats));
            this.visitContainer(method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, stats);
            this.visit(method.getBody(), stats);
            return method;
        }

        @Override
        public J.Block visitBlock(J.Block block, IndentStatistics stats) {
            stats.incrementDepth();
            for (Statement s : block.getStatements()) {
                if (s instanceof Expression) {
                    Set statementExpressions = (Set)this.getCursor().getMessage("STATEMENT_EXPRESSION", Collections.newSetFromMap(new IdentityHashMap(block.getStatements().size())));
                    statementExpressions.add((Expression)((Object)s));
                    this.getCursor().putMessage("STATEMENT_EXPRESSION", (Object)statementExpressions);
                }
                this.visit(s, stats);
            }
            stats.decrementDepth();
            return block;
        }

        @Override
        public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, IndentStatistics indentStatistics) {
            return annotatedType;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, IndentStatistics stats) {
            this.visitStatement((Statement)vd, stats);
            ListUtils.map(vd.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.NAMED_VARIABLE, stats));
            return vd;
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray na, IndentStatistics stats) {
            this.visitExpression((Expression)na, stats);
            return na;
        }

        @Override
        public Statement visitStatement(Statement statement, IndentStatistics stats) {
            boolean isInParentheses = this.getCursor().dropParentUntil(p -> p instanceof J.Block || p instanceof JContainer || p instanceof SourceFile).getValue() instanceof JContainer;
            if (isInParentheses) {
                return statement;
            }
            this.countIndents(statement.getPrefix().getWhitespace(), false, stats);
            return statement;
        }

        @Override
        public Expression visitExpression(Expression expression, IndentStatistics stats) {
            super.visitExpression(expression, stats);
            Set statementExpressions = (Set)this.getCursor().getNearestMessage("STATEMENT_EXPRESSION", Collections.emptySet());
            if (statementExpressions.contains(expression)) {
                return expression;
            }
            this.countIndents(expression.getPrefix().getWhitespace(), true, stats);
            return expression;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, IndentStatistics stats) {
            Set statementExpressions = (Set)this.getCursor().getNearestMessage("STATEMENT_EXPRESSION", Collections.emptySet());
            if (statementExpressions.contains(m)) {
                this.visitStatement((Statement)m, stats);
            } else {
                this.visitExpression((Expression)m, stats);
            }
            if (m.getPadding().getSelect() != null) {
                this.countIndents(m.getPadding().getSelect().getAfter().getWhitespace(), true, stats);
            }
            this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, stats);
            return m;
        }

        @Override
        public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, IndentStatistics indentStatistics) {
            return super.visitRightPadded(right, loc, indentStatistics);
        }

        private void countIndents(String space, boolean isContinuation, IndentStatistics stats) {
            int ni = space.lastIndexOf(10);
            int depth = stats.getDepth();
            if (ni >= 0 && depth > 0) {
                char[] chars;
                int spaceIndent = 0;
                int tabIndent = 0;
                boolean mixed = false;
                for (char c : chars = space.substring(ni).toCharArray()) {
                    if (c == ' ') {
                        if (tabIndent > 0) {
                            mixed = true;
                        }
                        ++spaceIndent;
                        continue;
                    }
                    if (c != '\t') continue;
                    if (spaceIndent > 0) {
                        mixed = true;
                    }
                    ++tabIndent;
                }
                if (spaceIndent > 0 || tabIndent > 0) {
                    if (!isContinuation) {
                        stats.spaceIndentFrequencies.record(depth, 0, spaceIndent);
                        stats.tabIndentFrequencies.record(depth, 0, tabIndent);
                        stats.deltaSpaceIndentFrequencies.record(depth - tabIndent, 0, spaceIndent);
                        stats.accumulateDepthCount += depth;
                    } else if (!mixed) {
                        stats.spaceContinuationIndentFrequencies.record(depth, stats.getContinuationDepth(), spaceIndent);
                        stats.tabContinuationIndentFrequencies.record(depth, stats.getContinuationDepth(), tabIndent);
                    }
                }
            }
        }
    }

    private static class FindLineFormatJavaVisitor
    extends JavaIsoVisitor<GeneralFormatStatistics> {
        private FindLineFormatJavaVisitor() {
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, GeneralFormatStatistics stats) {
            String prefix = space.getWhitespace();
            char[] chars = prefix.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != '\n') continue;
                if (i == 0 || chars[i - 1] != '\r') {
                    stats.linesWithLFNewLines++;
                    continue;
                }
                stats.linesWithCRLFNewLines++;
            }
            return space;
        }
    }

    private static class IndentStatistics {
        private final IndentStatistic spaceIndentFrequencies = new IndentStatistic();
        private final IndentStatistic spaceContinuationIndentFrequencies = new IndentStatistic();
        private final IndentStatistic tabIndentFrequencies = new IndentStatistic();
        private final IndentStatistic tabContinuationIndentFrequencies = new IndentStatistic();
        private final IndentStatistic deltaSpaceIndentFrequencies = new IndentStatistic();
        private long accumulateDepthCount = 0L;
        private int multilineAlignedToFirstArgument = 0;
        private int multilineNotAlignedToFirstArgument = 0;
        private int depth = 0;
        private int continuationDepth = 1;

        private IndentStatistics() {
        }

        public int getDepth() {
            return this.depth;
        }

        public int getContinuationDepth() {
            return this.continuationDepth;
        }

        public void incrementDepth() {
            ++this.depth;
        }

        public void decrementDepth() {
            --this.depth;
        }

        public void incrementContinuationDepth() {
            ++this.continuationDepth;
        }

        public void decrementContinuationDepth() {
            --this.continuationDepth;
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            if (this.accumulateDepthCount == 0L) {
                return IntelliJ.tabsAndIndents();
            }
            long d = this.accumulateDepthCount;
            long nt = Autodetect.getTotalCharCount(this.tabIndentFrequencies);
            double pt = (double)nt / (double)d;
            boolean useTabs = pt >= 0.5;
            int moreFrequentTabSize = Autodetect.getBiggestGroupOfTabSize(this.deltaSpaceIndentFrequencies);
            int tabSize = moreFrequentTabSize == 0 ? 4 : moreFrequentTabSize;
            IndentStatistic continuationFrequencies = useTabs ? this.tabContinuationIndentFrequencies : this.spaceContinuationIndentFrequencies;
            int continuationIndent = continuationFrequencies.continuationIndent(tabSize);
            return new TabsAndIndentsStyle(useTabs, tabSize, tabSize, continuationIndent, false, new TabsAndIndentsStyle.MethodDeclarationParameters(this.multilineAlignedToFirstArgument >= this.multilineNotAlignedToFirstArgument));
        }
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }
}

