/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class StaticMethodNotFinal
extends Recipe {
    public String getDisplayName() {
        return "Static methods not final";
    }

    public String getDescription() {
        return "Static methods do not need to be declared final because they cannot be overridden.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2333");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                if (((J.MethodDeclaration)m).hasModifier(J.Modifier.Type.Static) && ((J.MethodDeclaration)m).hasModifier(J.Modifier.Type.Final)) {
                    m = ((J.MethodDeclaration)m).withModifiers(ListUtils.map(((J.MethodDeclaration)m).getModifiers(), mod -> mod.getType() == J.Modifier.Type.Final ? null : mod));
                }
                return m;
            }
        };
    }
}

