/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ExamplesExtractor
extends JavaIsoVisitor<ExecutionContext> {
    private static final AnnotationMatcher TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher DOCUMENT_EXAMPLE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.internal.DocumentExample");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER_WITH_SPEC = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(java.util.function.Consumer, org.openrewrite.test.SourceSpecs[])");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(org.openrewrite.test.SourceSpecs[])");
    private static final MethodMatcher RECIPE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RecipeSpec recipe(org.openrewrite.Recipe)");
    private static final MethodMatcher JAVA_METHOD_MATCHER = new MethodMatcher("org.openrewrite.java.Assertions java(..)");
    private static final MethodMatcher BUILD_GRADLE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.gradle.Assertions buildGradle(..)");
    private static final MethodMatcher POM_XML_METHOD_MATCHER = new MethodMatcher("org.openrewrite.maven.Assertions pomXml(..)");
    private static final MethodMatcher DEFAULT_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RewriteTest defaults(org.openrewrite.test.RecipeSpec)");
    private static final MethodMatcher SPEC_RECIPE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RecipeSpec recipe(org.openrewrite.Recipe)");
    private String recipeType = "specs.openrewrite.org/v1beta/example";
    private String defaultRecipeName;
    private String recipeName;
    private List<RecipeExample> recipeExamples = new ArrayList<RecipeExample>();
    private String exampleDescription;

    public String printRecipeExampleYaml() {
        String name = this.recipeName != null && !this.recipeName.isEmpty() ? this.recipeName : this.defaultRecipeName;
        return new YamlPrinter().print(this.recipeType, name, this.recipeExamples);
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
        if (method.getName().getSimpleName().equals("defaults") && method.getMethodType() != null && method.getMethodType().getDeclaringType() != null && !method.getMethodType().getDeclaringType().getInterfaces().isEmpty() && method.getMethodType().getDeclaringType().getInterfaces().get(0).getFullyQualifiedName().equals("org.openrewrite.test.RewriteTest")) {
            this.defaultRecipeName = this.findDefaultRecipeName(method);
            return method;
        }
        List<J.Annotation> annotations = method.getLeadingAnnotations();
        if (!ExamplesExtractor.hasAnnotation(annotations, TEST_ANNOTATION_MATCHER) && !ExamplesExtractor.hasAnnotation(annotations, DOCUMENT_EXAMPLE_ANNOTATION_MATCHER)) {
            return method;
        }
        new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
                List<Expression> args;
                if (DOCUMENT_EXAMPLE_ANNOTATION_MATCHER.matches(annotation) && (args = annotation.getArguments()).size() == 1) {
                    Expression arg = args.get(0);
                    if (arg instanceof J.Assignment) {
                        J.Assignment assignment = (J.Assignment)args.get(0);
                        if (assignment.getAssignment() instanceof J.Literal) {
                            ExamplesExtractor.this.exampleDescription = (String)((J.Literal)assignment.getAssignment()).getValue();
                        }
                    } else if (arg instanceof J.Literal) {
                        ExamplesExtractor.this.exampleDescription = (String)((J.Literal)args.get(0)).getValue();
                    }
                }
                return annotation;
            }
        }.visit(method, ctx);
        return super.visitMethodDeclaration(method, ctx);
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        List<Expression> args = method.getArguments();
        RecipeExample example = null;
        if (REWRITE_RUN_METHOD_MATCHER_WITH_SPEC.matches(method)) {
            String maybeName = this.findRecipeNameFromSpecParam(args.get(0));
            if (maybeName != null) {
                this.recipeName = maybeName;
            }
            example = this.extractRecipeExample(args.get(1));
        } else if (REWRITE_RUN_METHOD_MATCHER.matches(method)) {
            example = this.extractRecipeExample(args.get(0));
        }
        if (example != null) {
            example.setDescription(this.exampleDescription);
            this.recipeExamples.add(example);
        }
        return method;
    }

    private static boolean hasAnnotation(List<J.Annotation> annotations, AnnotationMatcher matcher) {
        return annotations.stream().anyMatch(matcher::matches);
    }

    @Nullable
    private String findRecipeNameFromSpecParam(Expression arg) {
        return ((List)new JavaIsoVisitor<List<String>>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> recipeNames) {
                if (RECIPE_METHOD_MATCHER.matches(method)) {
                    new JavaIsoVisitor<List<String>>(){

                        @Override
                        public J.NewClass visitNewClass(J.NewClass newClass, List<String> recipeNames) {
                            JavaType type;
                            if (TypeUtils.isAssignableTo("org.openrewrite.Recipe", newClass.getType()) && (type = newClass.getType()) instanceof JavaType.Class) {
                                JavaType.Class tc = (JavaType.Class)type;
                                recipeNames.add(tc.getFullyQualifiedName());
                            }
                            return newClass;
                        }
                    }.visit(method, recipeNames);
                    return method;
                }
                return method;
            }
        }.reduce(arg, new ArrayList())).stream().findFirst().orElse(null);
    }

    @Nullable
    private String findDefaultRecipeName(final J.MethodDeclaration defaultsMethod) {
        return ((List)new JavaIsoVisitor<List<String>>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> strings) {
                if (SPEC_RECIPE_METHOD_MATCHER.matches(method)) {
                    new JavaIsoVisitor<List<String>>(){

                        @Override
                        public J.NewClass visitNewClass(J.NewClass newClass, List<String> recipeNames) {
                            JavaType type;
                            if (TypeUtils.isAssignableTo("org.openrewrite.Recipe", newClass.getType()) && (type = newClass.getType()) instanceof JavaType.Class) {
                                JavaType.Class tc = (JavaType.Class)type;
                                recipeNames.add(tc.getFullyQualifiedName());
                            }
                            return newClass;
                        }
                    }.visit(defaultsMethod, strings);
                }
                return method;
            }
        }.reduce(defaultsMethod, new ArrayList())).stream().findFirst().orElse(null);
    }

    @Nullable
    private RecipeExample extractRecipeExample(Expression sourceSpecArg) {
        RecipeExample recipeExample = new RecipeExample();
        new JavaIsoVisitor<RecipeExample>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, RecipeExample recipeExample) {
                J.Literal after;
                J.Literal before;
                if (JAVA_METHOD_MATCHER.matches(method)) {
                    recipeExample.setLanguage("java");
                } else if (BUILD_GRADLE_METHOD_MATCHER.matches(method)) {
                    recipeExample.setLanguage("groovy");
                } else if (POM_XML_METHOD_MATCHER.matches(method)) {
                    recipeExample.setLanguage("xml");
                } else {
                    recipeExample.setLanguage("");
                }
                List<Expression> args = method.getArguments();
                J.Literal literal = !args.isEmpty() ? (args.get(0) instanceof J.Literal ? (J.Literal)args.get(0) : null) : (before = null);
                J.Literal literal2 = args.size() > 1 ? (args.get(1) instanceof J.Literal ? (J.Literal)args.get(1) : null) : (after = null);
                if (before != null) {
                    recipeExample.setBefore((String)before.getValue());
                }
                if (after != null) {
                    recipeExample.setAfter((String)after.getValue());
                }
                return method;
            }
        }.visit(sourceSpecArg, recipeExample);
        if (recipeExample.getLanguage() != null && !recipeExample.getLanguage().isEmpty()) {
            return recipeExample;
        }
        return null;
    }

    public static class YamlPrinter {
        String print(String recipeType, String recipeName, List<RecipeExample> examples) {
            if (recipeName == null || recipeName.isEmpty() || examples.isEmpty()) {
                return "";
            }
            StringBuilder output = new StringBuilder();
            output.append("type: ").append(recipeType).append("\n");
            output.append("recipeName: ").append(recipeName).append("\n");
            output.append("examples:\n");
            for (RecipeExample example : examples) {
                if (StringUtils.isNotEmpty((String)example.getDescription())) {
                    output.append("- description: \"").append(example.getDescription()).append("\"\n");
                }
                output.append("  before: |\n");
                output.append(this.indentTextBlock(example.getBefore()));
                if (StringUtils.isNotEmpty((String)example.getAfter())) {
                    output.append("  after: |\n");
                    output.append(this.indentTextBlock(example.getAfter()));
                }
                if (!StringUtils.isNotEmpty((String)example.getLanguage())) continue;
                output.append("  language: \"").append(example.getLanguage()).append("\"\n");
            }
            return output.toString();
        }

        private String indentTextBlock(String text) {
            String str = "    " + text.replace("\n", "\n    ").trim();
            if (!str.endsWith("\n")) {
                str = str + "\n";
            }
            return str;
        }
    }
}

