/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class CaseInsensitiveComparisonsDoNotChangeCase
extends Recipe {
    public String getDisplayName() {
        return "CaseInsensitive comparisons do not alter case";
    }

    public String getDescription() {
        return "Remove `String#toLowerCase()` or `String#toUpperCase()` from `String#equalsIgnoreCase(..)` comparisons.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1157");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>("java.lang.String equalsIgnoreCase(java.lang.String)");
    }

    public CaseInsensitiveComparisonVisitor<ExecutionContext> getVisitor() {
        return new CaseInsensitiveComparisonVisitor<ExecutionContext>();
    }

    private static class CaseInsensitiveComparisonVisitor<ExecutionContext>
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher COMPARE_IGNORE_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String equalsIgnoreCase(java.lang.String)");
        private static final MethodMatcher TO_LOWER_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String toLowerCase()");
        private static final MethodMatcher TO_UPPER_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String toUpperCase()");

        private CaseInsensitiveComparisonVisitor() {
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J mi = super.visitMethodInvocation(method, executionContext);
            if (COMPARE_IGNORE_CASE_METHOD_MATCHER.matches((J.MethodInvocation)mi) && this.isChangeCaseMethod(((J.MethodInvocation)(mi = ((J.MethodInvocation)mi).withArguments(ListUtils.map(((J.MethodInvocation)mi).getArguments(), arg -> {
                if (arg instanceof J.MethodInvocation && this.isChangeCaseMethod((J)arg)) {
                    return ((J.MethodInvocation)arg).getSelect();
                }
                return arg;
            })))).getSelect())) {
                J.MethodInvocation mChangeCase = (J.MethodInvocation)((J.MethodInvocation)mi).getSelect();
                mi = ((J.MethodInvocation)mi).withSelect(mChangeCase.getSelect());
            }
            return mi;
        }

        private boolean isChangeCaseMethod(@Nullable J j) {
            if (j instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)j;
                return TO_LOWER_CASE_METHOD_MATCHER.matches(mi) || TO_UPPER_CASE_METHOD_MATCHER.matches(mi);
            }
            return false;
        }
    }
}

