/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.apache.commons.lang3.StringUtils;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesField;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class ChangeStaticFieldToMethod
extends Recipe {
    @Option(displayName="Old class name", description="The fully qualified name of the class containing the field to replace.", example="java.util.Collections")
    private final String oldClassName;
    @Option(displayName="Old field name", description="The simple name of the static field to replace.", example="EMPTY_LIST")
    private final String oldFieldName;
    @Option(displayName="New class name", description="The fully qualified name of the class containing the method to use. Leave empty to keep the same class.", example="java.util.List", required=false)
    @Nullable
    private final String newClassName;
    @Option(displayName="New field target", description="An optional method target that can be used to specify a static field within the new class.", example="OK_RESPONSE", required=false)
    @Nullable
    private final String newTarget;
    @Option(displayName="New method name", description="The simple name of the method to use. The method must be static and have no arguments.", example="of")
    private final String newMethodName;

    public String getDisplayName() {
        return "Change static field access to static method access";
    }

    public String getDescription() {
        return "Migrate accesses to a static field to invocations of a static method.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesField<ExecutionContext>(this.oldClassName, this.oldFieldName);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
                if (TypeUtils.isOfClassType(classDecl.getType(), ChangeStaticFieldToMethod.this.oldClassName)) {
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, context);
            }

            @Override
            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                if (this.getCursor().firstEnclosing(J.Import.class) == null && TypeUtils.isOfClassType(fieldAccess.getTarget().getType(), ChangeStaticFieldToMethod.this.oldClassName) && fieldAccess.getSimpleName().equals(ChangeStaticFieldToMethod.this.oldFieldName)) {
                    return this.useNewMethod(fieldAccess);
                }
                return super.visitFieldAccess(fieldAccess, ctx);
            }

            @Override
            public J visitIdentifier(J.Identifier ident, ExecutionContext executionContext) {
                JavaType.Variable varType = ident.getFieldType();
                if (varType != null && TypeUtils.isOfClassType(varType.getOwner(), ChangeStaticFieldToMethod.this.oldClassName) && varType.getName().equals(ChangeStaticFieldToMethod.this.oldFieldName)) {
                    return this.useNewMethod(ident);
                }
                return ident;
            }

            @NonNull
            private J useNewMethod(TypeTree tree) {
                String newClass = ChangeStaticFieldToMethod.this.newClassName == null ? ChangeStaticFieldToMethod.this.oldClassName : ChangeStaticFieldToMethod.this.newClassName;
                this.maybeRemoveImport(ChangeStaticFieldToMethod.this.oldClassName);
                this.maybeAddImport(newClass);
                Cursor statementCursor = this.getCursor().dropParentUntil(Statement.class::isInstance);
                Statement statement = (Statement)statementCursor.getValue();
                JavaTemplate template = this.makeNewMethod(newClass, statementCursor);
                J.Block block = (J.Block)statement.withTemplate(template, statement.getCoordinates().replace(), new Object[0]);
                J.MethodInvocation method = (J.MethodInvocation)block.getStatements().get(0).withPrefix(tree.getPrefix());
                if (method.getMethodType() == null) {
                    throw new IllegalArgumentException("Error while changing a static field to a method. The generated template using a the new class [" + newClass + "] and the method [" + ChangeStaticFieldToMethod.this.newMethodName + "] resulted in a null method type.");
                }
                return tree.getType() == null ? method : method.withMethodType(method.getMethodType().withReturnType(tree.getType()));
            }

            @NonNull
            private JavaTemplate makeNewMethod(String newClass, Cursor statementCursor) {
                String packageName = StringUtils.substringBeforeLast((String)newClass, (String)".");
                String simpleClassName = StringUtils.substringAfterLast((String)newClass, (String)".");
                String methodInvocationTemplate = "{" + simpleClassName + (ChangeStaticFieldToMethod.this.newTarget != null ? "." + ChangeStaticFieldToMethod.this.newTarget + "." : ".") + ChangeStaticFieldToMethod.this.newMethodName + "();}";
                String methodStub = ChangeStaticFieldToMethod.this.newTarget == null ? "package " + packageName + "; public class " + simpleClassName + " { public static void " + ChangeStaticFieldToMethod.this.newMethodName + "() { return null; } }" : "package " + packageName + "; public class Target { public static void " + ChangeStaticFieldToMethod.this.newMethodName + "() { return null; } } public class " + simpleClassName + " {public static Target " + ChangeStaticFieldToMethod.this.newTarget + ";}";
                return JavaTemplate.builder(() -> statementCursor, methodInvocationTemplate).javaParser(() -> ((JavaParser.Builder)((Object)((Object)JavaParser.fromJavaVersion().dependsOn(methodStub)))).build()).imports(newClass).build();
            }
        };
    }

    public ChangeStaticFieldToMethod(String oldClassName, String oldFieldName, @Nullable String newClassName, @Nullable String newTarget, String newMethodName) {
        this.oldClassName = oldClassName;
        this.oldFieldName = oldFieldName;
        this.newClassName = newClassName;
        this.newTarget = newTarget;
        this.newMethodName = newMethodName;
    }

    public String getOldClassName() {
        return this.oldClassName;
    }

    public String getOldFieldName() {
        return this.oldFieldName;
    }

    @Nullable
    public String getNewClassName() {
        return this.newClassName;
    }

    @Nullable
    public String getNewTarget() {
        return this.newTarget;
    }

    public String getNewMethodName() {
        return this.newMethodName;
    }

    @NonNull
    public String toString() {
        return "ChangeStaticFieldToMethod(oldClassName=" + this.getOldClassName() + ", oldFieldName=" + this.getOldFieldName() + ", newClassName=" + this.getNewClassName() + ", newTarget=" + this.getNewTarget() + ", newMethodName=" + this.getNewMethodName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeStaticFieldToMethod)) {
            return false;
        }
        ChangeStaticFieldToMethod other = (ChangeStaticFieldToMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldClassName = this.getOldClassName();
        String other$oldClassName = other.getOldClassName();
        if (this$oldClassName == null ? other$oldClassName != null : !this$oldClassName.equals(other$oldClassName)) {
            return false;
        }
        String this$oldFieldName = this.getOldFieldName();
        String other$oldFieldName = other.getOldFieldName();
        if (this$oldFieldName == null ? other$oldFieldName != null : !this$oldFieldName.equals(other$oldFieldName)) {
            return false;
        }
        String this$newClassName = this.getNewClassName();
        String other$newClassName = other.getNewClassName();
        if (this$newClassName == null ? other$newClassName != null : !this$newClassName.equals(other$newClassName)) {
            return false;
        }
        String this$newTarget = this.getNewTarget();
        String other$newTarget = other.getNewTarget();
        if (this$newTarget == null ? other$newTarget != null : !this$newTarget.equals(other$newTarget)) {
            return false;
        }
        String this$newMethodName = this.getNewMethodName();
        String other$newMethodName = other.getNewMethodName();
        return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeStaticFieldToMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldClassName = this.getOldClassName();
        result = result * 59 + ($oldClassName == null ? 43 : $oldClassName.hashCode());
        String $oldFieldName = this.getOldFieldName();
        result = result * 59 + ($oldFieldName == null ? 43 : $oldFieldName.hashCode());
        String $newClassName = this.getNewClassName();
        result = result * 59 + ($newClassName == null ? 43 : $newClassName.hashCode());
        String $newTarget = this.getNewTarget();
        result = result * 59 + ($newTarget == null ? 43 : $newTarget.hashCode());
        String $newMethodName = this.getNewMethodName();
        result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
        return result;
    }
}

