/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.tree.JavaType;

public class DefaultJavaTypeSignatureBuilder
implements JavaTypeSignatureBuilder {
    public static final DefaultJavaTypeSignatureBuilder TO_STRING = new DefaultJavaTypeSignatureBuilder();
    @Nullable
    private Set<String> typeVariableNameStack;
    @Nullable
    private Set<JavaType> parameterizedStack;

    @Override
    public String signature(@Nullable Object type) {
        if (type == null || type == JavaType.Unknown.getInstance()) {
            return "{undefined}";
        }
        if (type instanceof JavaType.Class) {
            return this.classSignature(type);
        }
        if (type instanceof JavaType.Array) {
            return this.arraySignature(type);
        }
        if (type instanceof JavaType.Parameterized) {
            return this.parameterizedSignature(type);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            return this.genericSignature(type);
        }
        if (type instanceof JavaType.Primitive) {
            return this.primitiveSignature(type);
        }
        if (type instanceof JavaType.Method) {
            return this.methodSignature((JavaType.Method)type);
        }
        if (type instanceof JavaType.Variable) {
            return this.variableSignature((JavaType.Variable)type);
        }
        throw new UnsupportedOperationException("Unexpected type " + type.getClass().getName());
    }

    @Override
    public String arraySignature(Object type) {
        return this.signature(((JavaType.Array)type).getElemType()) + "[]";
    }

    @Override
    public String classSignature(Object type) {
        return ((JavaType.Class)type).getFullyQualifiedName();
    }

    @Override
    public String genericSignature(Object type) {
        JavaType.GenericTypeVariable gtv = (JavaType.GenericTypeVariable)type;
        StringBuilder s = new StringBuilder("Generic{" + gtv.getName());
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new LinkedHashSet<String>();
        }
        if (!gtv.getName().equals("?") && !this.typeVariableNameStack.add(gtv.getName())) {
            s.append('}');
            return s.toString();
        }
        switch (gtv.getVariance()) {
            case INVARIANT: {
                break;
            }
            case COVARIANT: {
                s.append(" extends ");
                break;
            }
            case CONTRAVARIANT: {
                s.append(" super ");
            }
        }
        StringJoiner bounds = new StringJoiner(" & ");
        for (JavaType bound : gtv.getBounds()) {
            if (this.parameterizedStack != null && this.parameterizedStack.contains(bound)) continue;
            bounds.add(this.signature(bound));
        }
        s.append(bounds).append('}');
        this.typeVariableNameStack.remove(gtv.getName());
        return s.toString();
    }

    @Override
    public String parameterizedSignature(Object type) {
        JavaType.Parameterized pt = (JavaType.Parameterized)type;
        if (this.parameterizedStack == null) {
            this.parameterizedStack = Collections.newSetFromMap(new IdentityHashMap());
        }
        this.parameterizedStack.add(pt);
        String baseType = this.signature(pt.getType());
        StringBuilder s = new StringBuilder(baseType);
        StringJoiner typeParameters = new StringJoiner(", ", "<", ">");
        for (JavaType typeParameter : pt.getTypeParameters()) {
            typeParameters.add(this.signature(typeParameter));
        }
        s.append(typeParameters);
        this.parameterizedStack.remove(pt);
        return s.toString();
    }

    @Override
    public String primitiveSignature(Object type) {
        return ((JavaType.Primitive)type).getKeyword();
    }

    public String variableSignature(JavaType.Variable variable) {
        return this.signature(variable.getOwner()) + "{name=" + variable.getName() + ",type=" + this.signature(variable.getType()) + '}';
    }

    public String methodSignature(JavaType.Method method) {
        StringBuilder s = new StringBuilder(this.signature(method.getDeclaringType()));
        s.append("{name=").append(method.getName());
        s.append(",return=").append(method.getReturnType());
        StringJoiner parameterTypes = new StringJoiner(",", "[", "]");
        for (JavaType paramType : method.getParameterTypes()) {
            parameterTypes.add(this.signature(paramType));
        }
        s.append(",parameters=").append(parameterTypes);
        s.append('}');
        return s.toString();
    }
}

