/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public final class RecipeExceptionDemonstration
extends Recipe {
    @Option(displayName="Throw on matching method pattern", required=false, description="A method pattern that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    @Nullable
    private final String throwOnMethodPattern;
    @Option(displayName="Throw in the recipe's `visit(List<SourceFile>, ExecutionContext)` method.", required=false)
    @Nullable
    private final Boolean throwOnVisitAll;
    @Option(displayName="Throw in the recipe's `visit(List<SourceFile>, ExecutionContext)` method inside a visitor internal to that method.", required=false)
    @Nullable
    private final Boolean throwOnVisitAllVisitor;
    @Option(displayName="Throw on the project-level applicable test.", required=false)
    @Nullable
    private final Boolean throwOnApplicableTest;
    @Option(displayName="Throw on the project-level applicable test inside a visitor.", required=false)
    @Nullable
    private final Boolean throwOnApplicableTestVisitor;
    @Option(displayName="Throw on the single-source applicable test.", required=false)
    @Nullable
    private final Boolean throwOnSingleSourceApplicableTest;
    @Option(displayName="Throw on the single-source applicable test inside a visitor.", required=false)
    @Nullable
    private final Boolean throwOnSingleSourceApplicableTestVisitor;

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        if (Boolean.TRUE.equals(this.throwOnApplicableTestVisitor)) {
            return new TreeVisitor<Tree, ExecutionContext>(){

                public Tree preVisit(Tree tree, ExecutionContext executionContext) {
                    throw new DemonstrationException("Throwing on the project-level applicable test.");
                }
            };
        }
        if (Boolean.TRUE.equals(this.throwOnApplicableTest)) {
            throw new DemonstrationException("Throwing on the project-level applicable test.");
        }
        return null;
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (Boolean.TRUE.equals(this.throwOnSingleSourceApplicableTestVisitor)) {
            return new TreeVisitor<Tree, ExecutionContext>(){

                public Tree preVisit(Tree tree, ExecutionContext executionContext) {
                    throw new DemonstrationException("Demonstrating an exception thrown on the single-source applicable test.");
                }
            };
        }
        if (Boolean.TRUE.equals(this.throwOnSingleSourceApplicableTest)) {
            throw new DemonstrationException("Demonstrating an exception thrown on the single-source applicable test.");
        }
        return null;
    }

    public String getDisplayName() {
        return "Demonstrate rendering of recipe exceptions";
    }

    public String getDescription() {
        return "Show how recipe exceptions are rendered in various forms of OpenRewrite tooling.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        if (Boolean.TRUE.equals(this.throwOnVisitAllVisitor)) {
            for (SourceFile sourceFile : before) {
                new TreeVisitor<Tree, ExecutionContext>(){

                    public Tree preVisit(Tree tree, ExecutionContext executionContext) {
                        throw new DemonstrationException("Demonstrating an exception thrown in the recipe's `visit(List<SourceFile>, ExecutionContext)` method.");
                    }
                }.visit((Tree)sourceFile, (Object)ctx);
            }
        } else if (Boolean.TRUE.equals(this.throwOnVisitAll)) {
            throw new DemonstrationException("Demonstrating an exception thrown in the recipe's `visit(List<SourceFile>, ExecutionContext)` method.");
        }
        return before;
    }

    protected TreeVisitor<J, ExecutionContext> getVisitor() {
        if (!StringUtils.isBlank((String)this.throwOnMethodPattern)) {
            return new JavaVisitor<ExecutionContext>(){
                final MethodMatcher methodMatcher;
                {
                    this.methodMatcher = new MethodMatcher(RecipeExceptionDemonstration.this.throwOnMethodPattern);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                    if (this.methodMatcher.matches(method)) {
                        throw new DemonstrationException("Demonstrating an exception thrown on a matching method.");
                    }
                    return super.visitMethodInvocation(method, executionContext);
                }
            };
        }
        return TreeVisitor.noop();
    }

    public RecipeExceptionDemonstration(@Nullable String throwOnMethodPattern, @Nullable Boolean throwOnVisitAll, @Nullable Boolean throwOnVisitAllVisitor, @Nullable Boolean throwOnApplicableTest, @Nullable Boolean throwOnApplicableTestVisitor, @Nullable Boolean throwOnSingleSourceApplicableTest, @Nullable Boolean throwOnSingleSourceApplicableTestVisitor) {
        this.throwOnMethodPattern = throwOnMethodPattern;
        this.throwOnVisitAll = throwOnVisitAll;
        this.throwOnVisitAllVisitor = throwOnVisitAllVisitor;
        this.throwOnApplicableTest = throwOnApplicableTest;
        this.throwOnApplicableTestVisitor = throwOnApplicableTestVisitor;
        this.throwOnSingleSourceApplicableTest = throwOnSingleSourceApplicableTest;
        this.throwOnSingleSourceApplicableTestVisitor = throwOnSingleSourceApplicableTestVisitor;
    }

    @Nullable
    public String getThrowOnMethodPattern() {
        return this.throwOnMethodPattern;
    }

    @Nullable
    public Boolean getThrowOnVisitAll() {
        return this.throwOnVisitAll;
    }

    @Nullable
    public Boolean getThrowOnVisitAllVisitor() {
        return this.throwOnVisitAllVisitor;
    }

    @Nullable
    public Boolean getThrowOnApplicableTest() {
        return this.throwOnApplicableTest;
    }

    @Nullable
    public Boolean getThrowOnApplicableTestVisitor() {
        return this.throwOnApplicableTestVisitor;
    }

    @Nullable
    public Boolean getThrowOnSingleSourceApplicableTest() {
        return this.throwOnSingleSourceApplicableTest;
    }

    @Nullable
    public Boolean getThrowOnSingleSourceApplicableTestVisitor() {
        return this.throwOnSingleSourceApplicableTestVisitor;
    }

    @NonNull
    public String toString() {
        return "RecipeExceptionDemonstration(throwOnMethodPattern=" + this.getThrowOnMethodPattern() + ", throwOnVisitAll=" + this.getThrowOnVisitAll() + ", throwOnVisitAllVisitor=" + this.getThrowOnVisitAllVisitor() + ", throwOnApplicableTest=" + this.getThrowOnApplicableTest() + ", throwOnApplicableTestVisitor=" + this.getThrowOnApplicableTestVisitor() + ", throwOnSingleSourceApplicableTest=" + this.getThrowOnSingleSourceApplicableTest() + ", throwOnSingleSourceApplicableTestVisitor=" + this.getThrowOnSingleSourceApplicableTestVisitor() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeExceptionDemonstration)) {
            return false;
        }
        RecipeExceptionDemonstration other = (RecipeExceptionDemonstration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$throwOnVisitAll = this.getThrowOnVisitAll();
        Boolean other$throwOnVisitAll = other.getThrowOnVisitAll();
        if (this$throwOnVisitAll == null ? other$throwOnVisitAll != null : !((Object)this$throwOnVisitAll).equals(other$throwOnVisitAll)) {
            return false;
        }
        Boolean this$throwOnVisitAllVisitor = this.getThrowOnVisitAllVisitor();
        Boolean other$throwOnVisitAllVisitor = other.getThrowOnVisitAllVisitor();
        if (this$throwOnVisitAllVisitor == null ? other$throwOnVisitAllVisitor != null : !((Object)this$throwOnVisitAllVisitor).equals(other$throwOnVisitAllVisitor)) {
            return false;
        }
        Boolean this$throwOnApplicableTest = this.getThrowOnApplicableTest();
        Boolean other$throwOnApplicableTest = other.getThrowOnApplicableTest();
        if (this$throwOnApplicableTest == null ? other$throwOnApplicableTest != null : !((Object)this$throwOnApplicableTest).equals(other$throwOnApplicableTest)) {
            return false;
        }
        Boolean this$throwOnApplicableTestVisitor = this.getThrowOnApplicableTestVisitor();
        Boolean other$throwOnApplicableTestVisitor = other.getThrowOnApplicableTestVisitor();
        if (this$throwOnApplicableTestVisitor == null ? other$throwOnApplicableTestVisitor != null : !((Object)this$throwOnApplicableTestVisitor).equals(other$throwOnApplicableTestVisitor)) {
            return false;
        }
        Boolean this$throwOnSingleSourceApplicableTest = this.getThrowOnSingleSourceApplicableTest();
        Boolean other$throwOnSingleSourceApplicableTest = other.getThrowOnSingleSourceApplicableTest();
        if (this$throwOnSingleSourceApplicableTest == null ? other$throwOnSingleSourceApplicableTest != null : !((Object)this$throwOnSingleSourceApplicableTest).equals(other$throwOnSingleSourceApplicableTest)) {
            return false;
        }
        Boolean this$throwOnSingleSourceApplicableTestVisitor = this.getThrowOnSingleSourceApplicableTestVisitor();
        Boolean other$throwOnSingleSourceApplicableTestVisitor = other.getThrowOnSingleSourceApplicableTestVisitor();
        if (this$throwOnSingleSourceApplicableTestVisitor == null ? other$throwOnSingleSourceApplicableTestVisitor != null : !((Object)this$throwOnSingleSourceApplicableTestVisitor).equals(other$throwOnSingleSourceApplicableTestVisitor)) {
            return false;
        }
        String this$throwOnMethodPattern = this.getThrowOnMethodPattern();
        String other$throwOnMethodPattern = other.getThrowOnMethodPattern();
        return !(this$throwOnMethodPattern == null ? other$throwOnMethodPattern != null : !this$throwOnMethodPattern.equals(other$throwOnMethodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RecipeExceptionDemonstration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $throwOnVisitAll = this.getThrowOnVisitAll();
        result = result * 59 + ($throwOnVisitAll == null ? 43 : ((Object)$throwOnVisitAll).hashCode());
        Boolean $throwOnVisitAllVisitor = this.getThrowOnVisitAllVisitor();
        result = result * 59 + ($throwOnVisitAllVisitor == null ? 43 : ((Object)$throwOnVisitAllVisitor).hashCode());
        Boolean $throwOnApplicableTest = this.getThrowOnApplicableTest();
        result = result * 59 + ($throwOnApplicableTest == null ? 43 : ((Object)$throwOnApplicableTest).hashCode());
        Boolean $throwOnApplicableTestVisitor = this.getThrowOnApplicableTestVisitor();
        result = result * 59 + ($throwOnApplicableTestVisitor == null ? 43 : ((Object)$throwOnApplicableTestVisitor).hashCode());
        Boolean $throwOnSingleSourceApplicableTest = this.getThrowOnSingleSourceApplicableTest();
        result = result * 59 + ($throwOnSingleSourceApplicableTest == null ? 43 : ((Object)$throwOnSingleSourceApplicableTest).hashCode());
        Boolean $throwOnSingleSourceApplicableTestVisitor = this.getThrowOnSingleSourceApplicableTestVisitor();
        result = result * 59 + ($throwOnSingleSourceApplicableTestVisitor == null ? 43 : ((Object)$throwOnSingleSourceApplicableTestVisitor).hashCode());
        String $throwOnMethodPattern = this.getThrowOnMethodPattern();
        result = result * 59 + ($throwOnMethodPattern == null ? 43 : $throwOnMethodPattern.hashCode());
        return result;
    }

    public static class DemonstrationException
    extends RuntimeException {
        static boolean restrictStackTrace = false;

        public DemonstrationException(String message) {
            super(message);
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (restrictStackTrace) {
                ArrayList<StackTraceElement> restricted = new ArrayList<StackTraceElement>();
                for (StackTraceElement ste : super.getStackTrace()) {
                    if (!ste.getClassName().startsWith(RecipeExceptionDemonstration.class.getName() + "$")) continue;
                    restricted.add(ste);
                }
                return restricted.toArray(new StackTraceElement[0]);
            }
            return super.getStackTrace();
        }
    }
}

