/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;

public final class RecipeMarkupDemonstration
extends Recipe {
    @Option(displayName="Level", description="The `Markup#Level` to add.", valid={"debug", "info", "warning", "error"})
    private final String level;

    public String getDisplayName() {
        return "Demonstrate rendering of `Markup` markers.";
    }

    public String getDescription() {
        return "Tooling may decide to elide or display differently markup of different levels.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return ListUtils.mapFirst(before, sourceFile -> (SourceFile)Markup.markup((Tree)sourceFile, (Markup.Level)Markup.Level.valueOf((String)this.level.toUpperCase()), (String)("This is a " + this.level + " message.")));
    }

    public RecipeMarkupDemonstration(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    @NonNull
    public String toString() {
        return "RecipeMarkupDemonstration(level=" + this.getLevel() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeMarkupDemonstration)) {
            return false;
        }
        RecipeMarkupDemonstration other = (RecipeMarkupDemonstration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RecipeMarkupDemonstration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }
}

