/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class FindMissingTypes
extends Recipe {
    public String getDisplayName() {
        return "Find missing type information on Java ASTs";
    }

    public String getDescription() {
        return "This is a diagnostic recipe to highlight where ASTs are missing type attribution information.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new FindMissingTypesVisitor();
    }

    public static List<MissingTypeResult> findMissingTypes(J j) {
        J j1 = (J)new FindMissingTypesVisitor().visit(j, new InMemoryExecutionContext());
        ArrayList<MissingTypeResult> results = new ArrayList<MissingTypeResult>();
        if (j1 != j) {
            new JavaIsoVisitor<List<MissingTypeResult>>(){

                public <M extends Marker> M visitMarker(Marker marker, List<MissingTypeResult> missingTypeResults) {
                    if (marker instanceof SearchResult) {
                        String message = ((SearchResult)marker).getDescription();
                        String path = this.getCursor().getPathAsStream().filter(J.class::isInstance).map(t -> t.getClass().getSimpleName()).collect(Collectors.joining("->"));
                        J j = (J)this.getCursor().firstEnclosing(J.class);
                        String printedTree = this.getCursor().firstEnclosing(JavaSourceFile.class) != null ? (j != null ? j.printTrimmed(new InMemoryExecutionContext(), this.getCursor()) : "") : String.valueOf(j);
                        missingTypeResults.add(new MissingTypeResult(message, path, printedTree, j));
                    }
                    return (M)super.visitMarker(marker, missingTypeResults);
                }
            }.visit(j1, results);
        }
        return results;
    }

    static class FindMissingTypesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        FindMissingTypesVisitor() {
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            J ident = super.visitIdentifier(identifier, ctx);
            if (!TypeUtils.isWellFormedType(((J.Identifier)ident).getType()) && !this.isAllowedToHaveNullType((J.Identifier)ident)) {
                ident = ((J.Identifier)ident).withMarkers(((J.Identifier)ident).getMarkers().searchResult("Identifier type is null"));
            }
            return ident;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J mi = super.visitMethodInvocation(method, ctx);
            JavaType.Method type = ((J.MethodInvocation)mi).getMethodType();
            if (!TypeUtils.isWellFormedType(type)) {
                mi = ((J.MethodInvocation)mi).withMarkers(((J.MethodInvocation)mi).getMarkers().searchResult("MethodInvocation type is null"));
            } else if (!type.getName().equals(((J.MethodInvocation)mi).getSimpleName()) && !type.isConstructor()) {
                mi = ((J.MethodInvocation)mi).withMarkers(((J.MethodInvocation)mi).getMarkers().searchResult("type information has a different method name '" + type.getName() + "'"));
            }
            return mi;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J md = super.visitMethodDeclaration(method, ctx);
            JavaType.Method type = ((J.MethodDeclaration)md).getMethodType();
            if (!TypeUtils.isWellFormedType(type)) {
                md = ((J.MethodDeclaration)md).withMarkers(((J.MethodDeclaration)md).getMarkers().searchResult("MethodDeclaration type is null"));
            } else if (!((J.MethodDeclaration)md).getSimpleName().equals(type.getName()) && !type.isConstructor()) {
                md = ((J.MethodDeclaration)md).withMarkers(((J.MethodDeclaration)md).getMarkers().searchResult("type information has a different method name '" + type.getName() + "'"));
            }
            return md;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.Package pkg;
            J.CompilationUnit jc;
            J cd = super.visitClassDeclaration(classDecl, ctx);
            JavaType.FullyQualified t = ((J.ClassDeclaration)cd).getType();
            if (!TypeUtils.isWellFormedType(t)) {
                return ((J.ClassDeclaration)cd).withMarkers(((J.ClassDeclaration)cd).getMarkers().searchResult("ClassDeclaration type is null"));
            }
            if (!((J.ClassDeclaration)cd).getKind().name().equals(t.getKind().name())) {
                cd = ((J.ClassDeclaration)cd).withMarkers(((J.ClassDeclaration)cd).getMarkers().searchResult(" J.ClassDeclaration kind " + (Object)((Object)((J.ClassDeclaration)cd).getKind()) + " does not match the kind in its type information " + (Object)((Object)t.getKind())));
            }
            if ((jc = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class)) != null && (pkg = jc.getPackageDeclaration()) != null && t.getPackageName().equals(pkg.printTrimmed(this.getCursor()))) {
                cd = ((J.ClassDeclaration)cd).withMarkers(((J.ClassDeclaration)cd).getMarkers().searchResult(" J.ClassDeclaration package " + pkg + " does not match the package in its type information " + pkg.printTrimmed(this.getCursor())));
            }
            return cd;
        }

        private boolean isAllowedToHaveNullType(J.Identifier ident) {
            return this.inPackageDeclaration() || this.inImport() || this.isClassName() || this.isMethodName() || this.isMethodInvocationName() || this.isFieldAccess(ident) || this.isBeingDeclared(ident) || this.isParameterizedType(ident) || this.isNewClass(ident) || this.isTypeParameter() || this.isMemberReference() || this.isCaseLabel() || this.isLabel() || this.isAnnotationField(ident);
        }

        private boolean inPackageDeclaration() {
            return this.getCursor().firstEnclosing(J.Package.class) != null;
        }

        private boolean inImport() {
            return this.getCursor().firstEnclosing(J.Import.class) != null;
        }

        private boolean isClassName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.ClassDeclaration;
        }

        private boolean isMethodName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.MethodDeclaration;
        }

        private boolean isMethodInvocationName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.MethodInvocation;
        }

        private boolean isFieldAccess(J.Identifier ident) {
            J.FieldAccess parent = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
            return parent != null && (parent.getName().equals(ident) || parent.getTarget().equals(ident));
        }

        private boolean isBeingDeclared(J.Identifier ident) {
            J.VariableDeclarations.NamedVariable parent = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
            return parent != null && parent.getName().equals(ident);
        }

        private boolean isParameterizedType(J.Identifier ident) {
            J.ParameterizedType parent = (J.ParameterizedType)this.getCursor().firstEnclosing(J.ParameterizedType.class);
            return parent != null && ident.equals(parent.getClazz());
        }

        private boolean isNewClass(J.Identifier ident) {
            J.NewClass parent = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
            return parent != null && ident.equals(parent.getClazz());
        }

        private boolean isTypeParameter() {
            return this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.TypeParameter;
        }

        private boolean isMemberReference() {
            return this.getCursor().firstEnclosing(J.MemberReference.class) != null;
        }

        private boolean isCaseLabel() {
            return this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.Case;
        }

        private boolean isLabel() {
            return this.getCursor().firstEnclosing(J.Label.class) != null;
        }

        private boolean isAnnotationField(J.Identifier ident) {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.Assignment && ident.equals(((J.Assignment)parent.getValue()).getVariable()) && this.getCursor().firstEnclosing(J.Annotation.class) != null;
        }
    }

    public static class MissingTypeResult {
        String message;
        String path;
        String printedTree;
        J j;

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public String getPrintedTree() {
            return this.printedTree;
        }

        public J getJ() {
            return this.j;
        }

        public MissingTypeResult(String message, String path, String printedTree, J j) {
            this.message = message;
            this.path = path;
            this.printedTree = printedTree;
            this.j = j;
        }
    }
}

