/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.FormalParameterVisitor;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    private Pattern targetTypePattern;
    private Pattern methodNamePattern;
    private Pattern argumentPattern;
    private final boolean matchOverrides;

    public MethodMatcher(String signature, @Nullable Boolean matchOverrides) {
        this(signature, Boolean.TRUE.equals(matchOverrides));
    }

    public MethodMatcher(String signature, boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
        MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)signature))));
        new MethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(MethodSignatureParser.MethodPatternContext ctx) {
                MethodMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx.targetTypePattern()));
                MethodMatcher.this.methodNamePattern = Pattern.compile(ctx.simpleNamePattern().children.stream().map(c -> StringUtils.aspectjNameToPattern((String)c.toString())).collect(Collectors.joining("")));
                MethodMatcher.this.argumentPattern = Pattern.compile(new FormalParameterVisitor().visitFormalParametersPattern(ctx.formalParametersPattern()));
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    public MethodMatcher(J.MethodDeclaration method, boolean matchOverrides) {
        this(MethodMatcher.methodPattern(method), matchOverrides);
    }

    public MethodMatcher(String signature) {
        this(signature, false);
    }

    public MethodMatcher(J.MethodDeclaration method) {
        this(method, false);
    }

    public MethodMatcher(JavaType.Method method) {
        this(MethodMatcher.methodPattern(method), false);
    }

    public boolean matches(@Nullable JavaType.Method type) {
        if (type == null) {
            return false;
        }
        if (!this.matchesTargetType(type.getDeclaringType()) || !this.methodNamePattern.matcher(type.getName()).matches()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : type.getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    public boolean matches(J.MethodDeclaration method, J.ClassDeclaration enclosing) {
        boolean matchesTargetType;
        if (enclosing.getType() == null) {
            return false;
        }
        boolean bl = matchesTargetType = "[^.]*".equals(this.targetTypePattern.toString()) || this.matchesTargetType(enclosing.getType());
        if (!matchesTargetType) {
            return false;
        }
        boolean matchesMethodName = this.methodNamePattern.matcher(method.getSimpleName()).matches() || method.getMethodType() != null && this.methodNamePattern.matcher(method.getMethodType().getName()).matches();
        String arguments = method.getParameters().stream().map(this::variableDeclarationsType).filter(Objects::nonNull).map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","));
        return matchesMethodName && this.argumentPattern.matcher(arguments).matches();
    }

    @Nullable
    private JavaType variableDeclarationsType(Statement v) {
        if (v instanceof J.VariableDeclarations) {
            J.VariableDeclarations vd = (J.VariableDeclarations)v;
            List<J.VariableDeclarations.NamedVariable> variables = vd.getVariables();
            if (!variables.isEmpty() && variables.get(0).getType() != null) {
                return variables.get(0).getType();
            }
            if (vd.getTypeAsFullyQualified() != null) {
                return vd.getTypeAsFullyQualified();
            }
            return vd.getTypeExpression() != null ? vd.getTypeExpression().getType() : null;
        }
        return null;
    }

    public boolean matches(@Nullable Expression maybeMethod) {
        return maybeMethod instanceof J.MethodInvocation && this.matches((J.MethodInvocation)maybeMethod) || maybeMethod instanceof J.NewClass && this.matches((J.NewClass)maybeMethod);
    }

    public boolean matches(@Nullable J.MethodInvocation method) {
        return this.matches(method, false);
    }

    public boolean matches(@Nullable J.MethodInvocation method, boolean matchUnknownTypes) {
        if (method == null) {
            return false;
        }
        if (method.getMethodType() == null) {
            return matchUnknownTypes && this.matchesAllowingUnknownTypes(method);
        }
        if (!this.matchesTargetType(method.getMethodType().getDeclaringType()) || !this.methodNamePattern.matcher(method.getSimpleName()).matches()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : method.getMethodType().getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    private boolean matchesAllowingUnknownTypes(J.MethodInvocation method) {
        if (!this.methodNamePattern.matcher(method.getSimpleName()).matches()) {
            return false;
        }
        if (method.getSelect() != null && method.getSelect() instanceof J.Identifier && !this.matchesSelectBySimpleNameAlone((J.Identifier)method.getSelect())) {
            return false;
        }
        String argumentSignature = this.argumentsFromExpressionTypes(method);
        Pattern relaxedArgumentPattern = Pattern.compile(this.argumentPattern.pattern().replaceAll("((?:[a-zA-Z0-9]+\\.?)+)", "($1|" + JavaType.Unknown.getInstance().getFullyQualifiedName() + ")"));
        return relaxedArgumentPattern.matcher(argumentSignature).matches();
    }

    private boolean matchesSelectBySimpleNameAlone(J.Identifier select) {
        return this.targetTypePattern.matcher(select.getSimpleName()).matches() || Pattern.compile(this.targetTypePattern.toString().replaceAll(".*" + Pattern.quote(StringUtils.aspectjNameToPattern((String)".")), "").replaceAll(".*" + Pattern.quote(StringUtils.aspectjNameToPattern((String)"..")), "")).matcher(select.getSimpleName()).matches();
    }

    private String argumentsFromExpressionTypes(J.MethodInvocation method) {
        StringJoiner joiner = new StringJoiner(",");
        for (Expression expr : method.getArguments()) {
            JavaType exprType = expr.getType();
            String s = exprType == null ? JavaType.Unknown.getInstance().getFullyQualifiedName() : MethodMatcher.typePattern(exprType);
            joiner.add(s);
        }
        return joiner.toString();
    }

    public boolean matches(J.NewClass constructor) {
        JavaType.FullyQualified type = TypeUtils.asFullyQualified(constructor.getType());
        if (type == null || constructor.getConstructorType() == null) {
            return false;
        }
        if (!this.matchesTargetType(type) || !this.methodNamePattern.matcher("<constructor>").matches()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : constructor.getConstructorType().getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        if (this.targetTypePattern.matcher(type.getFullyQualifiedName()).matches()) {
            return true;
        }
        if (this.matchOverrides) {
            if (!"java.lang.Object".equals(type.getFullyQualifiedName()) && this.matchesTargetType(JavaType.ShallowClass.build("java.lang.Object"))) {
                return true;
            }
            if (this.matchesTargetType(type.getSupertype())) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!this.matchesTargetType(anInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFullyQualifiedClassReference(J.FieldAccess fieldAccess) {
        String hopefullyFullyQualifiedMethod = this.getTargetTypePattern().pattern().replaceAll(Pattern.quote(StringUtils.aspectjNameToPattern((String)".")), ".") + "." + this.getMethodNamePattern().pattern();
        return fieldAccess.isFullyQualifiedClassReference(hopefullyFullyQualifiedMethod);
    }

    @Nullable
    private static String typePattern(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            if (type.equals(JavaType.Primitive.String)) {
                return ((JavaType.Primitive)type).getClassName();
            }
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            JavaType elemType = ((JavaType.Array)type).getElemType();
            return MethodMatcher.typePattern(elemType) + "[]";
        }
        return null;
    }

    public static String methodPattern(J.MethodDeclaration method) {
        assert (method.getMethodType() != null);
        return MethodMatcher.methodPattern(method.getMethodType());
    }

    public static String methodPattern(JavaType.Method method) {
        StringJoiner parameters = new StringJoiner(",");
        for (JavaType javaType : method.getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            parameters.add(s);
        }
        return MethodMatcher.typePattern(method.getDeclaringType()) + " " + method.getName() + "(" + parameters + ")";
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public Pattern getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public Pattern getArgumentPattern() {
        return this.argumentPattern;
    }

    public boolean isMatchOverrides() {
        return this.matchOverrides;
    }
}

