/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.controlflow.ControlFlow;
import org.openrewrite.java.controlflow.ControlFlowDotFileGenerator;
import org.openrewrite.java.controlflow.ControlFlowNode;
import org.openrewrite.java.controlflow.ControlFlowSummary;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.DotResult;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

@Incubating(since="7.26.0")
final class ControlFlowVisualizationVisitor<P>
extends JavaIsoVisitor<P> {
    private static final String CONTROL_FLOW_SUMMARY_CURSOR_MESSAGE = "CONTROL_FLOW_SUMMARY";
    @Nullable
    private final ControlFlowDotFileGenerator dotFileGenerator;
    private final boolean darkMode;

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        String dotFile = (String)this.getCursor().pollMessage(CONTROL_FLOW_SUMMARY_CURSOR_MESSAGE);
        if (dotFile != null) {
            return ((J.MethodDeclaration)m).withMarkers(((J.MethodDeclaration)m).getMarkers().add((Marker)new DotResult(Tree.randomId(), dotFile)));
        }
        return m;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
        boolean isMethodDeclaration = methodDeclaration != null && methodDeclaration.getBody() == b;
        boolean isStaticOrInitBlock = J.Block.isStaticOrInitBlock(this.getCursor());
        if (isMethodDeclaration || isStaticOrInitBlock) {
            return ControlFlow.startingAt(this.getCursor()).findControlFlow().map(arg_0 -> this.lambda$visitBlock$0(methodDeclaration, (J.Block)b, isMethodDeclaration, arg_0)).orElse((J.Block)b);
        }
        return b;
    }

    private static String getPredecessors(Map<J, ControlFlowNode> leadersToNodes, Map<ControlFlowNode, Integer> blockNumbers, J leader) {
        if (leader instanceof J.ControlParentheses) {
            J.ControlParentheses leaderControlParentheses = (J.ControlParentheses)leader;
            ControlFlowNode block = leadersToNodes.get(leaderControlParentheses.getTree());
            List predecessors = block.getPredecessors().stream().map(blockNumbers::get).map(Object::toString).collect(Collectors.toList());
            return "Predecessors: " + String.join((CharSequence)", ", predecessors);
        }
        ControlFlowNode block = leadersToNodes.get(leader);
        List predecessors = block.getPredecessors().stream().map(blockNumbers::get).map(Object::toString).collect(Collectors.toList());
        return "Predecessors: " + String.join((CharSequence)", ", predecessors);
    }

    public ControlFlowVisualizationVisitor(@Nullable ControlFlowDotFileGenerator dotFileGenerator, boolean darkMode) {
        this.dotFileGenerator = dotFileGenerator;
        this.darkMode = darkMode;
    }

    private /* synthetic */ J.Block lambda$visitBlock$0(J.MethodDeclaration methodDeclaration, J.Block b, boolean isMethodDeclaration, ControlFlowSummary controlFlow) {
        Map leadersToBlocks = controlFlow.getBasicBlocks().stream().collect(Collectors.toMap(ControlFlowNode.BasicBlock::getLeader, Function.identity()));
        Map conditionToConditionNodes = controlFlow.getConditionNodes().stream().collect(Collectors.toMap(ControlFlowNode.ConditionNode::getCondition, Function.identity()));
        assert (conditionToConditionNodes.values().stream().map(ControlFlowNode.ConditionNode::asGuard).allMatch(Objects::nonNull)) : "Condition nodes must all be guards";
        this.doAfterVisit(new ControlFlowMarkingVisitor("L", leadersToBlocks));
        this.doAfterVisit(new ControlFlowMarkingVisitor("C", conditionToConditionNodes));
        String searchResultText = "BB: " + controlFlow.getBasicBlocks().size() + " CN: " + controlFlow.getConditionNodeCount() + " EX: " + controlFlow.getExitCount();
        if (this.dotFileGenerator != null) {
            String graphName = methodDeclaration != null ? methodDeclaration.getSimpleName() : (b.isStatic() ? "static block" : "init block");
            String dotFile = this.dotFileGenerator.visualizeAsDotfile(graphName, this.darkMode, controlFlow);
            if (isMethodDeclaration) {
                this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).putMessage(CONTROL_FLOW_SUMMARY_CURSOR_MESSAGE, (Object)dotFile);
            } else {
                return b.withMarkers(b.getMarkers().searchResult(searchResultText).add((Marker)new DotResult(Tree.randomId(), dotFile)));
            }
        }
        return b.withMarkers(b.getMarkers().searchResult(searchResultText));
    }

    private static class ControlFlowMarkingVisitor<P>
    extends JavaIsoVisitor<P> {
        private final String label;
        private final Map<J, ? extends ControlFlowNode> nodeToBlock;
        private int nodeNumber = 0;
        private final Map<ControlFlowNode, Integer> nodeNumbers = new HashMap<ControlFlowNode, Integer>();

        @Override
        public Statement visitStatement(Statement statement, P p) {
            if (this.nodeToBlock.containsKey(statement)) {
                Optional<SearchResult> maybeSearchResult = statement.getMarkers().getMarkers().stream().filter(SearchResult.class::isInstance).map(SearchResult.class::cast).findFirst();
                ControlFlowNode b = this.nodeToBlock.get(statement);
                assert (b != null);
                int number = this.nodeNumbers.computeIfAbsent(b, __ -> ++this.nodeNumber);
                if (maybeSearchResult.isPresent()) {
                    SearchResult searchResult = maybeSearchResult.get();
                    String newDescription = (searchResult.getDescription() == null ? "" : searchResult.getDescription()) + " | " + number + this.label;
                    return (Statement)statement.withMarkers(statement.getMarkers().removeByType(SearchResult.class).add((Marker)searchResult.withDescription(newDescription)));
                }
                return (Statement)statement.withMarkers(statement.getMarkers().searchResult("" + number + this.label));
            }
            return statement;
        }

        @Override
        public Expression visitExpression(Expression expression, P p) {
            if (this.nodeToBlock.containsKey(expression)) {
                ControlFlowNode b = this.nodeToBlock.get(expression);
                assert (b != null);
                int number = this.nodeNumbers.computeIfAbsent(b, __ -> ++this.nodeNumber);
                return (Expression)expression.withMarkers(expression.getMarkers().searchResult(number + this.labelDescription(expression)));
            }
            return expression;
        }

        @Override
        public J.If.Else visitElse(J.If.Else elze, P p) {
            if (this.nodeToBlock.containsKey(elze)) {
                ControlFlowNode b = this.nodeToBlock.get(elze);
                assert (b != null);
                int number = this.nodeNumbers.computeIfAbsent(b, __ -> ++this.nodeNumber);
                return elze.withMarkers(elze.getMarkers().searchResult(number + this.labelDescription(elze)));
            }
            return elze;
        }

        private String labelDescription(J j) {
            String tag = ControlFlowMarkingVisitor.labelTag(j);
            if (tag == null) {
                return this.label;
            }
            return this.label + " (" + tag + ')';
        }

        @Nullable
        private static String labelTag(J j) {
            if (j instanceof J.Binary) {
                J.Binary binary = (J.Binary)j;
                switch (binary.getOperator()) {
                    case And: {
                        return "&&";
                    }
                    case Or: {
                        return "||";
                    }
                    case Addition: {
                        return "+";
                    }
                    case Subtraction: {
                        return "-";
                    }
                    case Multiplication: {
                        return "*";
                    }
                    case Division: {
                        return "/";
                    }
                    case Modulo: {
                        return "%";
                    }
                    case LessThan: {
                        return "<";
                    }
                    case LessThanOrEqual: {
                        return "<=";
                    }
                    case GreaterThan: {
                        return ">";
                    }
                    case GreaterThanOrEqual: {
                        return ">=";
                    }
                    case Equal: {
                        return "==";
                    }
                    case NotEqual: {
                        return "!=";
                    }
                    case BitAnd: {
                        return "&";
                    }
                    case BitOr: {
                        return "|";
                    }
                    case BitXor: {
                        return "^";
                    }
                    case LeftShift: {
                        return "<<";
                    }
                    case RightShift: {
                        return ">>";
                    }
                    case UnsignedRightShift: {
                        return ">>>";
                    }
                }
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)binary.getOperator()));
            }
            return null;
        }

        public ControlFlowMarkingVisitor(String label, Map<J, ? extends ControlFlowNode> nodeToBlock) {
            this.label = label;
            this.nodeToBlock = nodeToBlock;
        }
    }
}

