/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public final class RecipeExceptionDemonstration
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;

    public String getDisplayName() {
        return "Demonstrate rendering of recipe exceptions";
    }

    public String getDescription() {
        return "Show how recipe exceptions are rendered in various forms of OpenRewrite tooling.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final MethodMatcher methodMatcher;
            {
                this.methodMatcher = new MethodMatcher(RecipeExceptionDemonstration.this.methodPattern);
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (this.methodMatcher.matches(method)) {
                    throw new DemonstrationException("Demonstrating an exception thrown on a matching method.");
                }
                return super.visitMethodInvocation(method, executionContext);
            }
        };
    }

    public RecipeExceptionDemonstration(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String toString() {
        return "RecipeExceptionDemonstration(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeExceptionDemonstration)) {
            return false;
        }
        RecipeExceptionDemonstration other = (RecipeExceptionDemonstration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RecipeExceptionDemonstration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    public static class DemonstrationException
    extends RuntimeException {
        static boolean restrictStackTrace = false;

        public DemonstrationException(String message) {
            super(message);
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (restrictStackTrace) {
                ArrayList<StackTraceElement> restricted = new ArrayList<StackTraceElement>();
                for (StackTraceElement ste : super.getStackTrace()) {
                    if (!ste.getClassName().startsWith(RecipeExceptionDemonstration.class.getName() + "$")) continue;
                    restricted.add(ste);
                }
                return restricted.toArray(new StackTraceElement[0]);
            }
            return super.getStackTrace();
        }
    }
}

