/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public class JavaVisitor<P>
extends TreeVisitor<J, P> {
    @Nullable
    protected JavadocVisitor<P> javadocVisitor;

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JavaSourceFile;
    }

    public String getLanguage() {
        return "java";
    }

    protected JavadocVisitor<P> getJavadocVisitor() {
        return new JavadocVisitor(this);
    }

    public void maybeAddImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeAddImport(clazz.getFullyQualifiedName());
        }
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, P p) {
        return this.maybeAutoFormat(before, after, p, this.getCursor());
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, P p, Cursor cursor) {
        return this.maybeAutoFormat(before, after, null, p, cursor);
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, @Nullable J stopAfter, P p, Cursor cursor) {
        if (before != after) {
            return (J2)new AutoFormatVisitor(stopAfter).visit((Tree)after, (Object)p, cursor);
        }
        return after;
    }

    public <J2 extends J> J2 autoFormat(J2 j, P p) {
        return this.autoFormat(j, p, this.getCursor());
    }

    public <J2 extends J> J2 autoFormat(J2 j, P p, Cursor cursor) {
        return this.autoFormat(j, null, p, cursor);
    }

    public <J2 extends J> J2 autoFormat(J2 j, @Nullable J stopAfter, P p, Cursor cursor) {
        return (J2)new AutoFormatVisitor(stopAfter).visit((Tree)j, (Object)p, cursor);
    }

    public void maybeAddImport(String fullyQualifiedName) {
        AddImport op = new AddImport(fullyQualifiedName, null, true);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeAddImport(String fullyQualifiedName, String statik) {
        AddImport op = new AddImport(fullyQualifiedName, statik, true);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeRemoveImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeRemoveImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeRemoveImport(String fullyQualifiedName) {
        RemoveImport op = new RemoveImport(fullyQualifiedName);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public J visitExpression(Expression expression, P p) {
        return expression;
    }

    public J visitStatement(Statement statement, P p) {
        return statement;
    }

    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space;
        s = s.withComments(ListUtils.map(s.getComments(), comment -> {
            if (comment instanceof Javadoc) {
                if (this.javadocVisitor == null) {
                    this.javadocVisitor = this.getJavadocVisitor();
                }
                return (Comment)this.javadocVisitor.visit((Javadoc)((Object)comment), p);
            }
            return comment;
        }));
        return s;
    }

    @Nullable
    public JavaType visitType(@Nullable JavaType javaType, P p) {
        return javaType;
    }

    public <N extends NameTree> N visitTypeName(N nameTree, P p) {
        return nameTree;
    }

    @Nullable
    private <N extends NameTree> JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement(this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    @Nullable
    private <N extends NameTree> JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement(this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    @Nullable
    private <J2 extends J> JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map(nameTrees.getPadding().getElements(), t -> t.getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build(nameTrees.getBefore(), js, Markers.EMPTY);
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.AnnotatedType)) {
            return temp;
        }
        a = (J.AnnotatedType)temp;
        a = a.withAnnotations(ListUtils.map(a.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)));
        a = a.withTypeExpression((TypeTree)this.visitAndCast(a.getTypeExpression(), p));
        a = a.withTypeExpression(this.visitTypeName(a.getTypeExpression(), p));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitAnnotation(J.Annotation annotation, P p) {
        J.Annotation a = annotation;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.Annotation)) {
            return temp;
        }
        a = (J.Annotation)temp;
        if (a.getPadding().getArguments() != null) {
            a = a.getPadding().withArguments(this.visitContainer(a.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, p));
        }
        a = a.withAnnotationType((NameTree)this.visitAndCast(a.getAnnotationType(), p));
        a = a.withAnnotationType(this.visitTypeName(a.getAnnotationType(), p));
        return a;
    }

    public J visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J.ArrayAccess a = arrayAccess;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_ACCESS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.ArrayAccess)) {
            return temp;
        }
        a = (J.ArrayAccess)temp;
        a = a.withIndexed((Expression)this.visitAndCast(a.getIndexed(), p));
        a = a.withDimension((J.ArrayDimension)this.visitAndCast(a.getDimension(), p));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        J.ArrayDimension a = arrayDimension;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.DIMENSION_PREFIX, p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.getPadding().withIndex(this.visitRightPadded(a.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, p));
        return a;
    }

    public J visitArrayType(J.ArrayType arrayType, P p) {
        J.ArrayType a = arrayType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.ArrayType)) {
            return temp;
        }
        a = (J.ArrayType)temp;
        a = a.withElementType((TypeTree)this.visitAndCast(a.getElementType(), p));
        a = a.withElementType(this.visitTypeName(a.getElementType(), p));
        a = a.withDimensions(ListUtils.map(a.getDimensions(), dim -> this.visitRightPadded(dim.withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p)), JRightPadded.Location.DIMENSION, p)));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitAssert(J.Assert azzert, P p) {
        J.Assert a = azzert;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSERT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.Assert)) {
            return temp;
        }
        a = (J.Assert)temp;
        if ((a = a.withCondition((Expression)this.visitAndCast(a.getCondition(), p))).getDetail() != null) {
            a = a.withDetail(this.visitLeftPadded(a.getDetail(), JLeftPadded.Location.ASSERT_DETAIL, p));
        }
        return a;
    }

    public J visitAssignment(J.Assignment assignment, P p) {
        J.Assignment a = assignment;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.Assignment)) {
            return temp;
        }
        a = (J.Assignment)temp;
        Expression temp2 = (Expression)this.visitExpression(a, p);
        if (!(temp2 instanceof J.Assignment)) {
            return temp2;
        }
        a = (J.Assignment)temp2;
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        a = a.getPadding().withAssignment(this.visitLeftPadded(a.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, p));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        J.AssignmentOperation a = assignOp;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof J.AssignmentOperation)) {
            return temp;
        }
        a = (J.AssignmentOperation)temp;
        Expression temp2 = (Expression)this.visitExpression(a, p);
        if (!(temp2 instanceof J.AssignmentOperation)) {
            return temp2;
        }
        a = (J.AssignmentOperation)temp2;
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        a = a.getPadding().withOperator(this.visitLeftPadded(a.getPadding().getOperator(), JLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p));
        a = a.withAssignment((Expression)this.visitAndCast(a.getAssignment(), p));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitBinary(J.Binary binary, P p) {
        J.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof J.Binary)) {
            return temp;
        }
        b = (J.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast(b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), JLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast(b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitBlock(J.Block block, P p) {
        J.Block b = block;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BLOCK_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof J.Block)) {
            return temp;
        }
        b = (J.Block)temp;
        b = b.getPadding().withStatic(this.visitRightPadded(b.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p));
        b = b.getPadding().withStatements(ListUtils.map(b.getPadding().getStatements(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.BLOCK_STATEMENT, p)));
        b = b.withEnd(this.visitSpace(b.getEnd(), Space.Location.BLOCK_END, p));
        return b;
    }

    public J visitBreak(J.Break breakStatement, P p) {
        J.Break b = breakStatement;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BREAK_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof J.Break)) {
            return temp;
        }
        b = (J.Break)temp;
        b = b.withLabel((J.Identifier)this.visitAndCast(b.getLabel(), p));
        return b;
    }

    public J visitCase(J.Case caze, P p) {
        J.Case c = caze;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CASE_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof J.Case)) {
            return temp;
        }
        c = (J.Case)temp;
        c = c.withPattern((Expression)this.visitAndCast(c.getPattern(), p));
        c = c.getPadding().withStatements(this.visitContainer(c.getPadding().getStatements(), JContainer.Location.CASE, p));
        return c;
    }

    public J visitCatch(J.Try.Catch catzh, P p) {
        J.Try.Catch c = catzh;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CATCH_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withParameter((J.ControlParentheses)this.visitAndCast(c.getParameter(), p));
        c = c.withBody((J.Block)this.visitAndCast(c.getBody(), p));
        return c;
    }

    public J visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration c = classDecl;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CLASS_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof J.ClassDeclaration)) {
            return temp;
        }
        c = (J.ClassDeclaration)temp;
        c = c.withLeadingAnnotations(ListUtils.map(c.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p)));
        c = c.getAnnotations().withKind(classDecl.getAnnotations().getKind().withAnnotations(ListUtils.map(classDecl.getAnnotations().getKind().getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        c = c.getAnnotations().withKind(c.getAnnotations().getKind().withPrefix(this.visitSpace(c.getAnnotations().getKind().getPrefix(), Space.Location.CLASS_KIND, p)));
        if ((c = c.withName((J.Identifier)this.visitAndCast(c.getName(), p))).getPadding().getTypeParameters() != null) {
            c = c.getPadding().withTypeParameters(this.visitContainer(c.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        if (c.getPadding().getExtends() != null) {
            c = c.getPadding().withExtends(this.visitLeftPadded(c.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p));
        }
        if ((c = c.getPadding().withExtends(this.visitTypeName(c.getPadding().getExtends(), p))).getPadding().getImplements() != null) {
            c = c.getPadding().withImplements(this.visitContainer(c.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, p));
        }
        c = c.getPadding().withImplements(this.visitTypeNames(c.getPadding().getImplements(), p));
        c = c.withBody((J.Block)this.visitAndCast(c.getBody(), p));
        c = c.withType(this.visitType(c.getType(), p));
        return c;
    }

    public J visitJavaSourceFile(JavaSourceFile cu, P p) {
        return cu instanceof J.CompilationUnit ? this.visitCompilationUnit((J.CompilationUnit)cu, p) : cu;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        JavaSourceFile c = cu;
        c = ((J.CompilationUnit)c).withPrefix(this.visitSpace(((J.CompilationUnit)c).getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        if (((J.CompilationUnit)(c = ((J.CompilationUnit)c).withMarkers(this.visitMarkers(((J.CompilationUnit)c).getMarkers(), p)))).getPadding().getPackageDeclaration() != null) {
            c = ((J.CompilationUnit)c).getPadding().withPackageDeclaration(this.visitRightPadded(((J.CompilationUnit)c).getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, p));
        }
        c = ((J.CompilationUnit)c).getPadding().withImports(ListUtils.map(((J.CompilationUnit)c).getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = ((J.CompilationUnit)c).withClasses(ListUtils.map(((J.CompilationUnit)c).getClasses(), e -> (J.ClassDeclaration)this.visitAndCast((Tree)e, p)));
        c = ((J.CompilationUnit)c).withEof(this.visitSpace(((J.CompilationUnit)c).getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitContinue(J.Continue continueStatement, P p) {
        J.Continue c = continueStatement;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CONTINUE_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof J.Continue)) {
            return temp;
        }
        c = (J.Continue)temp;
        c = c.withLabel((J.Identifier)this.visitAndCast(c.getLabel(), p));
        return c;
    }

    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        J cp = controlParens;
        Expression temp = (Expression)this.visitExpression((Expression)(cp = cp.withPrefix(this.visitSpace(cp.getPrefix(), Space.Location.CONTROL_PARENTHESES_PREFIX, p))), p);
        if (!(temp instanceof J.ControlParentheses)) {
            return temp;
        }
        cp = (J.ControlParentheses)temp;
        cp = cp.getPadding().withTree(this.visitRightPadded(cp.getPadding().getTree(), JRightPadded.Location.PARENTHESES, p));
        cp = cp.withMarkers(this.visitMarkers(cp.getMarkers(), p));
        return cp;
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J.DoWhileLoop d = doWhileLoop;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DO_WHILE_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof J.DoWhileLoop)) {
            return temp;
        }
        d = (J.DoWhileLoop)temp;
        d = d.getPadding().withWhileCondition(this.visitLeftPadded(d.getPadding().getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, p));
        d = d.getPadding().withBody(this.visitRightPadded(d.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p));
        return d;
    }

    public J visitEmpty(J.Empty empty, P p) {
        J.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EMPTY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(e = e.withMarkers(this.visitMarkers(e.getMarkers(), p)), p);
        if (!(temp instanceof J.Empty)) {
            return temp;
        }
        e = (J.Empty)temp;
        Expression temp2 = (Expression)this.visitExpression(e, p);
        if (!(temp2 instanceof J.Empty)) {
            return temp2;
        }
        e = (J.Empty)temp2;
        return e;
    }

    public J visitEnumValue(J.EnumValue enoom, P p) {
        J.EnumValue e = enoom;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_PREFIX, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withName((J.Identifier)this.visitAndCast(e.getName(), p));
        e = e.withInitializer((J.NewClass)this.visitAndCast(e.getInitializer(), p));
        e = e.withAnnotations(ListUtils.map(e.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        return e;
    }

    public J visitEnumValueSet(J.EnumValueSet enums, P p) {
        J.EnumValueSet e = enums;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_SET_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(e = e.withMarkers(this.visitMarkers(e.getMarkers(), p)), p);
        if (!(temp instanceof J.EnumValueSet)) {
            return temp;
        }
        e = (J.EnumValueSet)temp;
        e = e.getPadding().withEnums(ListUtils.map(e.getPadding().getEnums(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.ENUM_VALUE, p)));
        return e;
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J.FieldAccess f = fieldAccess;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p));
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), p));
        Expression temp = (Expression)this.visitExpression(f = this.visitTypeName(f, p), p);
        if (!(temp instanceof J.FieldAccess)) {
            return temp;
        }
        f = (J.FieldAccess)temp;
        Statement tempStat = (Statement)this.visitStatement(f, p);
        if (!(tempStat instanceof J.FieldAccess)) {
            return tempStat;
        }
        f = (J.FieldAccess)tempStat;
        f = f.withTarget((Expression)this.visitAndCast(f.getTarget(), p));
        f = f.getPadding().withName(this.visitLeftPadded(f.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p));
        f = f.withType(this.visitType(f.getType(), p));
        return f;
    }

    public J visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J.ForEachLoop f = forLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_EACH_LOOP_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof J.ForEachLoop)) {
            return temp;
        }
        f = (J.ForEachLoop)temp;
        f = f.withControl((J.ForEachLoop.Control)this.visitAndCast(f.getControl(), p));
        f = f.getPadding().withBody(this.visitRightPadded(f.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p));
        return f;
    }

    public J visitForEachControl(J.ForEachLoop.Control control, P p) {
        J.ForEachLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withVariable(this.visitRightPadded(c.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, p));
        c = c.getPadding().withIterable(this.visitRightPadded(c.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, p));
        return c;
    }

    public J visitForLoop(J.ForLoop forLoop, P p) {
        J.ForLoop f = forLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof J.ForLoop)) {
            return temp;
        }
        f = (J.ForLoop)temp;
        f = f.withControl((J.ForLoop.Control)this.visitAndCast(f.getControl(), p));
        f = f.getPadding().withBody(this.visitRightPadded(f.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p));
        return f;
    }

    public J visitForControl(J.ForLoop.Control control, P p) {
        J.ForLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_CONTROL_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withInit(ListUtils.map(c.getPadding().getInit(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.FOR_INIT, p)));
        c = c.getPadding().withCondition(this.visitRightPadded(c.getPadding().getCondition(), JRightPadded.Location.FOR_CONDITION, p));
        c = c.getPadding().withUpdate(ListUtils.map(c.getPadding().getUpdate(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.FOR_UPDATE, p)));
        return c;
    }

    public J visitIdentifier(J.Identifier ident, P p) {
        J.Identifier i = ident;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof J.Identifier)) {
            return temp;
        }
        i = (J.Identifier)temp;
        i = i.withType(this.visitType(i.getType(), p));
        i = i.withFieldType((JavaType.Variable)this.visitType(i.getFieldType(), p));
        return i;
    }

    public J visitElse(J.If.Else elze, P p) {
        J.If.Else e = elze;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ELSE_PREFIX, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.getPadding().withBody(this.visitRightPadded(e.getPadding().getBody(), JRightPadded.Location.IF_ELSE, p));
        return e;
    }

    public J visitIf(J.If iff, P p) {
        J.If i = iff;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IF_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof J.If)) {
            return temp;
        }
        i = (J.If)temp;
        i = i.withIfCondition((J.ControlParentheses)this.visitAndCast(i.getIfCondition(), p));
        i = i.getPadding().withThenPart(this.visitRightPadded(i.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, p));
        i = i.withElsePart((J.If.Else)this.visitAndCast(i.getElsePart(), p));
        return i;
    }

    public J visitImport(J.Import impoort, P p) {
        J.Import i = impoort;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IMPORT_PREFIX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.getPadding().withStatic(this.visitLeftPadded(i.getPadding().getStatic(), JLeftPadded.Location.STATIC_IMPORT, p));
        i = i.withQualid((J.FieldAccess)this.visitAndCast(i.getQualid(), p));
        return i;
    }

    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        J.InstanceOf i = instanceOf;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INSTANCEOF_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof J.InstanceOf)) {
            return temp;
        }
        i = (J.InstanceOf)temp;
        i = i.getPadding().withExpr(this.visitRightPadded(i.getPadding().getExpr(), JRightPadded.Location.INSTANCEOF, p));
        i = i.withClazz((J)this.visitAndCast(i.getClazz(), p));
        i = i.withType(this.visitType(i.getType(), p));
        return i;
    }

    public J visitLabel(J.Label label, P p) {
        J.Label l = label;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LABEL_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof J.Label)) {
            return temp;
        }
        l = (J.Label)temp;
        l = l.getPadding().withLabel(this.visitRightPadded(l.getPadding().getLabel(), JRightPadded.Location.LABEL, p));
        l = l.withStatement((Statement)this.visitAndCast(l.getStatement(), p));
        return l;
    }

    public J visitLambda(J.Lambda lambda, P p) {
        J.Lambda l = lambda;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LAMBDA_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof J.Lambda)) {
            return temp;
        }
        l = (J.Lambda)temp;
        l = l.withParameters(l.getParameters().withPrefix(this.visitSpace(l.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p)));
        l = l.withParameters(l.getParameters().getPadding().withParams(ListUtils.map(l.getParameters().getPadding().getParams(), param -> this.visitRightPadded((JRightPadded)param, JRightPadded.Location.LAMBDA_PARAM, p))));
        l = l.withParameters((J.Lambda.Parameters)this.visitAndCast(l.getParameters(), p));
        l = l.withArrow(this.visitSpace(l.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p));
        l = l.withBody((J)this.visitAndCast(l.getBody(), p));
        l = l.withType(this.visitType(l.getType(), p));
        return l;
    }

    public J visitLiteral(J.Literal literal, P p) {
        J.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof J.Literal)) {
            return temp;
        }
        l = (J.Literal)temp;
        l = l.withType(this.visitType(l.getType(), p));
        return l;
    }

    public J visitMemberReference(J.MemberReference memberRef, P p) {
        J.MemberReference m = memberRef;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        if ((m = m.getPadding().withContaining(this.visitRightPadded(m.getPadding().getContaining(), JRightPadded.Location.MEMBER_REFERENCE_CONTAINING, p))).getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        m = m.getPadding().withReference(this.visitLeftPadded(m.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p));
        m = m.withType(this.visitType(m.getType(), p));
        m = m.withMethodType((JavaType.Method)this.visitType(m.getMethodType(), p));
        m = m.withVariableType((JavaType.Variable)this.visitType(m.getVariableType(), p));
        return m;
    }

    public J visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof J.MethodDeclaration)) {
            return temp;
        }
        m = (J.MethodDeclaration)temp;
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        J.TypeParameters typeParameters = (m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))))).getAnnotations().getTypeParameters();
        if (typeParameters != null) {
            m = m.getAnnotations().withTypeParameters(typeParameters.withAnnotations(ListUtils.map(typeParameters.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        }
        if ((typeParameters = m.getAnnotations().getTypeParameters()) != null) {
            m = m.getAnnotations().withTypeParameters(typeParameters.getPadding().withTypeParameters(ListUtils.map(typeParameters.getPadding().getTypeParameters(), tp -> this.visitRightPadded((JRightPadded)tp, JRightPadded.Location.TYPE_PARAMETER, p))));
        }
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast(m.getReturnTypeExpression(), p))).getReturnTypeExpression() == null ? null : this.visitTypeName(m.getReturnTypeExpression(), p));
        m = m.getAnnotations().withName(m.getAnnotations().getName().withAnnotations(ListUtils.map(m.getAnnotations().getName().getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        m = m.withName((J.Identifier)this.visitNonNull(m.getName(), p));
        if ((m = m.getPadding().withParameters(this.visitContainer(m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, p))).getPadding().getThrows() != null) {
            m = m.getPadding().withThrows(this.visitContainer(m.getPadding().getThrows(), JContainer.Location.THROWS, p));
        }
        m = m.getPadding().withThrows(this.visitTypeNames(m.getPadding().getThrows(), p));
        if ((m = m.withBody((J.Block)this.visitAndCast(m.getBody(), p))).getPadding().getDefaultValue() != null) {
            m = m.getPadding().withDefaultValue(this.visitLeftPadded(m.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p));
        }
        m = m.withMethodType((JavaType.Method)this.visitType(m.getMethodType(), p));
        return m;
    }

    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof J.MethodInvocation)) {
            return temp;
        }
        m = (J.MethodInvocation)temp;
        Expression temp2 = (Expression)this.visitExpression(m, p);
        if (!(temp2 instanceof J.MethodInvocation)) {
            return temp2;
        }
        m = (J.MethodInvocation)temp2;
        if (m.getPadding().getSelect() != null && m.getPadding().getSelect().getElement() instanceof NameTree && method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static)) {
            m = m.getPadding().withSelect(this.visitTypeName(m.getPadding().getSelect(), p));
        }
        if (m.getPadding().getSelect() != null) {
            m = m.getPadding().withSelect(this.visitRightPadded(m.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, p));
        }
        if (m.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        m = m.getPadding().withTypeParameters(this.visitTypeNames(m.getPadding().getTypeParameters(), p));
        m = m.withName((J.Identifier)this.visitNonNull(m.getName(), p));
        m = m.getPadding().withArguments(this.visitContainer(m.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, p));
        m = m.withMethodType((JavaType.Method)this.visitType(m.getMethodType(), p));
        return m;
    }

    public J visitMultiCatch(J.MultiCatch multiCatch, P p) {
        J.MultiCatch m = multiCatch;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MULTI_CATCH_PREFIX, p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.getPadding().withAlternatives(ListUtils.map(m.getPadding().getAlternatives(), t -> this.visitTypeName(this.visitRightPadded((JRightPadded)t, JRightPadded.Location.CATCH_ALTERNATIVE, p), p)));
        return m;
    }

    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations m = multiVariable;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.VARIABLE_DECLARATIONS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof J.VariableDeclarations)) {
            return temp;
        }
        m = (J.VariableDeclarations)temp;
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        m = m.withTypeExpression((m = m.withTypeExpression((TypeTree)this.visitAndCast(m.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(m.getTypeExpression(), p));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), Space.Location.VARARGS, p));
        m = m.withDimensionsBeforeName(ListUtils.map(m.getDimensionsBeforeName(), dim -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p))));
        m = m.getPadding().withVariables(ListUtils.map(m.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.NAMED_VARIABLE, p)));
        return m;
    }

    public J visitNewArray(J.NewArray newArray, P p) {
        J.NewArray n = newArray;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_ARRAY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(n = n.withMarkers(this.visitMarkers(n.getMarkers(), p)), p);
        if (!(temp instanceof J.NewArray)) {
            return temp;
        }
        n = (J.NewArray)temp;
        n = n.withTypeExpression((n = n.withTypeExpression((TypeTree)this.visitAndCast(n.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(n.getTypeExpression(), p));
        if ((n = n.withDimensions(ListUtils.map(n.getDimensions(), d -> (J.ArrayDimension)this.visitAndCast((Tree)d, p)))).getPadding().getInitializer() != null) {
            n = n.getPadding().withInitializer(this.visitContainer(n.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, p));
        }
        n = n.withType(this.visitType(n.getType(), p));
        return n;
    }

    public J visitNewClass(J.NewClass newClass, P p) {
        Statement temp;
        J.NewClass n = newClass;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_CLASS_PREFIX, p));
        if ((n = n.withMarkers(this.visitMarkers(n.getMarkers(), p))).getPadding().getEnclosing() != null) {
            n = n.getPadding().withEnclosing(this.visitRightPadded(n.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, p));
        }
        if (!((temp = (Statement)this.visitStatement(n, p)) instanceof J.NewClass)) {
            return temp;
        }
        n = (J.NewClass)temp;
        Expression temp2 = (Expression)this.visitExpression(n, p);
        if (!(temp2 instanceof J.NewClass)) {
            return temp2;
        }
        n = (J.NewClass)temp2;
        n = n.withNew(this.visitSpace(n.getNew(), Space.Location.NEW_PREFIX, p));
        n = n.withClazz((n = n.withClazz((TypeTree)this.visitAndCast(n.getClazz(), p))).getClazz() == null ? null : this.visitTypeName(n.getClazz(), p));
        n = n.getPadding().withArguments(this.visitContainer(n.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, p));
        n = n.withBody((J.Block)this.visitAndCast(n.getBody(), p));
        n = n.withConstructorType((JavaType.Method)this.visitType(n.getConstructorType(), p));
        return n;
    }

    public J visitPackage(J.Package pkg, P p) {
        J.Package pa = pkg;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.PACKAGE_PREFIX, p));
        pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p));
        pa = pa.withExpression((Expression)this.visitAndCast(pa.getExpression(), p));
        pa = pa.withAnnotations(ListUtils.map(pa.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        return pa;
    }

    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = type;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(pt = pt.withMarkers(this.visitMarkers(pt.getMarkers(), p)), p);
        if (!(temp instanceof J.ParameterizedType)) {
            return temp;
        }
        pt = (J.ParameterizedType)temp;
        if ((pt = pt.withClazz((NameTree)this.visitAndCast(pt.getClazz(), p))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer(pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), p));
        return pt;
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        J pa = parens;
        pa = ((J.Parentheses)pa).withPrefix(this.visitSpace(((J.Parentheses)pa).getPrefix(), Space.Location.PARENTHESES_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(pa = ((J.Parentheses)pa).withMarkers(this.visitMarkers(((J.Parentheses)pa).getMarkers(), p))), p);
        if (!(temp instanceof J.Parentheses)) {
            return temp;
        }
        pa = (J.Parentheses)temp;
        pa = ((J.Parentheses)pa).getPadding().withTree(this.visitRightPadded(((J.Parentheses)pa).getPadding().getTree(), JRightPadded.Location.PARENTHESES, p));
        return pa;
    }

    public J visitPrimitive(J.Primitive primitive, P p) {
        J.Primitive pr = primitive;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), Space.Location.PRIMITIVE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), p)), p);
        if (!(temp instanceof J.Primitive)) {
            return temp;
        }
        pr = (J.Primitive)temp;
        pr = pr.withType(this.visitType(pr.getType(), p));
        return pr;
    }

    public J visitReturn(J.Return retrn, P p) {
        J.Return r = retrn;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.RETURN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(r = r.withMarkers(this.visitMarkers(r.getMarkers(), p)), p);
        if (!(temp instanceof J.Return)) {
            return temp;
        }
        r = (J.Return)temp;
        r = r.withExpression((Expression)this.visitAndCast(r.getExpression(), p));
        return r;
    }

    public J visitSwitch(J.Switch switzh, P p) {
        J.Switch s = switzh;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SWITCH_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(s = s.withMarkers(this.visitMarkers(s.getMarkers(), p)), p);
        if (!(temp instanceof J.Switch)) {
            return temp;
        }
        s = (J.Switch)temp;
        s = s.withSelector((J.ControlParentheses)this.visitAndCast(s.getSelector(), p));
        s = s.withCases((J.Block)this.visitAndCast(s.getCases(), p));
        return s;
    }

    public J visitSynchronized(J.Synchronized synch, P p) {
        J.Synchronized s = synch;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SYNCHRONIZED_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(s = s.withMarkers(this.visitMarkers(s.getMarkers(), p)), p);
        if (!(temp instanceof J.Synchronized)) {
            return temp;
        }
        s = (J.Synchronized)temp;
        s = s.withLock((J.ControlParentheses)this.visitAndCast(s.getLock(), p));
        s = s.withBody((J.Block)this.visitAndCast(s.getBody(), p));
        return s;
    }

    public J visitTernary(J.Ternary ternary, P p) {
        J.Ternary t = ternary;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TERNARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof J.Ternary)) {
            return temp;
        }
        t = (J.Ternary)temp;
        t = t.withCondition((Expression)this.visitAndCast(t.getCondition(), p));
        t = t.getPadding().withTruePart(this.visitLeftPadded(t.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p));
        t = t.getPadding().withFalsePart(this.visitLeftPadded(t.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitThrow(J.Throw thrown, P p) {
        J.Throw t = thrown;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.THROW_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof J.Throw)) {
            return temp;
        }
        t = (J.Throw)temp;
        t = t.withException((Expression)this.visitAndCast(t.getException(), p));
        return t;
    }

    public J visitTry(J.Try tryable, P p) {
        J.Try t = tryable;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TRY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof J.Try)) {
            return temp;
        }
        t = (J.Try)temp;
        if (t.getPadding().getResources() != null) {
            t = t.getPadding().withResources(this.visitContainer(t.getPadding().getResources(), JContainer.Location.TRY_RESOURCES, p));
        }
        t = t.withBody((J.Block)this.visitAndCast(t.getBody(), p));
        if ((t = t.withCatches(ListUtils.map(t.getCatches(), c -> (J.Try.Catch)this.visitAndCast((Tree)c, p)))).getPadding().getFinally() != null) {
            t = t.getPadding().withFinally(this.visitLeftPadded(t.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, p));
        }
        return t;
    }

    public J visitTryResource(J.Try.Resource tryResource, P p) {
        J.Try.Resource r = tryResource;
        r = tryResource.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.TRY_RESOURCE, p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = tryResource.withVariableDeclarations((TypedTree)this.visitAndCast(r.getVariableDeclarations(), p));
        return r;
    }

    public J visitTypeCast(J.TypeCast typeCast, P p) {
        J.TypeCast t = typeCast;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_CAST_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof J.TypeCast)) {
            return temp;
        }
        t = (J.TypeCast)temp;
        t = t.withClazz((J.ControlParentheses)this.visitAndCast(t.getClazz(), p));
        t = t.withClazz(t.getClazz().withTree(this.visitTypeName(t.getClazz().getTree(), p)));
        t = t.withExpression((Expression)this.visitAndCast(t.getExpression(), p));
        return t;
    }

    public J visitTypeParameter(J.TypeParameter typeParam, P p) {
        J.TypeParameter t = typeParam;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.withAnnotations(ListUtils.map(t.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        if ((t = t.withName((Expression)this.visitAndCast(t.getName(), p))).getName() instanceof NameTree) {
            t = t.withName((Expression)((Object)this.visitTypeName((NameTree)((Object)t.getName()), p)));
        }
        if (t.getPadding().getBounds() != null) {
            t = t.getPadding().withBounds(this.visitContainer(t.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, p));
        }
        t = t.getPadding().withBounds(this.visitTypeNames(t.getPadding().getBounds(), p));
        return t;
    }

    public J visitUnary(J.Unary unary, P p) {
        J.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof J.Unary)) {
            return temp;
        }
        u = (J.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, p);
        if (!(temp2 instanceof J.Unary)) {
            return temp2;
        }
        u = (J.Unary)temp2;
        u = u.getPadding().withOperator(this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p));
        u = u.withExpression((Expression)this.visitAndCast(u.getExpression(), p));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = variable;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), Space.Location.VARIABLE_PREFIX, p));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withName((J.Identifier)this.visitAndCast(v.getName(), p));
        if ((v = v.withDimensionsAfterName(ListUtils.map(v.getDimensionsAfterName(), dim -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p))))).getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(v.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p));
        }
        v = v.withVariableType((JavaType.Variable)this.visitType(v.getVariableType(), p));
        return v;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J.WhileLoop w = whileLoop;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WHILE_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof J.WhileLoop)) {
            return temp;
        }
        w = (J.WhileLoop)temp;
        w = w.withCondition((J.ControlParentheses)this.visitAndCast(w.getCondition(), p));
        w = w.getPadding().withBody(this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p));
        return w;
    }

    public J visitWildcard(J.Wildcard wildcard, P p) {
        J.Wildcard w = wildcard;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WILDCARD_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof J.Wildcard)) {
            return temp;
        }
        w = (J.Wildcard)temp;
        if (w.getPadding().getBound() != null) {
            w = w.getPadding().withBound(w.getPadding().getBound().withBefore(this.visitSpace(w.getPadding().getBound().getBefore(), Space.Location.WILDCARD_BOUND, p)));
        }
        if ((w = w.withBoundedType((NameTree)this.visitAndCast(w.getBoundedType(), p))).getBoundedType() != null) {
            w = w.withBoundedType(this.visitTypeName(w.getBoundedType(), p));
        }
        return w;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((J)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, P p) {
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((J)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            if (left.getElement() == null && before == left.getBefore()) {
                return left;
            }
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new JLeftPadded<T>(before, t, left.getMarkers());
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    protected boolean isInSameNameScope(Cursor base, Cursor child) {
        Tree baseScope = (Tree)base.dropParentUntil(t -> t instanceof J.Block || t instanceof J.MethodDeclaration || t instanceof J.Try || t instanceof J.ForLoop || t instanceof J.ForEachLoop).getValue();
        Iterator it = child.getPath();
        while (it.hasNext()) {
            J.ClassDeclaration childClass;
            Object childScope = it.next();
            if (childScope instanceof J.ClassDeclaration && (!(childClass = (J.ClassDeclaration)childScope).getKind().equals((Object)J.ClassDeclaration.Kind.Type.Class) || childClass.hasModifier(J.Modifier.Type.Static))) {
                return false;
            }
            if (!(childScope instanceof Tree) || !baseScope.isScope((Tree)childScope)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInSameNameScope(Cursor child) {
        return this.isInSameNameScope(this.getCursor(), child);
    }
}

