/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.controlflow.BarrierGuardPredicate;
import org.openrewrite.java.controlflow.Guard;
import org.openrewrite.java.tree.J;

@Incubating(since="7.25.0")
public abstract class ControlFlowNode {
    final Set<ControlFlowNode> predecessors = new HashSet<ControlFlowNode>();

    abstract Set<ControlFlowNode> getSuccessors();

    protected abstract void _addSuccessorInternal(ControlFlowNode var1);

    Set<ControlFlowNode> getPredecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    <C extends ControlFlowNode> C addSuccessor(C successor) {
        if (this == successor) {
            throw new IllegalArgumentException("Cannot add a node as a successor of itself");
        }
        this._addSuccessorInternal(successor);
        successor.predecessors.add(this);
        return successor;
    }

    BasicBlock addBasicBlock() {
        return this.addSuccessor(new BasicBlock());
    }

    ConditionNode addConditionNodeTruthFirst() {
        throw new IllegalStateException("Can only add a condition node to a basic block");
    }

    ConditionNode addConditionNodeFalseFirst() {
        throw new IllegalStateException("Can only add a condition node to a basic block");
    }

    private ControlFlowNode() {
    }

    static class BasicBlock
    extends ControlFlowNode {
        private ControlFlowNode successor;
        private final List<Cursor> node = new ArrayList<Cursor>();
        private boolean nextConditionDefault = true;

        public J getLeader() {
            if (this.node.isEmpty()) {
                throw new IllegalStateException("Basic block has no nodes!");
            }
            return (J)this.node.get(0).getValue();
        }

        public List<Cursor> getNodeCursors() {
            return Collections.unmodifiableList(this.node);
        }

        public List<J> getNodeValues() {
            return this.node.stream().map(Cursor::getValue).collect(Collectors.toList());
        }

        boolean addCursorToBasicBlock(Cursor expression) {
            return this.node.add(expression);
        }

        void invertNextConditional() {
            this.nextConditionDefault = !this.nextConditionDefault;
        }

        @Override
        ConditionNode addConditionNodeTruthFirst() {
            if (this.node.isEmpty()) {
                throw new IllegalStateException("Cannot add condition node to empty basic block");
            }
            return this.addSuccessor(new ConditionNode(this.node.get(this.node.size() - 1), this.nextConditionDefault));
        }

        @Override
        ConditionNode addConditionNodeFalseFirst() {
            if (this.node.isEmpty()) {
                throw new IllegalStateException("Cannot add condition node to empty basic block");
            }
            return this.addSuccessor(new ConditionNode(this.node.get(this.node.size() - 1), !this.nextConditionDefault));
        }

        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (this.successor == successor) {
                return;
            }
            if (this.successor != null) {
                throw new IllegalStateException("Basic block already has a successor");
            }
            this.successor = successor;
        }

        @Override
        Set<ControlFlowNode> getSuccessors() {
            if (this.successor == null) {
                throw new IllegalStateException("Basic block has no successor");
            }
            return Collections.singleton(this.successor);
        }

        public String toString() {
            if (this.node.isEmpty()) {
                return "BasicBlock { No leader yet! }";
            }
            return "BasicBlock { leader=" + this.getLeader() + " }";
        }

        private BasicBlock() {
        }

        public ControlFlowNode getSuccessor() {
            return this.successor;
        }
    }

    static class End
    extends ControlFlowNode {
        @Override
        Set<ControlFlowNode> getSuccessors() {
            return Collections.emptySet();
        }

        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            throw new IllegalStateException("End nodes cannot have successors");
        }

        public String toString() {
            return "End";
        }

        private End() {
        }

        @NonNull
        static End create() {
            return new End();
        }
    }

    static class Start
    extends ControlFlowNode {
        private ControlFlowNode successor = null;

        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (this.successor != null) {
                throw new IllegalStateException("Start node already has a successor");
            }
            this.successor = successor;
        }

        @Override
        Set<ControlFlowNode> getSuccessors() {
            return Collections.singleton(this.successor);
        }

        public String toString() {
            return "Start";
        }

        private Start() {
        }

        @NonNull
        static Start create() {
            return new Start();
        }
    }

    static class ConditionNode
    extends ControlFlowNode {
        private final Cursor condition;
        private final boolean truthFirst;
        private ControlFlowNode truthySuccessor;
        private ControlFlowNode falsySuccessor;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void _addSuccessorInternal(ControlFlowNode successor) {
            if (this.truthFirst) {
                if (this.truthySuccessor == null) {
                    this.truthySuccessor = successor;
                    return;
                } else {
                    if (this.falsySuccessor != null) throw new IllegalStateException("Condition node already has both successors");
                    this.falsySuccessor = successor;
                }
                return;
            } else if (this.falsySuccessor == null) {
                this.falsySuccessor = successor;
                return;
            } else {
                if (this.truthySuccessor != null) throw new IllegalStateException("Condition node already has both successors");
                this.truthySuccessor = successor;
            }
        }

        @Override
        Set<ControlFlowNode> getSuccessors() {
            this.verifyState();
            return Stream.of(this.truthySuccessor, this.falsySuccessor).collect(Collectors.toSet());
        }

        private void verifyState() {
            if (this.truthySuccessor == null && this.falsySuccessor == null) {
                throw new IllegalStateException("Condition node has no successors. Should have both!");
            }
            if (this.truthySuccessor == null) {
                throw new IllegalStateException("Condition node has no truthy successor");
            }
            if (this.falsySuccessor == null) {
                throw new IllegalStateException("Condition node has no falsy successor");
            }
        }

        Set<ControlFlowNode> visit(BarrierGuardPredicate isBarrierGuard) {
            this.verifyState();
            HashSet<ControlFlowNode> nodes = new HashSet<ControlFlowNode>(2);
            if (!isBarrierGuard.isBarrierGuard(this.asGuard(), true)) {
                nodes.add(this.getTruthySuccessor());
            }
            if (!isBarrierGuard.isBarrierGuard(this.asGuard(), false)) {
                nodes.add(this.getFalsySuccessor());
            }
            return nodes;
        }

        Guard asGuard() {
            return Guard.from(this.condition).orElseThrow(() -> new IllegalStateException("Condition node has no guard: " + this.condition));
        }

        public String toString() {
            return "ConditionNode{condition=" + this.condition.getValue() + ", truthySuccessor=" + this.truthySuccessor + ", falsySuccessor=" + this.falsySuccessor + '}';
        }

        private ConditionNode(Cursor condition, boolean truthFirst) {
            this.condition = condition;
            this.truthFirst = truthFirst;
        }

        public Cursor getCondition() {
            return this.condition;
        }

        public ControlFlowNode getTruthySuccessor() {
            return this.truthySuccessor;
        }

        public ControlFlowNode getFalsySuccessor() {
            return this.falsySuccessor;
        }
    }
}

