/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.search.FindMissingTypes;
import org.openrewrite.java.tree.J;

public class TypeValidation {
    private boolean classDeclarations = true;
    private boolean identifiers = true;
    private boolean methodDeclarations = true;
    private boolean methodInvocations = true;

    public static TypeValidation none() {
        return new TypeValidation(false, false, false, false);
    }

    private boolean enabled() {
        return this.identifiers || this.methodInvocations || this.methodDeclarations || this.classDeclarations;
    }

    public void assertValidTypes(J sf) {
        if (this.enabled()) {
            List<FindMissingTypes.MissingTypeResult> missingTypeResults = FindMissingTypes.findMissingTypes(sf);
            if (!(missingTypeResults = missingTypeResults.stream().filter(missingType -> {
                if (this.identifiers && missingType.getJ() instanceof J.Identifier) {
                    return true;
                }
                if (this.classDeclarations && missingType.getJ() instanceof J.ClassDeclaration) {
                    return true;
                }
                if (this.methodInvocations && missingType.getJ() instanceof J.MethodInvocation) {
                    return true;
                }
                return this.methodDeclarations && missingType.getJ() instanceof J.MethodDeclaration;
            }).collect(Collectors.toList())).isEmpty()) {
                throw new IllegalStateException("AST contains missing or invalid type information\n" + missingTypeResults.stream().map(v -> v.getPath() + "\n" + v.getPrintedTree()).collect(Collectors.joining("\n\n")));
            }
        }
    }

    public boolean classDeclarations() {
        return this.classDeclarations;
    }

    public boolean identifiers() {
        return this.identifiers;
    }

    public boolean methodDeclarations() {
        return this.methodDeclarations;
    }

    public boolean methodInvocations() {
        return this.methodInvocations;
    }

    @NonNull
    public TypeValidation classDeclarations(boolean classDeclarations) {
        this.classDeclarations = classDeclarations;
        return this;
    }

    @NonNull
    public TypeValidation identifiers(boolean identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    @NonNull
    public TypeValidation methodDeclarations(boolean methodDeclarations) {
        this.methodDeclarations = methodDeclarations;
        return this;
    }

    @NonNull
    public TypeValidation methodInvocations(boolean methodInvocations) {
        this.methodInvocations = methodInvocations;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeValidation)) {
            return false;
        }
        TypeValidation other = (TypeValidation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.classDeclarations() != other.classDeclarations()) {
            return false;
        }
        if (this.identifiers() != other.identifiers()) {
            return false;
        }
        if (this.methodDeclarations() != other.methodDeclarations()) {
            return false;
        }
        return this.methodInvocations() == other.methodInvocations();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof TypeValidation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.classDeclarations() ? 79 : 97);
        result = result * 59 + (this.identifiers() ? 79 : 97);
        result = result * 59 + (this.methodDeclarations() ? 79 : 97);
        result = result * 59 + (this.methodInvocations() ? 79 : 97);
        return result;
    }

    @NonNull
    public String toString() {
        return "TypeValidation(classDeclarations=" + this.classDeclarations() + ", identifiers=" + this.identifiers() + ", methodDeclarations=" + this.methodDeclarations() + ", methodInvocations=" + this.methodInvocations() + ")";
    }

    public TypeValidation() {
    }

    public TypeValidation(boolean classDeclarations, boolean identifiers, boolean methodDeclarations, boolean methodInvocations) {
        this.classDeclarations = classDeclarations;
        this.identifiers = identifiers;
        this.methodDeclarations = methodDeclarations;
        this.methodInvocations = methodInvocations;
    }
}

