/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public final class RenameClass
extends Recipe {
    @Option(displayName="Old fully-qualified type name", description="Fully-qualified class name of the original type.", example="org.junit.Assume")
    private final String oldFullyQualifiedTypeName;
    @Option(displayName="New fully-qualified type name", description="Fully-qualified class name of the replacement type.", example="org.junit.jupiter.api.Assumptions")
    private final String newFullyQualifiedTypeName;

    public String getDisplayName() {
        return "Rename a class declaration that matches the provided fully qualified name";
    }

    public String getDescription() {
        return "`RenameClass` will rename a single class declaration and update the source file path when possible. The source file path will only be updated if the path matches the old FQN and the target FQN matches a top-level public class. I.E. `/a/b/C` and `a.b.C` where `C` is public.The last class in the provided FQN will be renamed. Multiple class renames are not supported like `a.b.C$D$E` to `a.b.X$Y$Z`.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J cd = super.visitClassDeclaration(classDecl, executionContext);
                if (TypeUtils.isOfClassType(((J.ClassDeclaration)cd).getType(), RenameClass.this.oldFullyQualifiedTypeName)) {
                    return ((J.ClassDeclaration)cd).withMarkers(((J.ClassDeclaration)cd).getMarkers().searchResult());
                }
                return cd;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new RenameClassVisitor(this.oldFullyQualifiedTypeName, this.newFullyQualifiedTypeName);
    }

    public RenameClass(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName) {
        this.oldFullyQualifiedTypeName = oldFullyQualifiedTypeName;
        this.newFullyQualifiedTypeName = newFullyQualifiedTypeName;
    }

    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    public String getNewFullyQualifiedTypeName() {
        return this.newFullyQualifiedTypeName;
    }

    @NonNull
    public String toString() {
        return "RenameClass(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFullyQualifiedTypeName=" + this.getNewFullyQualifiedTypeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameClass)) {
            return false;
        }
        RenameClass other = (RenameClass)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        String this$newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        String other$newFullyQualifiedTypeName = other.getNewFullyQualifiedTypeName();
        return !(this$newFullyQualifiedTypeName == null ? other$newFullyQualifiedTypeName != null : !this$newFullyQualifiedTypeName.equals(other$newFullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RenameClass;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        String $newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        result = result * 59 + ($newFullyQualifiedTypeName == null ? 43 : $newFullyQualifiedTypeName.hashCode());
        return result;
    }

    private class RenameClassVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaType.Class oldType;
        private final JavaType newType;

        private RenameClassVisitor(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName) {
            this.oldType = JavaType.ShallowClass.build(oldFullyQualifiedTypeName);
            this.newType = JavaType.buildType(newFullyQualifiedTypeName);
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile sf, ExecutionContext ctx) {
            String newFqn;
            String oldFqn;
            Path newPath;
            String oldPath = ((SourceFile)sf).getSourcePath().toString().replace('\\', '/');
            if (this.updatePath(sf, oldPath, (newPath = Paths.get(oldPath.replaceFirst(oldFqn = this.fqnToPath(this.oldType.getFullyQualifiedName()), newFqn = this.fqnToPath(RenameClass.this.newFullyQualifiedTypeName)), new String[0])).toString())) {
                sf = (JavaSourceFile)((SourceFile)sf).withSourcePath(newPath);
            }
            return super.visitJavaSourceFile(sf, ctx);
        }

        private String fqnToPath(String fullyQualifiedName) {
            int index = fullyQualifiedName.indexOf("$");
            String topLevelClassName = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(0, index);
            return topLevelClassName.replace('.', '/');
        }

        private boolean updatePath(JavaSourceFile sf, String oldPath, String newPath) {
            return !oldPath.equals(newPath) && sf.getClasses().stream().anyMatch(o -> J.Modifier.hasModifier(o.getModifiers(), J.Modifier.Type.Public) && o.getType() != null && !o.getType().getFullyQualifiedName().contains("$") && TypeUtils.isOfClassType(o.getType(), this.getTopLevelClassName(this.oldType)));
        }

        private String getTopLevelClassName(JavaType.FullyQualified classType) {
            if (classType.getOwningClass() == null) {
                return classType.getFullyQualifiedName();
            }
            return this.getTopLevelClassName(classType.getOwningClass());
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext executionContext) {
            String oldPkg;
            J p = super.visitPackage(pkg, executionContext);
            String original = ((J.Package)p).getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "");
            if (original.equals(oldPkg = this.oldType.getFullyQualifiedName().substring(0, this.oldType.getFullyQualifiedName().lastIndexOf(46)))) {
                if (RenameClass.this.newFullyQualifiedTypeName.contains(".")) {
                    String newPkg = RenameClass.this.newFullyQualifiedTypeName.substring(0, RenameClass.this.newFullyQualifiedTypeName.lastIndexOf(46));
                    p = (J.Package)p.withTemplate(JavaTemplate.builder(() -> ((RenameClassVisitor)this).getCursor(), newPkg).build(), ((J.Package)p).getCoordinates().replace(), new Object[0]);
                } else {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "UPDATE_PREFIX", (Object)true);
                    p = null;
                }
            }
            return p;
        }

        @Override
        public J.Import visitImport(J.Import _import, ExecutionContext executionContext) {
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                _import = _import.withPrefix(Space.EMPTY);
            }
            return super.visitImport(_import, executionContext);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J cd = super.visitClassDeclaration(classDecl, executionContext);
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                cd = ((J.ClassDeclaration)cd).withPrefix(Space.EMPTY);
            }
            if (TypeUtils.isOfClassType(classDecl.getType(), this.oldType.getFullyQualifiedName())) {
                JavaType.ShallowClass fq = JavaType.ShallowClass.build(RenameClass.this.newFullyQualifiedTypeName);
                String newClassName = this.getNewClassName(fq);
                cd = ((J.ClassDeclaration)cd).withName(((J.ClassDeclaration)cd).getName().withSimpleName(newClassName));
                cd = ((J.ClassDeclaration)cd).withType(this.updateType(((J.ClassDeclaration)cd).getType()));
                RenameClass.this.doNext(new ChangeType(this.oldType.getFullyQualifiedName(), RenameClass.this.newFullyQualifiedTypeName, true));
            }
            return cd;
        }

        private String getNewClassName(JavaType.FullyQualified fq) {
            return fq.getOwningClass() == null ? fq.getClassName() : fq.getFullyQualifiedName().substring(fq.getOwningClass().getFullyQualifiedName().length() + 1);
        }

        private JavaType updateType(@Nullable JavaType type) {
            JavaType.GenericTypeVariable gtv = TypeUtils.asGeneric(type);
            if (gtv != null) {
                return gtv.withBounds(ListUtils.map(gtv.getBounds(), bound -> {
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified(bound);
                    if (fq != null && fq.getFullyQualifiedName().equals(this.oldType.getFullyQualifiedName()) && this.newType instanceof JavaType.FullyQualified) {
                        return this.newType;
                    }
                    return bound;
                }));
            }
            JavaType.FullyQualified fqt = TypeUtils.asFullyQualified(type);
            if (fqt != null && fqt.getFullyQualifiedName().equals(this.oldType.getFullyQualifiedName())) {
                return this.newType;
            }
            return type;
        }
    }
}

