/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class ReplaceDuplicateStringLiterals
extends Recipe {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false, example="true")
    @Nullable
    private final Boolean includeTestSources;

    public String getDisplayName() {
        return "Replace duplicate `String` literals";
    }

    public String getDescription() {
        return "Replaces `String` literals with a length of 5 or greater repeated a minimum of 3 times. Qualified `String` literals include final Strings, method invocations, and new class invocations. Adds a new `private static final String` or uses an existing equivalent class field. A new variable name will be generated based on the literal value if an existing field does not exist. The generated name will append a numeric value to the variable name if a name already exists in the compilation unit.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1192");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.lang.String");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                if (sourceSet.isPresent() && (Boolean.TRUE.equals(ReplaceDuplicateStringLiterals.this.includeTestSources) || "main".equals(((JavaSourceSet)sourceSet.get()).getName()))) {
                    return super.visitCompilationUnit(cu, executionContext);
                }
                return cu;
            }

            @Override
            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                if (classDecl.getType() == null) {
                    return classDecl;
                }
                Map<String, Set<J.Literal>> duplicateLiteralsMap = FindDuplicateStringLiterals.find(classDecl);
                if (duplicateLiteralsMap.isEmpty()) {
                    return classDecl;
                }
                Set<String> variableNames = FindVariableNames.find(classDecl);
                Map<String, String> fieldValueToFieldName = FindExistingPrivateStaticFinalFields.find(classDecl);
                String classFqn = classDecl.getType().getFullyQualifiedName();
                for (String valueOfLiteral : duplicateLiteralsMap.keySet()) {
                    String variableName;
                    if (fieldValueToFieldName.containsKey(valueOfLiteral)) {
                        String classFieldName = fieldValueToFieldName.get(valueOfLiteral);
                        variableName = this.getNameWithoutShadow(classFieldName, variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        if (!classFieldName.equals(variableName)) {
                            this.doAfterVisit(new ChangeFieldName(classFqn, classFieldName, variableName));
                        }
                    } else {
                        variableName = this.getNameWithoutShadow(this.transformToVariableName(valueOfLiteral), variableNames);
                        if (StringUtils.isBlank((String)variableName)) continue;
                        J.Literal replaceLiteral = ((J.Literal)duplicateLiteralsMap.get(valueOfLiteral).toArray()[0]).withId(Tree.randomId());
                        String insertStatement = "private static final String " + variableName + " = #{any(String)}";
                        classDecl = classDecl.withBody((J.Block)classDecl.getBody().withTemplate(JavaTemplate.builder(() -> (this).getCursor(), insertStatement).build(), classDecl.getBody().getCoordinates().firstStatement(), replaceLiteral));
                    }
                    variableNames.add(variableName);
                    this.doAfterVisit(new ReplaceStringLiterals(classDecl, variableName, duplicateLiteralsMap.get(valueOfLiteral)));
                }
                return classDecl;
            }

            private String getNameWithoutShadow(String name, Set<String> variableNames) {
                String transformedName;
                String newName = transformedName = this.transformToVariableName(name);
                int append = 0;
                while (variableNames.contains(newName)) {
                    newName = transformedName + "_" + ++append;
                }
                return newName;
            }

            private String transformToVariableName(String valueOfLiteral) {
                boolean prevIsLower = false;
                boolean prevIsCharacter = false;
                StringBuilder newName = new StringBuilder();
                for (int i = 0; i < valueOfLiteral.length(); ++i) {
                    char c = valueOfLiteral.charAt(i);
                    if (i > 0 && newName.lastIndexOf("_") != newName.length() - 1 && (Character.isUpperCase(c) && prevIsLower || !prevIsCharacter)) {
                        newName.append("_");
                    }
                    if (!(prevIsCharacter = Character.isLetterOrDigit(c))) continue;
                    if (newName.length() == 0 && Character.isDigit(c)) {
                        newName.append("A_");
                    }
                    newName.append(Character.toUpperCase(c));
                    prevIsLower = Character.isLowerCase(c);
                }
                return newName.toString();
            }
        };
    }

    private static boolean isPrivateStaticFinalVariable(J.VariableDeclarations declaration) {
        return declaration.hasModifier(J.Modifier.Type.Private) && declaration.hasModifier(J.Modifier.Type.Static) && declaration.hasModifier(J.Modifier.Type.Final);
    }

    public ReplaceDuplicateStringLiterals(@Nullable Boolean includeTestSources) {
        this.includeTestSources = includeTestSources;
    }

    @Nullable
    public Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    @NonNull
    public String toString() {
        return "ReplaceDuplicateStringLiterals(includeTestSources=" + this.getIncludeTestSources() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceDuplicateStringLiterals)) {
            return false;
        }
        ReplaceDuplicateStringLiterals other = (ReplaceDuplicateStringLiterals)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        return !(this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceDuplicateStringLiterals;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        return result;
    }

    private static class ReplaceStringLiterals
    extends JavaVisitor<ExecutionContext> {
        private final J.ClassDeclaration isClass;
        private final String variableName;
        private final Set<J.Literal> literals;

        private ReplaceStringLiterals(J.ClassDeclaration isClass, String variableName, Set<J.Literal> literals) {
            this.isClass = isClass;
            this.variableName = variableName;
            this.literals = literals;
        }

        @Override
        public J visitLiteral(J.Literal literal, ExecutionContext executionContext) {
            if (this.literals.contains(literal)) {
                assert (this.isClass.getType() != null);
                return new J.Identifier(Tree.randomId(), literal.getPrefix(), literal.getMarkers(), this.variableName, JavaType.Primitive.String, new JavaType.Variable(null, Flag.flagsToBitMap(new HashSet<Flag>(Arrays.asList(Flag.Private, Flag.Static, Flag.Final))), this.variableName, this.isClass.getType(), JavaType.Primitive.String, Collections.emptyList()));
            }
            return literal;
        }
    }

    private static class FindExistingPrivateStaticFinalFields
    extends JavaIsoVisitor<Map<String, String>> {
        private FindExistingPrivateStaticFinalFields() {
        }

        public static Map<String, String> find(J j) {
            LinkedHashMap<String, String> fieldValueToFieldName = new LinkedHashMap<String, String>();
            new FindExistingPrivateStaticFinalFields().visit(j, fieldValueToFieldName);
            return fieldValueToFieldName;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Map<String, String> stringStringMap) {
            Cursor parentScope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration);
            J.VariableDeclarations declaration = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
            if (parentScope.getValue() instanceof J.ClassDeclaration && declaration != null && ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(declaration) && variable.getInitializer() instanceof J.Literal && ((J.Literal)variable.getInitializer()).getValue() instanceof String) {
                String value = (String)((J.Literal)variable.getInitializer()).getValue();
                stringStringMap.putIfAbsent(value, variable.getSimpleName());
            }
            return variable;
        }
    }

    private static class FindVariableNames
    extends JavaIsoVisitor<Set<String>> {
        private FindVariableNames() {
        }

        public static Set<String> find(J.ClassDeclaration inClass) {
            HashSet<String> variableNames = new HashSet<String>();
            new FindVariableNames().visit(inClass, variableNames);
            return variableNames;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<String> variableNames) {
            Cursor parentScope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration);
            J.VariableDeclarations declaration = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
            if (parentScope.getValue() instanceof J.MethodDeclaration || parentScope.getValue() instanceof J.ClassDeclaration && declaration != null && (!ReplaceDuplicateStringLiterals.isPrivateStaticFinalVariable(declaration) || !(variable.getInitializer() instanceof J.Literal) || !(((J.Literal)variable.getInitializer()).getValue() instanceof String))) {
                variableNames.add(variable.getSimpleName());
            }
            return variable;
        }
    }

    private static class FindDuplicateStringLiterals
    extends JavaIsoVisitor<Map<String, Set<J.Literal>>> {
        private FindDuplicateStringLiterals() {
        }

        public static Map<String, Set<J.Literal>> find(J.ClassDeclaration inClass) {
            HashMap literalsMap = new HashMap();
            TreeMap<String, Set<J.Literal>> filteredMap = new TreeMap<String, Set<J.Literal>>(Comparator.reverseOrder());
            new FindDuplicateStringLiterals().visit(inClass, literalsMap);
            for (String valueOfLiteral : literalsMap.keySet()) {
                if (((Set)literalsMap.get(valueOfLiteral)).size() < 3) continue;
                filteredMap.put(valueOfLiteral, (Set)literalsMap.get(valueOfLiteral));
            }
            return filteredMap;
        }

        @Override
        public J.Literal visitLiteral(J.Literal literal, Map<String, Set<J.Literal>> literalsMap) {
            Cursor parent;
            if (JavaType.Primitive.String.equals(literal.getType()) && literal.getValue() instanceof String && ((String)literal.getValue()).length() >= 5 && ((parent = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Annotation || is instanceof J.VariableDeclarations || is instanceof J.NewClass || is instanceof J.MethodInvocation)).getValue() instanceof J.VariableDeclarations && ((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Final) && (!((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Private) || !((J.VariableDeclarations)parent.getValue()).hasModifier(J.Modifier.Type.Static)) || parent.getValue() instanceof J.NewClass || parent.getValue() instanceof J.MethodInvocation)) {
                literalsMap.computeIfAbsent((String)literal.getValue(), k -> new HashSet());
                literalsMap.get((String)literal.getValue()).add(literal);
            }
            return literal;
        }
    }
}

