/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.dataflow.LastWrite;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

@Incubating(since="7.20.0")
public class UpdateLastWrite
extends Recipe {
    public String getDisplayName() {
        return "Last write data flow analysis";
    }

    public String getDescription() {
        return "Update last write edges tracking assignments to local variables and fields.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                ((HashMap)this.getCursor().dropParentUntil(J.Block.class::isInstance).computeMessageIfAbsent("variables", v2 -> new HashMap())).put(variable.getSimpleName(), variable.getId());
                J v = super.visitVariable(variable, ctx);
                v = ((J.VariableDeclarations.NamedVariable)v).withMarkers(((J.VariableDeclarations.NamedVariable)v).getMarkers().removeByType(LastWrite.class));
                if (((J.VariableDeclarations.NamedVariable)v).getInitializer() != null) {
                    v = ((J.VariableDeclarations.NamedVariable)v).withInitializer((Expression)((J.VariableDeclarations.NamedVariable)v).getInitializer().withMarkers(((J.VariableDeclarations.NamedVariable)v).getInitializer().getMarkers().setByType((Marker)new LastWrite(Tree.randomId(), ((J.VariableDeclarations.NamedVariable)v).getId()))));
                }
                return v;
            }

            @Override
            public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
                UUID id;
                Map variableIds;
                J a = super.visitAssignment(assignment, ctx);
                if (((J.Assignment)(a = ((J.Assignment)a).withMarkers(((J.Assignment)a).getMarkers().removeByType(LastWrite.class)))).getVariable() instanceof J.Identifier && (variableIds = (Map)this.getCursor().getNearestMessage("variables")) != null && (id = (UUID)variableIds.get(((J.Identifier)((J.Assignment)a).getVariable()).getSimpleName())) != null) {
                    a = ((J.Assignment)a).withAssignment((Expression)((J.Assignment)a).getAssignment().withMarkers(((J.Assignment)a).getAssignment().getMarkers().setByType((Marker)new LastWrite(Tree.randomId(), id))));
                }
                return a;
            }

            @Override
            public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, ExecutionContext ctx) {
                UUID id;
                Map variableIds;
                J a = super.visitAssignmentOperation(assignOp, ctx);
                if (((J.AssignmentOperation)(a = ((J.AssignmentOperation)a).withMarkers(((J.AssignmentOperation)a).getMarkers().removeByType(LastWrite.class)))).getVariable() instanceof J.Identifier && (variableIds = (Map)this.getCursor().getNearestMessage("variables")) != null && (id = (UUID)variableIds.get(((J.Identifier)((J.AssignmentOperation)a).getVariable()).getSimpleName())) != null) {
                    a = ((J.AssignmentOperation)a).withAssignment((Expression)((J.AssignmentOperation)a).getAssignment().withMarkers(((J.AssignmentOperation)a).getAssignment().getMarkers().setByType((Marker)new LastWrite(Tree.randomId(), id))));
                }
                return a;
            }

            @Override
            public J.Unary visitUnary(J.Unary unary, ExecutionContext ctx) {
                UUID id;
                Map variableIds;
                J u = super.visitUnary(unary, ctx);
                if (((J.Unary)(u = ((J.Unary)u).withMarkers(((J.Unary)u).getMarkers().removeByType(LastWrite.class)))).getExpression() instanceof J.Identifier && (variableIds = (Map)this.getCursor().getNearestMessage("variables")) != null && (id = (UUID)variableIds.get(((J.Identifier)((J.Unary)u).getExpression()).getSimpleName())) != null) {
                    u = ((J.Unary)u).withMarkers(((J.Unary)u).getMarkers().setByType((Marker)new LastWrite(Tree.randomId(), id)));
                }
                return u;
            }
        };
    }
}

