/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;

public class WrappingAndBraces
extends Recipe {
    public String getDisplayName() {
        return "Wrapping and braces";
    }

    public String getDescription() {
        return "Format line wraps and braces in Java code.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new WrappingAndBracesCompilationUnitStyle();
    }

    private static class WrappingAndBracesCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private WrappingAndBracesCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            WrappingAndBracesStyle style = (WrappingAndBracesStyle)cu.getStyle(WrappingAndBracesStyle.class);
            if (style == null) {
                style = IntelliJ.wrappingAndBraces();
            }
            this.doAfterVisit(new WrappingAndBracesVisitor(style));
            return cu;
        }
    }
}

