/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class UseDiamondOperator
extends Recipe {
    public String getDisplayName() {
        return "Use diamond operator";
    }

    public String getDescription() {
        return "The diamond operator (`<>`) should be used. Java 7 introduced the diamond operator (<>) to reduce the verbosity of generics code. For instance, instead of having to declare a List's type in both its declaration and its constructor, you can now simplify the constructor declaration with `<>`, and the compiler will infer the type.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J.ParameterizedType parameterizedType;
                J n = super.visitNewClass(newClass, executionContext);
                if (((J.NewClass)n).getClazz() instanceof J.ParameterizedType && ((J.NewClass)n).getBody() == null && (parameterizedType = (J.ParameterizedType)((J.NewClass)n).getClazz()).getTypeParameters() != null && !parameterizedType.getTypeParameters().isEmpty()) {
                    n = ((J.NewClass)n).withClazz(parameterizedType.withTypeParameters(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY))));
                }
                return n;
            }
        };
    }
}

