/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public final class ChangePackage
extends Recipe {
    @Option(displayName="Old package name", description="The package name to replace.", example="com.yourorg.foo")
    private final String oldPackageName;
    @Option(displayName="New package name", description="New package name to replace the old package name with.", example="com.yourorg.bar")
    private final String newPackageName;
    @Option(displayName="Recursive", description="Recursively change subpackage names", required=false, example="true")
    @Nullable
    private final Boolean recursive;

    public String getDisplayName() {
        return "Rename package name";
    }

    public String getDescription() {
        return "A recipe that will rename a package name in package statements, imports, and fully-qualified types.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                String original;
                if (cu.getPackageDeclaration() != null && (original = cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "")).startsWith(ChangePackage.this.oldPackageName)) {
                    return (JavaSourceFile)cu.withMarkers(cu.getMarkers().searchResult());
                }
                this.doAfterVisit(new UsesType(ChangePackage.this.oldPackageName + ".*"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePackageVisitor();
    }

    public ChangePackage(String oldPackageName, String newPackageName, @Nullable Boolean recursive) {
        this.oldPackageName = oldPackageName;
        this.newPackageName = newPackageName;
        this.recursive = recursive;
    }

    public String getOldPackageName() {
        return this.oldPackageName;
    }

    public String getNewPackageName() {
        return this.newPackageName;
    }

    @Nullable
    public Boolean getRecursive() {
        return this.recursive;
    }

    @NonNull
    public String toString() {
        return "ChangePackage(oldPackageName=" + this.getOldPackageName() + ", newPackageName=" + this.getNewPackageName() + ", recursive=" + this.getRecursive() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$oldPackageName = this.getOldPackageName();
        String other$oldPackageName = other.getOldPackageName();
        if (this$oldPackageName == null ? other$oldPackageName != null : !this$oldPackageName.equals(other$oldPackageName)) {
            return false;
        }
        String this$newPackageName = this.getNewPackageName();
        String other$newPackageName = other.getNewPackageName();
        return !(this$newPackageName == null ? other$newPackageName != null : !this$newPackageName.equals(other$newPackageName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $oldPackageName = this.getOldPackageName();
        result = result * 59 + ($oldPackageName == null ? 43 : $oldPackageName.hashCode());
        String $newPackageName = this.getNewPackageName();
        result = result * 59 + ($newPackageName == null ? 43 : $newPackageName.hashCode());
        return result;
    }

    @NonNull
    public ChangePackage withRecursive(@Nullable Boolean recursive) {
        return this.recursive == recursive ? this : new ChangePackage(this.oldPackageName, this.newPackageName, recursive);
    }

    private class ChangePackageVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String RENAME_TO_KEY = "renameTo";
        private static final String RENAME_FROM_KEY = "renameFrom";
        private final JavaType.Class newPackageType;

        private ChangePackageVisitor() {
            this.newPackageType = JavaType.Class.build(ChangePackage.this.newPackageName);
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            J c = super.visitJavaSourceFile(cu, ctx);
            String changingTo = (String)this.getCursor().getMessage(RENAME_TO_KEY);
            if (changingTo != null) {
                String path = ((SourceFile)c).getSourcePath().toString().replace('\\', '/');
                String changingFrom = (String)this.getCursor().getMessage(RENAME_FROM_KEY);
                assert (changingFrom != null);
                c = (JavaSourceFile)((SourceFile)c).withSourcePath(Paths.get(path.replaceFirst(changingFrom.replace('.', '/'), changingTo.replace('.', '/')), new String[0]));
                for (J.Import anImport : c.getImports()) {
                    if (!anImport.getPackageName().equals(ChangePackage.this.newPackageName)) continue;
                    c = new RemoveImport(anImport.getTypeName(), true).visitJavaSourceFile((JavaSourceFile)c, ctx);
                }
            }
            return c;
        }

        public J postVisit(J tree, ExecutionContext executionContext) {
            J j = (J)super.postVisit((Tree)tree, (Object)executionContext);
            if (j instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)j;
                return m.withMethodType(this.updateType(m.getMethodType()));
            }
            if (j instanceof J.MethodInvocation) {
                J.MethodInvocation m = (J.MethodInvocation)j;
                return m.withMethodType(this.updateType(m.getMethodType()));
            }
            if (j instanceof J.NewClass) {
                J.NewClass n = (J.NewClass)j;
                return n.withConstructorType(this.updateType(n.getConstructorType()));
            }
            if (j instanceof TypedTree) {
                return ((TypedTree)j).withType(this.updateType(((TypedTree)j).getType()));
            }
            return j;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            JavaType.FullyQualified type;
            J c = super.visitClassDeclaration(classDecl, ctx);
            String changingTo = (String)this.getCursor().getNearestMessage(RENAME_TO_KEY);
            if (changingTo != null && classDecl.getType() != null && (type = ((J.ClassDeclaration)c).getType()) != null) {
                c = ((J.ClassDeclaration)c).withType(type.withFullyQualifiedName(changingTo + "." + ((J.ClassDeclaration)c).getType().getClassName()));
            }
            return c;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (!(!((J.FieldAccess)f).isFullyQualifiedClassReference(ChangePackage.this.oldPackageName) || this.getCursor().getParent() == null || this.getCursor().getParent().getValue() instanceof J.FieldAccess && ((J.FieldAccess)this.getCursor().getParent().getValue()).isFullyQualifiedClassReference(ChangePackage.this.newPackageName))) {
                f = (J.FieldAccess)TypeTree.build(((JavaType.FullyQualified)this.newPackageType).getFullyQualifiedName()).withPrefix(((J.FieldAccess)f).getPrefix());
            }
            return f;
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext context) {
            String original = pkg.getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "");
            this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_FROM_KEY, (Object)original);
            if (original.equals(ChangePackage.this.oldPackageName)) {
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_TO_KEY, (Object)ChangePackage.this.newPackageName);
                pkg = (J.Package)pkg.withTemplate(JavaTemplate.builder(() -> ((ChangePackageVisitor)this).getCursor(), ChangePackage.this.newPackageName).build(), pkg.getCoordinates().replace(), new Object[0]);
            } else if ((ChangePackage.this.recursive == null || ChangePackage.this.recursive.booleanValue()) && original.startsWith(ChangePackage.this.oldPackageName) && !original.startsWith(ChangePackage.this.newPackageName)) {
                String changingTo = ChangePackage.this.newPackageName + original.substring(ChangePackage.this.oldPackageName.length());
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_TO_KEY, (Object)changingTo);
                pkg = (J.Package)pkg.withTemplate(JavaTemplate.builder(() -> ((ChangePackageVisitor)this).getCursor(), changingTo).build(), pkg.getCoordinates().replace(), new Object[0]);
            }
            return pkg;
        }

        @Nullable
        private JavaType updateType(@Nullable JavaType javaType) {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified(javaType);
            if (fq != null && fq.getPackageName().equals(ChangePackage.this.oldPackageName) && !fq.getClassName().isEmpty()) {
                return TypeUtils.asFullyQualified(JavaType.buildType(ChangePackage.this.newPackageName + "." + fq.getClassName()));
            }
            return javaType;
        }

        @Nullable
        private JavaType.Method updateType(@Nullable JavaType.Method mt) {
            if (mt != null) {
                return mt.withDeclaringType((JavaType.FullyQualified)this.updateType(mt.getDeclaringType())).withReturnType(this.updateType(mt.getReturnType())).withParameterTypes(ListUtils.map(mt.getParameterTypes(), this::updateType));
            }
            return null;
        }
    }
}

