/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.13.0")
public class JavaTypeVisitor<P> {
    private Cursor cursor = new Cursor(null, (Object)"root");

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    @Nullable
    public <JT extends JavaType> List<JT> visit(@Nullable List<JT> javaTypes, P p) {
        return ListUtils.map(javaTypes, jt -> this.visit((JavaType)jt, p));
    }

    @Nullable
    public JavaType preVisit(JavaType javaType, P p) {
        return javaType;
    }

    public JavaType visitNonNull(JavaType javaType, P p) {
        JavaType t = this.visit(javaType, p);
        assert (t != null);
        return t;
    }

    public JavaType visit(@Nullable JavaType javaType, P p) {
        if (javaType != null) {
            this.cursor = new Cursor(this.cursor, (Object)javaType);
            if ((javaType = this.preVisit(javaType, p)) instanceof JavaType.Array) {
                return this.visitArray((JavaType.Array)javaType, p);
            }
            if (javaType instanceof JavaType.Class) {
                return this.visitClass((JavaType.Class)javaType, p);
            }
            if (javaType instanceof JavaType.Cyclic) {
                return this.visitCyclic((JavaType.Cyclic)javaType, p);
            }
            if (javaType instanceof JavaType.GenericTypeVariable) {
                return this.visitGenericTypeVariable((JavaType.GenericTypeVariable)javaType, p);
            }
            if (javaType instanceof JavaType.Method) {
                return this.visitMethod((JavaType.Method)javaType, p);
            }
            if (javaType instanceof JavaType.MultiCatch) {
                return this.visitMultiCatch((JavaType.MultiCatch)javaType, p);
            }
            if (javaType instanceof JavaType.Parameterized) {
                return this.visitParameterized((JavaType.Parameterized)javaType, p);
            }
            if (javaType instanceof JavaType.Primitive) {
                return this.visitPrimitive((JavaType.Primitive)javaType, p);
            }
            if (javaType instanceof JavaType.ShallowClass) {
                return this.visitShallowClass((JavaType.ShallowClass)javaType, p);
            }
            if (javaType instanceof JavaType.Variable) {
                return this.visitVariable((JavaType.Variable)javaType, p);
            }
            this.cursor = this.cursor.getParentOrThrow();
        }
        return null;
    }

    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, P p) {
        return multiCatch.withThrowableTypes(ListUtils.map(multiCatch.getThrowableTypes(), tt -> this.visit((JavaType)tt, p)));
    }

    public JavaType visitArray(JavaType.Array array, P p) {
        return this.visit(array.getElemType(), p);
    }

    public JavaType visitClass(JavaType.Class aClass, P p) {
        JavaType.Class c = aClass;
        c = c.withAnnotations(ListUtils.map(c.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        c = c.withSupertype((JavaType.FullyQualified)this.visit(c.getSupertype(), p));
        c = c.withInterfaces(ListUtils.map(c.getInterfaces(), i -> (JavaType.FullyQualified)this.visit((JavaType)i, p)));
        c = c.withMembers(ListUtils.map(c.getMembers(), m -> (JavaType.Variable)this.visit((JavaType)m, p)));
        c = c.withMethods(ListUtils.map(c.getMethods(), m -> (JavaType.Method)this.visit((JavaType)m, p)));
        c = c.withOwningClass((JavaType.FullyQualified)this.visit(c.getOwningClass(), p));
        return c;
    }

    public JavaType.Cyclic visitCyclic(JavaType.Cyclic cyclic, P p) {
        return cyclic;
    }

    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, P p) {
        return this.visit(generic.getBound(), p);
    }

    public JavaType visitMethod(JavaType.Method method, P p) {
        JavaType.Method.Signature resolvedSignature;
        JavaType.Method m = method;
        m = m.withAnnotations(ListUtils.map(m.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        JavaType.Method.Signature genericSignature = (m = m.withDeclaringType((JavaType.FullyQualified)this.visit(m.getDeclaringType(), p))).getGenericSignature();
        if (genericSignature != null) {
            m = m.withGenericSignature(genericSignature.withReturnType(this.visit(genericSignature.getReturnType(), p)).withParamTypes(ListUtils.map(genericSignature.getParamTypes(), pt -> this.visit((JavaType)pt, p))));
        }
        if ((resolvedSignature = m.getResolvedSignature()) != null) {
            m = m.withResolvedSignature(resolvedSignature.withReturnType(this.visit(resolvedSignature.getReturnType(), p)).withParamTypes(ListUtils.map(resolvedSignature.getParamTypes(), pt -> this.visit((JavaType)pt, p))));
        }
        m = m.withThrownExceptions(ListUtils.map(m.getThrownExceptions(), t -> (JavaType.FullyQualified)this.visit((JavaType)t, p)));
        return m;
    }

    public JavaType visitParameterized(JavaType.Parameterized parameterized, P p) {
        JavaType.Parameterized pa = parameterized;
        pa = pa.withType((JavaType.FullyQualified)this.visit(pa.getType(), p));
        pa = pa.withTypeParameters(ListUtils.map(pa.getTypeParameters(), t -> this.visit((JavaType)t, p)));
        return pa;
    }

    public JavaType visitPrimitive(JavaType.Primitive primitive, P p) {
        return primitive;
    }

    public JavaType visitShallowClass(JavaType.ShallowClass shallow, P p) {
        return shallow;
    }

    public JavaType visitVariable(JavaType.Variable variable, P p) {
        JavaType.Variable v = variable;
        v = v.withAnnotations(ListUtils.map(v.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        v = v.withOwner((JavaType.FullyQualified)this.visit(variable.getOwner(), p));
        v = v.withType(this.visit(variable.getType(), p));
        return v;
    }
}

