/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.grammar.TemplateParameterLexer;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public class Substitutions {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("__p(\\d+)__");
    private final String code;
    private final Object[] parameters;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);

    public String substitute() {
        String previous;
        AtomicInteger index = new AtomicInteger(0);
        String substituted = this.code;
        while (!(previous = substituted).equals(substituted = this.propertyPlaceholderHelper.replacePlaceholders(substituted, key -> {
            String s;
            int i = index.getAndIncrement();
            Object parameter = this.parameters[i];
            if (key.isEmpty()) return this.substituteUntyped(parameter, i);
            TemplateParameterParser parser = new TemplateParameterParser((TokenStream)new CommonTokenStream((TokenSource)new TemplateParameterLexer((CharStream)CharStreams.fromString((String)key))));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
            TemplateParameterParser.MatcherPatternContext ctx = parser.matcherPattern();
            String matcherName = ctx.matcherName().Identifier().getText();
            List<TemplateParameterParser.MatcherParameterContext> params = ctx.matcherParameter();
            if ("anyArray".equals(matcherName)) {
                JavaType.Method methodType;
                if (!(parameter instanceof TypedTree)) {
                    throw new IllegalArgumentException("anyArray can only be used on TypedTree parameters");
                }
                JavaType type = ((TypedTree)parameter).getType();
                JavaType.Array arrayType = TypeUtils.asArray(type);
                if (arrayType == null && (arrayType = TypeUtils.asArray((methodType = TypeUtils.asMethod(type)) == null ? null : methodType.getResolvedSignature().getReturnType())) == null) {
                    throw new IllegalArgumentException("anyArray can only be used on parameters containing JavaType.Array type attribution");
                }
                s = "(/*__p" + i + "__*/new ";
                StringBuilder extraDim = new StringBuilder();
                while (arrayType.getElemType() instanceof JavaType.Array) {
                    extraDim.append("[0]");
                    arrayType = (JavaType.Array)arrayType.getElemType();
                }
                if (arrayType.getElemType() instanceof JavaType.Primitive) {
                    s = s + ((JavaType.Primitive)arrayType.getElemType()).getKeyword();
                    return s + "[0]" + extraDim + ")";
                } else {
                    if (!(arrayType.getElemType() instanceof JavaType.FullyQualified)) return s + "[0]" + extraDim + ")";
                    s = s + ((JavaType.FullyQualified)arrayType.getElemType()).getFullyQualifiedName();
                }
                return s + "[0]" + extraDim + ")";
            }
            if (!"any".equals(matcherName)) throw new IllegalArgumentException("Invalid template matcher '" + key + "'");
            String fqn = params.size() == 1 ? params.get(0).FullyQualifiedName().getText() : (!(parameter instanceof TypedTree) ? "java.lang.Object" : this.getTypeName(((TypedTree)parameter).getType()));
            JavaType.Primitive primitive = JavaType.Primitive.fromKeyword(fqn);
            s = "__P__." + (primitive == null || primitive.equals(JavaType.Primitive.String) ? "<" + fqn + ">/*__p" + i + "__*/p()" : "/*__p" + i + "__*/" + fqn + "p()");
            this.parameters[i] = ((J)parameter).withPrefix(Space.EMPTY);
            return s;
        }))) {
        }
        return substituted;
    }

    private String getTypeName(@Nullable JavaType type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Method) {
            return this.getTypeName(((JavaType.Method)type).getResolvedSignature().getReturnType());
        }
        return "java.lang.Object";
    }

    private String substituteUntyped(Object parameter, int index) {
        if (parameter instanceof J) {
            if (parameter instanceof J.Annotation) {
                return "@SubAnnotation(" + index + ")";
            }
            if (parameter instanceof J.Block) {
                return "/*__p" + index + "__*/{}";
            }
            if (parameter instanceof J.Literal || parameter instanceof J.VariableDeclarations) {
                return ((J)parameter).printTrimmed();
            }
            throw new IllegalArgumentException("Template parameter " + index + " cannot be used in an untyped template substitution. Instead of \"#{}\", indicate the template parameter's type with \"#{any(" + Substitutions.typeHintFor(parameter) + ")}\".");
        }
        if (parameter instanceof JRightPadded) {
            return this.substituteUntyped(((JRightPadded)parameter).getElement(), index);
        }
        if (parameter instanceof JLeftPadded) {
            return this.substituteUntyped(((JLeftPadded)parameter).getElement(), index);
        }
        return parameter.toString();
    }

    private static String typeHintFor(Object j) {
        if (j instanceof TypedTree) {
            return Substitutions.typeHintFor(((TypedTree)j).getType());
        }
        return "";
    }

    private static String typeHintFor(@Nullable JavaType t) {
        if (t instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)t).getKeyword();
        }
        if (t instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)t).getFullyQualifiedName();
        }
        if (t instanceof JavaType.Method) {
            JavaType.Method m = (JavaType.Method)t;
            if (m.getGenericSignature() != null) {
                return Substitutions.typeHintFor(m.getGenericSignature().getReturnType());
            }
            if (m.getResolvedSignature() != null) {
                return Substitutions.typeHintFor(m.getResolvedSignature().getReturnType());
            }
        }
        return "";
    }

    public <J2 extends J> List<J2> unsubstitute(List<J2> js) {
        return ListUtils.map(js, this::unsubstitute);
    }

    public <J2 extends J> J2 unsubstitute(J2 j) {
        if (this.parameters.length == 0) {
            return j;
        }
        J unsub = (J)new JavaVisitor<Integer>(){

            @Override
            public J visitAnnotation(J.Annotation annotation, Integer integer) {
                if (TypeUtils.isOfClassType(annotation.getType(), "SubAnnotation")) {
                    J.Literal index = (J.Literal)annotation.getArguments().get(0);
                    J a2 = (J)Substitutions.this.parameters[(Integer)index.getValue()];
                    return a2.withPrefix(a2.getPrefix().withWhitespace(annotation.getPrefix().getWhitespace()));
                }
                return super.visitAnnotation(annotation, integer);
            }

            @Override
            public J visitBlock(J.Block block, Integer integer) {
                J param = this.maybeParameter(block);
                if (param != null) {
                    return param;
                }
                return super.visitBlock(block, integer);
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                J param = this.maybeParameter(method.getName());
                if (param != null) {
                    return param;
                }
                return super.visitMethodInvocation(method, integer);
            }

            @Override
            public <T extends J> J visitParentheses(J.Parentheses<T> parens, Integer integer) {
                J param = this.maybeParameter((J)parens.getTree());
                if (param != null) {
                    return param;
                }
                return super.visitParentheses(parens, integer);
            }

            @Override
            public J visitLiteral(J.Literal literal, Integer integer) {
                J param = this.maybeParameter(literal);
                if (param != null) {
                    return param;
                }
                return super.visitLiteral(literal, integer);
            }

            @Nullable
            private J maybeParameter(J j) {
                Integer param = this.parameterIndex(j.getPrefix());
                if (param != null) {
                    J j2 = (J)Substitutions.this.parameters[param];
                    return j2.withPrefix(j2.getPrefix().withWhitespace(j.getPrefix().getWhitespace()));
                }
                return null;
            }

            @Nullable
            private Integer parameterIndex(Space space) {
                for (Comment comment : space.getComments()) {
                    Matcher matcher;
                    if (!(comment instanceof TextComment) || !(matcher = PATTERN_COMMENT.matcher(((TextComment)comment).getText())).matches()) continue;
                    return Integer.valueOf(matcher.group(1));
                }
                return null;
            }
        }.visit(j, 0);
        assert (unsub != null);
        return (J2)unsub;
    }

    public Substitutions(String code, Object[] parameters) {
        this.code = code;
        this.parameters = parameters;
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new IllegalArgumentException(String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), (Throwable)e);
        }
    }
}

