/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public class ObjectFinalizeCallsSuper
extends Recipe {
    private static final MethodMatcher FINALIZE_METHOD_MATCHER = new MethodMatcher("java.lang.Object finalize()", true);

    public String getDisplayName() {
        return "Object#finalize() invokes super#finalize()";
    }

    public String getDescription() {
        return "`Object#finalize()` methods should invoke `super.finalize()`";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1114");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                for (JavaType.Method md : cu.getDeclaredMethods()) {
                    if (!FINALIZE_METHOD_MATCHER.matches(md)) continue;
                    return (JavaSourceFile)cu.withMarkers(cu.getMarkers().searchResult());
                }
                return cu;
            }
        };
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J md = super.visitMethodDeclaration(method, executionContext);
                if (FINALIZE_METHOD_MATCHER.matches(((J.MethodDeclaration)md).getType()) && !this.hasSuperFinalizeMethodInvocation((J.MethodDeclaration)md)) {
                    md = (J.MethodDeclaration)md.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "super.finalize()").build(), ((J.MethodDeclaration)md).getBody().getCoordinates().lastStatement(), new Object[0]);
                }
                return md;
            }

            private boolean hasSuperFinalizeMethodInvocation(J.MethodDeclaration md) {
                AtomicBoolean hasSuperFinalize = new AtomicBoolean(Boolean.FALSE);
                new FindSuperFinalizeVisitor().visit(md, hasSuperFinalize);
                return hasSuperFinalize.get();
            }
        };
    }

    private static class FindSuperFinalizeVisitor
    extends JavaIsoVisitor<AtomicBoolean> {
        private FindSuperFinalizeVisitor() {
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean exists) {
            J mi = super.visitMethodInvocation(method, exists);
            if (FINALIZE_METHOD_MATCHER.matches((J.MethodInvocation)mi)) {
                exists.set(Boolean.TRUE);
            }
            return mi;
        }
    }
}

