/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class NoPrimitiveWrappersForToStringOrCompareTo
extends Recipe {
    private static final MethodMatcher NUMBER_TO_STRING_MATCHER = new MethodMatcher("java.lang.Number toString()", true);
    private static final MethodMatcher BOOLEAN_TO_STRING_MATCHER = new MethodMatcher("java.lang.Boolean toString()", true);
    private static final MethodMatcher NUMBER_COMPARE_TO_MATCHER = new MethodMatcher("java.lang.Number compareTo(..)", true);
    private static final MethodMatcher BOOLEAN_COMPARE_TO_MATCHER = new MethodMatcher("java.lang.Boolean compareTo(..)", true);

    public String getDisplayName() {
        return "No primitive wrappers for #toString() or #compareTo(..)";
    }

    public String getDescription() {
        return "Primitive wrappers should not be instantiated only for `#toString()` or `#compareTo(..)` invocations";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1158");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new NoPrimitiveWrapperVisitor();
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesMethod(NUMBER_COMPARE_TO_MATCHER));
                this.doAfterVisit(new UsesMethod(NUMBER_TO_STRING_MATCHER));
                this.doAfterVisit(new UsesMethod(BOOLEAN_COMPARE_TO_MATCHER));
                this.doAfterVisit(new UsesMethod(BOOLEAN_TO_STRING_MATCHER));
                return cu;
            }
        };
    }

    private static class NoPrimitiveWrapperVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher VALUE_OF_NUMBER_MATCHER = new MethodMatcher("java.lang.Number valueOf(*)", true);
        private static final MethodMatcher VALUE_OF_BOOLEAN_MATCHER = new MethodMatcher("java.lang.Boolean valueOf(*)", true);

        private NoPrimitiveWrapperVisitor() {
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            JavaType.Class clazz;
            J mi = super.visitMethodInvocation(method, executionContext);
            JavaType.Class clazz2 = clazz = ((J.MethodInvocation)mi).getType() != null ? TypeUtils.asClass(((J.MethodInvocation)mi).getType().getDeclaringType()) : null;
            if (clazz != null && "java.lang".equals(clazz.getPackageName())) {
                if (NUMBER_TO_STRING_MATCHER.matches((J.MethodInvocation)mi) || BOOLEAN_TO_STRING_MATCHER.matches((J.MethodInvocation)mi)) {
                    J.MethodInvocation selectMethod;
                    Expression arg = null;
                    if (((J.MethodInvocation)mi).getSelect() instanceof J.NewClass) {
                        arg = this.getSingleArg(((J.NewClass)((J.MethodInvocation)mi).getSelect()).getArguments());
                    } else if (((J.MethodInvocation)mi).getSelect() instanceof J.MethodInvocation && (VALUE_OF_NUMBER_MATCHER.matches(selectMethod = (J.MethodInvocation)((J.MethodInvocation)mi).getSelect()) || VALUE_OF_BOOLEAN_MATCHER.matches(selectMethod))) {
                        arg = this.getSingleArg(selectMethod.getArguments());
                    }
                    if (arg != null && !TypeUtils.isString(arg.getType()) && ((J.MethodInvocation)mi).getSelect() != null) {
                        JavaType.FullyQualified fq = ((J.MethodInvocation)mi).getType().getDeclaringType();
                        mi = ((J.MethodInvocation)mi).withSelect(J.Identifier.build(UUID.randomUUID(), ((J.MethodInvocation)mi).getSelect().getPrefix(), Markers.EMPTY, fq.getClassName(), fq));
                        mi = ((J.MethodInvocation)mi).withArguments(Arrays.asList(arg));
                    }
                } else if (NUMBER_COMPARE_TO_MATCHER.matches((J.MethodInvocation)mi) || BOOLEAN_COMPARE_TO_MATCHER.matches((J.MethodInvocation)mi)) {
                    J.MethodInvocation selectMethod;
                    Expression arg = null;
                    if (((J.MethodInvocation)mi).getSelect() instanceof J.NewClass) {
                        arg = this.getSingleArg(((J.NewClass)((J.MethodInvocation)mi).getSelect()).getArguments());
                    } else if (((J.MethodInvocation)mi).getSelect() instanceof J.MethodInvocation && (VALUE_OF_NUMBER_MATCHER.matches(selectMethod = (J.MethodInvocation)((J.MethodInvocation)mi).getSelect()) || VALUE_OF_BOOLEAN_MATCHER.matches(selectMethod))) {
                        arg = this.getSingleArg(selectMethod.getArguments());
                    }
                    if (arg != null && !TypeUtils.isString(arg.getType()) && ((J.MethodInvocation)mi).getSelect() != null) {
                        JavaType.FullyQualified fq = ((J.MethodInvocation)mi).getType().getDeclaringType();
                        mi = ((J.MethodInvocation)mi).withSelect(J.Identifier.build(UUID.randomUUID(), ((J.MethodInvocation)mi).getSelect().getPrefix(), Markers.EMPTY, fq.getClassName(), fq));
                        mi = ((J.MethodInvocation)mi).withArguments(ListUtils.concat((Object)arg, ((J.MethodInvocation)mi).getArguments()));
                        mi = this.maybeAutoFormat(mi, ((J.MethodInvocation)mi).withName(((J.MethodInvocation)mi).getName().withName("compare")), executionContext);
                    }
                }
            }
            return mi;
        }

        @Nullable
        private Expression getSingleArg(@Nullable List<Expression> args) {
            if (args != null && args.size() == 1 && !(args.get(0) instanceof J.Empty)) {
                return args.get(0);
            }
            return null;
        }
    }
}

