/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.Tree;
import org.openrewrite.java.style.DefaultComesLastStyle;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.EqualsAvoidsNullStyle;
import org.openrewrite.java.style.ExplicitInitializationStyle;
import org.openrewrite.java.style.FallThroughStyle;
import org.openrewrite.java.style.HiddenFieldStyle;
import org.openrewrite.java.style.HideUtilityClassConstructorStyle;
import org.openrewrite.java.style.MethodParamPadStyle;
import org.openrewrite.java.style.NeedBracesStyle;
import org.openrewrite.java.style.NoWhitespaceAfterStyle;
import org.openrewrite.java.style.NoWhitespaceBeforeStyle;
import org.openrewrite.java.style.OperatorWrapStyle;
import org.openrewrite.java.style.TypecastParenPadStyle;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Checkstyle
extends NamedStyles {
    private static final Checkstyle INSTANCE = new Checkstyle();
    private static final String NAME = "org.openrewrite.java.Checkstyle";
    private static final String DISPLAY_NAME = "Checkstyle";
    private static final String DESCRIPTION = "Checkstyle defaults for styles";
    public static final EmptyBlockStyle.BlockPolicy defaultBlockPolicy = EmptyBlockStyle.BlockPolicy.STATEMENT;
    public static final OperatorWrapStyle.WrapOption defaultOperatorWrapStyleOption = OperatorWrapStyle.WrapOption.NL;

    private Checkstyle() {
        super(Tree.randomId(), NAME, DISPLAY_NAME, DESCRIPTION, Collections.emptySet(), Arrays.asList(Checkstyle.defaultComesLast(), Checkstyle.emptyBlock(), Checkstyle.emptyForInitializerPadStyle(), Checkstyle.emptyForIteratorPadStyle(), Checkstyle.equalsAvoidsNull(), Checkstyle.explicitInitialization(), Checkstyle.fallThrough(), Checkstyle.hiddenFieldStyle(), Checkstyle.hideUtilityClassConstructorStyle(), Checkstyle.methodParamPadStyle(), Checkstyle.needBracesStyle(), Checkstyle.noWhitespaceAfterStyle(), Checkstyle.noWhitespaceBeforeStyle(), Checkstyle.operatorWrapStyle(), Checkstyle.typecastParenPadStyle(), Checkstyle.unnecessaryParentheses()));
    }

    Checkstyle(Collection<Style> styles) {
        super(Tree.randomId(), NAME, DISPLAY_NAME, DESCRIPTION, Collections.emptySet(), styles);
    }

    @JsonCreator
    public static Checkstyle defaults() {
        return INSTANCE;
    }

    public static DefaultComesLastStyle defaultComesLast() {
        return new DefaultComesLastStyle(false);
    }

    public static EmptyBlockStyle emptyBlock() {
        return new EmptyBlockStyle(defaultBlockPolicy, true, true, true, true, true, true, true, true, true, true, true, true);
    }

    public static EqualsAvoidsNullStyle equalsAvoidsNull() {
        return new EqualsAvoidsNullStyle(false);
    }

    public static ExplicitInitializationStyle explicitInitialization() {
        return new ExplicitInitializationStyle(false);
    }

    public static FallThroughStyle fallThrough() {
        return new FallThroughStyle(false);
    }

    public static HiddenFieldStyle hiddenFieldStyle() {
        return new HiddenFieldStyle(true, true, true, false);
    }

    public static HideUtilityClassConstructorStyle hideUtilityClassConstructorStyle() {
        return new HideUtilityClassConstructorStyle(Arrays.asList("@lombok.experimental.UtilityClass", "@lombok.Data"));
    }

    public static NeedBracesStyle needBracesStyle() {
        return new NeedBracesStyle(false, false);
    }

    public static NoWhitespaceAfterStyle noWhitespaceAfterStyle() {
        return new NoWhitespaceAfterStyle(true, false, false, true, true, true, true, false, true, true, true, true, true, true);
    }

    public static NoWhitespaceBeforeStyle noWhitespaceBeforeStyle() {
        return new NoWhitespaceBeforeStyle(false, false, true, true, false, false, false, true, true);
    }

    public static OperatorWrapStyle operatorWrapStyle() {
        return new OperatorWrapStyle(defaultOperatorWrapStyleOption, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    public static TypecastParenPadStyle typecastParenPadStyle() {
        return new TypecastParenPadStyle(false);
    }

    public static UnnecessaryParenthesesStyle unnecessaryParentheses() {
        return new UnnecessaryParenthesesStyle(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
    }

    public static EmptyForInitializerPadStyle emptyForInitializerPadStyle() {
        return new EmptyForInitializerPadStyle(false);
    }

    public static EmptyForIteratorPadStyle emptyForIteratorPadStyle() {
        return new EmptyForIteratorPadStyle(false);
    }

    public static MethodParamPadStyle methodParamPadStyle() {
        return new MethodParamPadStyle(false, false);
    }
}

