/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class UsesType<P>
extends JavaIsoVisitor<P> {
    private final JavaType.FullyQualified fullyQualifiedType;
    private final List<String> fullyQualifiedTypeSegments;

    public UsesType(String fullyQualifiedType) {
        this.fullyQualifiedType = JavaType.Class.build(fullyQualifiedType);
        Scanner scanner = new Scanner(fullyQualifiedType);
        scanner.useDelimiter("\\.");
        this.fullyQualifiedTypeSegments = new ArrayList<String>();
        while (scanner.hasNext()) {
            this.fullyQualifiedTypeSegments.add(scanner.next());
        }
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit c = cu;
        Set<JavaType> types = c.getTypesInUse();
        for (JavaType type : types) {
            JavaType.Method method;
            JavaType.FullyQualified fq;
            if (!(type instanceof JavaType.FullyQualified ? (c = this.maybeMark(c, fq = (JavaType.FullyQualified)type)) != cu : type instanceof JavaType.Method && (method = (JavaType.Method)type).hasFlags(Flag.Static) && (c = this.maybeMark(c, method.getDeclaringType())) != cu)) continue;
            return c;
        }
        for (J.Import anImport : c.getImports()) {
            if (!(anImport.isStatic() ? (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType()))) != cu : (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getType()))) != cu)) continue;
            return c;
        }
        return c;
    }

    private J.CompilationUnit maybeMark(J.CompilationUnit c, @Nullable JavaType.FullyQualified fq) {
        String segment;
        if (fq == null) {
            return c;
        }
        if (this.fullyQualifiedType.isAssignableFrom(fq)) {
            return c.withMarkers(c.getMarkers().searchResult());
        }
        Scanner scanner = new Scanner(fq.getFullyQualifiedName());
        scanner.useDelimiter("\\.");
        for (int i = 0; scanner.hasNext() && i < this.fullyQualifiedTypeSegments.size() && !(segment = this.fullyQualifiedTypeSegments.get(i)).equals("*"); ++i) {
            String test = scanner.next();
            if (segment.equals(test)) continue;
            return c;
        }
        return c.withMarkers(c.getMarkers().searchResult());
    }
}

