/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class FindDeprecatedFields
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find matching field uses.", example="org.springframework..*", required=false)
    @Nullable
    private final String typePattern;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated method is used in a deprecated method or class, ignore it.", required=false)
    @Nullable
    private final Boolean ignoreDeprecatedScopes;

    public String getDisplayName() {
        return "Find uses of deprecated fields";
    }

    public String getDescription() {
        return "Find uses of deprecated fields in any API.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        final TypeMatcher typeMatcher = this.typePattern == null ? null : new TypeMatcher(this.typePattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (JavaType javaType : cu.getTypesInUse()) {
                    JavaType.Variable variable = TypeUtils.asVariable(javaType);
                    if (variable == null || typeMatcher != null && !typeMatcher.matches(variable.getOwner())) continue;
                    for (JavaType.FullyQualified annotation : variable.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        return cu.withMarkers(cu.getMarkers().searchResult());
                    }
                }
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        final TypeMatcher typeMatcher = this.typePattern == null ? null : new TypeMatcher(this.typePattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                J i = super.visitIdentifier(identifier, ctx);
                JavaType.Variable varType = TypeUtils.asVariable(identifier.getFieldType());
                if (varType != null && (typeMatcher == null || typeMatcher.matches(varType.getOwner()))) {
                    for (JavaType.FullyQualified annotation : varType.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        if (Boolean.TRUE.equals(FindDeprecatedFields.this.ignoreDeprecatedScopes)) {
                            Iterator cursorPath = this.getCursor().getPath();
                            while (cursorPath.hasNext()) {
                                Object ancestor = cursorPath.next();
                                if (ancestor instanceof J.MethodDeclaration && this.isDeprecated(((J.MethodDeclaration)ancestor).getAllAnnotations())) {
                                    return i;
                                }
                                if (!(ancestor instanceof J.ClassDeclaration) || !this.isDeprecated(((J.ClassDeclaration)ancestor).getAllAnnotations())) continue;
                                return i;
                            }
                        }
                        i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().searchResult());
                    }
                }
                return i;
            }

            private boolean isDeprecated(List<J.Annotation> annotations) {
                for (J.Annotation annotation : annotations) {
                    if (!TypeUtils.isOfClassType(annotation.getType(), "java.lang.Deprecated")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public FindDeprecatedFields(@Nullable String typePattern, @Nullable Boolean ignoreDeprecatedScopes) {
        this.typePattern = typePattern;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Nullable
    public String getTypePattern() {
        return this.typePattern;
    }

    @Nullable
    public Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @NonNull
    public String toString() {
        return "FindDeprecatedFields(typePattern=" + this.getTypePattern() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedFields)) {
            return false;
        }
        FindDeprecatedFields other = (FindDeprecatedFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        return !(this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeprecatedFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        return result;
    }
}

