/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class MissingOverrideAnnotation
extends Recipe {
    @Option(displayName="Ignore `Object` methods", description="When enabled, ignore missing annotations on methods which override methods from the base `java.lang.Object` class such as `equals()`, `hashCode()`, or `toString()`.", required=false)
    @Nullable
    private final Boolean ignoreObjectMethods;
    @Option(displayName="Ignore methods in anonymous classes", description="When enabled, ignore missing annotations on methods which override methods when the class definition is within an anonymous class.", required=false)
    @Nullable
    private final Boolean ignoreAnonymousClassMethods;

    public String getDisplayName() {
        return "Add missing `@Override` to overriding and implementing methods";
    }

    public String getDescription() {
        return "Adds `@Override` to methods overriding superclass methods or implementing interface methods. Annotating methods improves readability by showing the author's intent to override. Additionally, when annotated, the compiler will emit an error when a signature of the overridden method does not match the superclass method.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1161");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MissingOverrideAnnotationVisitor();
    }

    public MissingOverrideAnnotation(@Nullable Boolean ignoreObjectMethods, @Nullable Boolean ignoreAnonymousClassMethods) {
        this.ignoreObjectMethods = ignoreObjectMethods;
        this.ignoreAnonymousClassMethods = ignoreAnonymousClassMethods;
    }

    @Nullable
    public Boolean getIgnoreObjectMethods() {
        return this.ignoreObjectMethods;
    }

    @Nullable
    public Boolean getIgnoreAnonymousClassMethods() {
        return this.ignoreAnonymousClassMethods;
    }

    @NonNull
    public String toString() {
        return "MissingOverrideAnnotation(ignoreObjectMethods=" + this.getIgnoreObjectMethods() + ", ignoreAnonymousClassMethods=" + this.getIgnoreAnonymousClassMethods() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MissingOverrideAnnotation)) {
            return false;
        }
        MissingOverrideAnnotation other = (MissingOverrideAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreObjectMethods = this.getIgnoreObjectMethods();
        Boolean other$ignoreObjectMethods = other.getIgnoreObjectMethods();
        if (this$ignoreObjectMethods == null ? other$ignoreObjectMethods != null : !((Object)this$ignoreObjectMethods).equals(other$ignoreObjectMethods)) {
            return false;
        }
        Boolean this$ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        Boolean other$ignoreAnonymousClassMethods = other.getIgnoreAnonymousClassMethods();
        return !(this$ignoreAnonymousClassMethods == null ? other$ignoreAnonymousClassMethods != null : !((Object)this$ignoreAnonymousClassMethods).equals(other$ignoreAnonymousClassMethods));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MissingOverrideAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreObjectMethods = this.getIgnoreObjectMethods();
        result = result * 59 + ($ignoreObjectMethods == null ? 43 : ((Object)$ignoreObjectMethods).hashCode());
        Boolean $ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        result = result * 59 + ($ignoreAnonymousClassMethods == null ? 43 : ((Object)$ignoreAnonymousClassMethods).hashCode());
        return result;
    }

    private class MissingOverrideAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");

        private MissingOverrideAnnotationVisitor() {
        }

        private Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.NewClass || is instanceof J.ClassDeclaration);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (method.getType() != null && method.getType().getDeclaringType() != null && !method.hasModifier(J.Modifier.Type.Static)) {
                JavaType.FullyQualified declaringType;
                if (method.getAllAnnotations().stream().noneMatch(this.OVERRIDE_ANNOTATION::matches) && (!Boolean.TRUE.equals(MissingOverrideAnnotation.this.ignoreAnonymousClassMethods) || !(this.getCursorToParentScope(this.getCursor()).getValue() instanceof J.NewClass)) && new FindOverriddenAndImplementedMethodDeclarations(method, declaringType = method.getType().getDeclaringType()).hasAny()) {
                    method = (J.MethodDeclaration)method.withTemplate(JavaTemplate.builder(() -> ((MissingOverrideAnnotationVisitor)this).getCursor(), "@Override").build(), method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
            }
            return super.visitMethodDeclaration(method, ctx);
        }

        private class FindOverriddenAndImplementedMethodDeclarations {
            private final J.MethodDeclaration methodTarget;
            private final JavaType.FullyQualified declaringType;

            private FindOverriddenAndImplementedMethodDeclarations(J.MethodDeclaration methodTarget, JavaType.FullyQualified declaringType) {
                this.methodTarget = methodTarget;
                this.declaringType = declaringType;
            }

            private boolean hasAny() {
                return this.hasAny(this.declaringType);
            }

            private boolean hasAny(@Nullable JavaType.FullyQualified typeToSearch) {
                if (typeToSearch == null || this.methodTarget.getType() == null || (MissingOverrideAnnotation.this.ignoreObjectMethods == null || Boolean.TRUE.equals(MissingOverrideAnnotation.this.ignoreObjectMethods)) && "java.lang.Object".equals(typeToSearch.getFullyQualifiedName())) {
                    return false;
                }
                if (!this.declaringType.getFullyQualifiedName().equals(typeToSearch.getFullyQualifiedName())) {
                    String mPattern = MethodMatcher.methodPattern(this.methodTarget.withType(this.methodTarget.getType().withDeclaringType(typeToSearch)));
                    MethodMatcher matcher = new MethodMatcher(mPattern);
                    Predicate<JavaType.Method> filtering = typeToSearch.getKind() == JavaType.Class.Kind.Class ? m -> !m.hasFlags(Flag.Abstract) && !m.hasFlags(Flag.Abstract) && matcher.matches((JavaType)m) : m -> !m.hasFlags(Flag.Static) && matcher.matches((JavaType)m);
                    if (typeToSearch.getMethods().stream().anyMatch(filtering)) {
                        return true;
                    }
                }
                if (typeToSearch.getInterfaces().stream().anyMatch(this::hasAny)) {
                    return true;
                }
                if (typeToSearch.getSupertype() != null) {
                    return this.hasAny(typeToSearch.getSupertype());
                }
                return false;
            }
        }
    }
}

