/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;

public final class InJavaSourceSet<P>
extends JavaIsoVisitor<P> {
    private final String sourceSet;

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        return cu.getMarkers().findFirst(JavaSourceSet.class).filter(sourceSet -> !sourceSet.getName().equals(this.sourceSet)).map(sourceSet -> cu).orElse(cu.withMarkers(cu.getMarkers().searchResult()));
    }

    public InJavaSourceSet(String sourceSet) {
        this.sourceSet = sourceSet;
    }

    public String getSourceSet() {
        return this.sourceSet;
    }

    @NonNull
    public String toString() {
        return "InJavaSourceSet(sourceSet=" + this.getSourceSet() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InJavaSourceSet)) {
            return false;
        }
        InJavaSourceSet other = (InJavaSourceSet)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sourceSet = this.getSourceSet();
        String other$sourceSet = other.getSourceSet();
        return !(this$sourceSet == null ? other$sourceSet != null : !this$sourceSet.equals(other$sourceSet));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof InJavaSourceSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sourceSet = this.getSourceSet();
        result = result * 59 + ($sourceSet == null ? 43 : $sourceSet.hashCode());
        return result;
    }
}

