/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NoValueOfOnStringType
extends Recipe {
    public static final MethodMatcher VALUE_OF = new MethodMatcher("java.lang.String valueOf(java.lang.Object)");

    public String getDisplayName() {
        return "Use `String`";
    }

    public String getDescription() {
        return "Replaces`#valueOf(..)` with the argument if the type is already a String.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1153");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(4L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                Expression argument;
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (VALUE_OF.matches(mi) && ((argument = mi.getArguments().get(0)) instanceof J.MethodInvocation && TypeUtils.isOfType(((J.MethodInvocation)argument).getReturnType(), JavaType.Primitive.String) || TypeUtils.isOfType(argument.getType(), JavaType.Primitive.String))) {
                    return mi.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.lang.String)}").build(), mi.getCoordinates().replace(), argument);
                }
                return mi;
            }
        };
    }
}

