/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Optional;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

public class UsesJavaVersion<P>
extends JavaIsoVisitor<P> {
    private static final Marker JAVA_VERSION_SEARCH_RESULT = new JavaSearchResult(Tree.randomId(), null, null);
    int majorVersionMin;
    int majorVersionMax;

    public UsesJavaVersion(int majorVersion) {
        this.majorVersionMin = majorVersion;
        this.majorVersionMax = Integer.MAX_VALUE;
    }

    public UsesJavaVersion(int majorVersionMin, int majorVersionMax) {
        this.majorVersionMin = majorVersionMin;
        this.majorVersionMax = majorVersionMax;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        Optional javaVersion = cu.getMarkers().findFirst(JavaVersion.class);
        if (javaVersion.isPresent() && this.isVersionInRange(((JavaVersion)javaVersion.get()).getMajorVersion())) {
            return cu.withMarkers(cu.getMarkers().addIfAbsent(JAVA_VERSION_SEARCH_RESULT));
        }
        return cu;
    }

    private boolean isVersionInRange(int majorVersion) {
        return this.majorVersionMin > 0 && this.majorVersionMin <= majorVersion && majorVersion <= this.majorVersionMax;
    }
}

