/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.DefaultComesLastStyle;
import org.openrewrite.java.cleanup.DefaultComesLastVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.J;

public class DefaultComesLast
extends Recipe {
    public String getDisplayName() {
        return "Default comes last";
    }

    public String getDescription() {
        return "Ensure the `default` case comes last after all the cases in a switch statement.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DefaultComesLastFromCompilationUnitStyle();
    }

    private static class DefaultComesLastFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private DefaultComesLastFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            DefaultComesLastStyle style = (DefaultComesLastStyle)cu.getStyle(DefaultComesLastStyle.class);
            if (style == null) {
                style = Checkstyle.defaultComesLast();
            }
            this.doAfterVisit(new DefaultComesLastVisitor(style));
            return cu;
        }
    }
}

