/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefOrTypeVariableSignature;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.MethodParameterInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public final class JavaSourceSet
implements Marker {
    private final UUID id;
    private final String name;
    private final Set<JavaType.FullyQualified> classpath;

    public static JavaSourceSet build(String sourceSetName, Iterable<Path> classpath) {
        HashSet<JavaType.FullyQualified> fqns = new HashSet<JavaType.FullyQualified>();
        if (classpath.iterator().hasNext()) {
            for (ClassInfo classInfo : new ClassGraph().overrideClasspath(classpath).enableAnnotationInfo().enableMemoryMapping().enableClassInfo().enableMethodInfo().enableFieldInfo().scan().getAllClasses()) {
                fqns.add(JavaSourceSet.fromClassGraph(classInfo, new Stack<ClassInfo>()));
            }
            for (ClassInfo classInfo : new ClassGraph().enableMemoryMapping().enableAnnotationInfo().enableClassInfo().enableMethodInfo().enableFieldInfo().enableSystemJarsAndModules().acceptPackages(new String[]{"java"}).scan().getAllClasses()) {
                fqns.add(JavaSourceSet.fromClassGraph(classInfo, new Stack<ClassInfo>()));
            }
        }
        return new JavaSourceSet(Tree.randomId(), sourceSetName, fqns);
    }

    private static JavaType.FullyQualified fromClassGraph(ClassInfo aClass, Stack<ClassInfo> stack) {
        JavaType.Class existing = JavaType.Class.find(aClass.getName());
        if (existing != null) {
            return existing;
        }
        if (stack.contains(aClass)) {
            return new JavaType.ShallowClass(aClass.getName());
        }
        stack.add(aClass);
        Set<Flag> flags = Flag.bitMapToFlags(aClass.getModifiers());
        JavaType.Class.Kind kind = aClass.isInterface() ? JavaType.Class.Kind.Interface : (aClass.isEnum() ? JavaType.Class.Kind.Enum : (aClass.isAnnotation() ? JavaType.Class.Kind.Annotation : JavaType.Class.Kind.Class));
        List<JavaType.Variable> variables = JavaSourceSet.fromFieldInfo(aClass.getFieldInfo());
        List<JavaType.Method> methods = JavaSourceSet.fromMethodInfo(aClass.getMethodInfo(), stack);
        return JavaType.Class.build(Flag.flagsToBitMap(flags), aClass.getName(), kind, variables, new ArrayList<JavaType.FullyQualified>(), methods, null, null, new ArrayList<JavaType.FullyQualified>(), false);
    }

    private static List<JavaType.Variable> fromFieldInfo(@Nullable FieldInfoList fieldInfos) {
        if (fieldInfos != null) {
            ArrayList<JavaType.Variable> variables = new ArrayList<JavaType.Variable>(fieldInfos.size());
            for (FieldInfo fieldInfo : fieldInfos) {
                Set<Flag> flags = Flag.bitMapToFlags(fieldInfo.getModifiers());
                JavaType.Variable variable = JavaType.Variable.build(fieldInfo.getName(), JavaType.buildType(fieldInfo.getTypeDescriptor().toString()), Flag.flagsToBitMap(flags));
                variables.add(variable);
            }
            return variables;
        }
        return Collections.emptyList();
    }

    private static List<JavaType.Method> fromMethodInfo(MethodInfoList methodInfos, Stack<ClassInfo> stack) {
        ArrayList<JavaType.Method> methods = new ArrayList<JavaType.Method>(methodInfos.size());
        for (MethodInfo methodInfo : methodInfos) {
            Set<Flag> flags = Flag.bitMapToFlags(methodInfo.getModifiers());
            ArrayList<JavaType> parameterTypes = new ArrayList<JavaType>(methodInfo.getParameterInfo().length);
            for (MethodParameterInfo methodParameterInfo : methodInfo.getParameterInfo()) {
                parameterTypes.add(JavaType.buildType(methodParameterInfo.getTypeDescriptor().toString()));
            }
            JavaType.Method.Signature signature = new JavaType.Method.Signature(JavaType.buildType(methodInfo.getTypeDescriptor().getResultType().toString()), parameterTypes);
            ArrayList<String> methodParams = new ArrayList<String>(methodInfo.getParameterInfo().length);
            for (MethodParameterInfo methodParameterInfo3 : methodInfo.getParameterInfo()) {
                methodParams.add(methodParameterInfo3.getName());
            }
            ArrayList<JavaType.FullyQualified> thrownExceptions = new ArrayList<JavaType.FullyQualified>(methodInfo.getTypeDescriptor().getThrowsSignatures().size());
            for (ClassRefOrTypeVariableSignature throwsSignature : methodInfo.getTypeDescriptor().getThrowsSignatures()) {
                if (!(throwsSignature instanceof ClassRefTypeSignature)) continue;
                thrownExceptions.add(JavaSourceSet.fromClassGraph(((ClassRefTypeSignature)throwsSignature).getClassInfo(), stack));
            }
            ArrayList<JavaType.FullyQualified> arrayList = new ArrayList<JavaType.FullyQualified>(methodInfo.getAnnotationInfo().size());
            for (AnnotationInfo annotationInfo : methodInfo.getAnnotationInfo()) {
                arrayList.add(JavaSourceSet.fromClassGraph(annotationInfo.getClassInfo(), stack));
            }
            methods.add(JavaType.Method.build(flags, (JavaType.FullyQualified)JavaType.Class.build(methodInfo.getClassName()), methodInfo.getName(), null, signature, methodParams, thrownExceptions, arrayList));
        }
        return methods;
    }

    public JavaSourceSet(UUID id, String name, Set<JavaType.FullyQualified> classpath) {
        this.id = id;
        this.name = name;
        this.classpath = classpath;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<JavaType.FullyQualified> getClasspath() {
        return this.classpath;
    }

    @NonNull
    public String toString() {
        return "JavaSourceSet(id=" + this.getId() + ", name=" + this.getName() + ", classpath=" + this.getClasspath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSourceSet)) {
            return false;
        }
        JavaSourceSet other = (JavaSourceSet)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public JavaSourceSet withId(UUID id) {
        return this.id == id ? this : new JavaSourceSet(id, this.name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withName(String name) {
        return this.name == name ? this : new JavaSourceSet(this.id, name, this.classpath);
    }

    @NonNull
    public JavaSourceSet withClasspath(Set<JavaType.FullyQualified> classpath) {
        return this.classpath == classpath ? this : new JavaSourceSet(this.id, this.name, classpath);
    }
}

