/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.MethodParameterInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@Incubating(since="7.0.0")
public class JavaProvenance
implements Marker {
    private final UUID id;
    private final String projectName;
    private final String sourceSetName;
    private final BuildTool buildTool;
    private final JavaVersion javaVersion;
    private final Set<JavaType.FullyQualified> classpath;
    @Nullable
    private final Publication publication;

    public static JavaProvenance build(@Nullable String projectName, String sourceSetName, BuildTool buildTool, JavaVersion javaVersion, Iterable<Path> classpath, Publication publication) {
        HashSet<JavaType.FullyQualified> fqns = new HashSet<JavaType.FullyQualified>();
        if (classpath.iterator().hasNext()) {
            for (ClassInfo classInfo : new ClassGraph().overrideClasspath(classpath).enableMemoryMapping().enableClassInfo().enableMethodInfo().enableFieldInfo().scan().getAllClasses()) {
                fqns.add(JavaProvenance.fromClassGraph(classInfo));
            }
            for (ClassInfo classInfo : new ClassGraph().enableMemoryMapping().enableClassInfo().enableMethodInfo().enableFieldInfo().enableSystemJarsAndModules().acceptPackages(new String[]{"java"}).scan().getAllClasses()) {
                fqns.add(JavaProvenance.fromClassGraph(classInfo));
            }
        }
        return new JavaProvenance(UUID.randomUUID(), projectName, sourceSetName, buildTool, javaVersion, fqns, publication);
    }

    private static JavaType.FullyQualified fromClassGraph(ClassInfo aClass) {
        Set<Flag> flags = JavaProvenance.fromClassGraphModifiers(aClass.getModifiersStr());
        JavaType.Class.Kind kind = aClass.isInterface() ? JavaType.Class.Kind.Interface : (aClass.isEnum() ? JavaType.Class.Kind.Enum : (aClass.isAnnotation() ? JavaType.Class.Kind.Annotation : JavaType.Class.Kind.Class));
        List<JavaType.Variable> variables = JavaProvenance.fromFieldInfo(aClass.getFieldInfo());
        List<JavaType.Method> methods = JavaProvenance.fromMethodInfo(aClass.getMethodInfo());
        return JavaType.Class.build(Flag.flagsToBitMap(flags), aClass.getName(), kind, variables, new ArrayList<JavaType.FullyQualified>(), methods, null, null, new ArrayList<JavaType.FullyQualified>(), false);
    }

    private static Set<Flag> fromClassGraphModifiers(String modifiers) {
        HashSet<Flag> flags = new HashSet<Flag>();
        for (String modifier : modifiers.split("\\s+")) {
            Flag flag = Flag.fromKeyword(modifier);
            if (flag == null) continue;
            flags.add(flag);
        }
        return flags;
    }

    private static List<JavaType.Variable> fromFieldInfo(@Nullable FieldInfoList fieldInfos) {
        ArrayList<JavaType.Variable> variables = new ArrayList<JavaType.Variable>();
        if (fieldInfos != null) {
            for (FieldInfo fieldInfo : fieldInfos) {
                Set<Flag> flags = JavaProvenance.fromClassGraphModifiers(fieldInfo.getModifiersStr());
                JavaType.Variable variable = JavaType.Variable.build(fieldInfo.getName(), JavaType.buildType(fieldInfo.getTypeDescriptor().toString()), Flag.flagsToBitMap(flags));
                variables.add(variable);
            }
        }
        return variables;
    }

    private static List<JavaType.Method> fromMethodInfo(MethodInfoList methodInfos) {
        ArrayList<JavaType.Method> methods = new ArrayList<JavaType.Method>();
        for (MethodInfo methodInfo : methodInfos) {
            Set<Flag> flags = JavaProvenance.fromClassGraphModifiers(methodInfo.getModifiersStr());
            ArrayList<JavaType> parameterTypes = new ArrayList<JavaType>();
            for (MethodParameterInfo methodParameterInfo : methodInfo.getParameterInfo()) {
                parameterTypes.add(JavaType.buildType(methodParameterInfo.getTypeDescriptor().toString()));
            }
            JavaType.Method.Signature signature = new JavaType.Method.Signature(JavaType.buildType(methodInfo.getTypeDescriptor().getResultType().toString()), parameterTypes);
            ArrayList<String> methodParams = new ArrayList<String>();
            ArrayList<JavaType.FullyQualified> thrownExceptions = new ArrayList<JavaType.FullyQualified>();
            methods.add(JavaType.Method.build(flags, (JavaType.FullyQualified)JavaType.Class.build(methodInfo.getClassName()), methodInfo.getName(), null, signature, methodParams, thrownExceptions));
        }
        return methods;
    }

    public JavaProvenance(UUID id, String projectName, String sourceSetName, BuildTool buildTool, JavaVersion javaVersion, Set<JavaType.FullyQualified> classpath, @Nullable Publication publication) {
        this.id = id;
        this.projectName = projectName;
        this.sourceSetName = sourceSetName;
        this.buildTool = buildTool;
        this.javaVersion = javaVersion;
        this.classpath = classpath;
        this.publication = publication;
    }

    public UUID getId() {
        return this.id;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSourceSetName() {
        return this.sourceSetName;
    }

    public BuildTool getBuildTool() {
        return this.buildTool;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public Set<JavaType.FullyQualified> getClasspath() {
        return this.classpath;
    }

    @Nullable
    public Publication getPublication() {
        return this.publication;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaProvenance)) {
            return false;
        }
        JavaProvenance other = (JavaProvenance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$sourceSetName = this.getSourceSetName();
        String other$sourceSetName = other.getSourceSetName();
        if (this$sourceSetName == null ? other$sourceSetName != null : !this$sourceSetName.equals(other$sourceSetName)) {
            return false;
        }
        BuildTool this$buildTool = this.getBuildTool();
        BuildTool other$buildTool = other.getBuildTool();
        if (this$buildTool == null ? other$buildTool != null : !((Object)this$buildTool).equals(other$buildTool)) {
            return false;
        }
        JavaVersion this$javaVersion = this.getJavaVersion();
        JavaVersion other$javaVersion = other.getJavaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !((Object)this$javaVersion).equals(other$javaVersion)) {
            return false;
        }
        Set<JavaType.FullyQualified> this$classpath = this.getClasspath();
        Set<JavaType.FullyQualified> other$classpath = other.getClasspath();
        if (this$classpath == null ? other$classpath != null : !((Object)this$classpath).equals(other$classpath)) {
            return false;
        }
        Publication this$publication = this.getPublication();
        Publication other$publication = other.getPublication();
        return !(this$publication == null ? other$publication != null : !((Object)this$publication).equals(other$publication));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JavaProvenance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $sourceSetName = this.getSourceSetName();
        result = result * 59 + ($sourceSetName == null ? 43 : $sourceSetName.hashCode());
        BuildTool $buildTool = this.getBuildTool();
        result = result * 59 + ($buildTool == null ? 43 : ((Object)$buildTool).hashCode());
        JavaVersion $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : ((Object)$javaVersion).hashCode());
        Set<JavaType.FullyQualified> $classpath = this.getClasspath();
        result = result * 59 + ($classpath == null ? 43 : ((Object)$classpath).hashCode());
        Publication $publication = this.getPublication();
        result = result * 59 + ($publication == null ? 43 : ((Object)$publication).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "JavaProvenance(id=" + this.getId() + ", projectName=" + this.getProjectName() + ", sourceSetName=" + this.getSourceSetName() + ", buildTool=" + this.getBuildTool() + ", javaVersion=" + this.getJavaVersion() + ", classpath=" + this.getClasspath() + ", publication=" + this.getPublication() + ")";
    }

    public static class JavaVersion {
        private final String createdBy;
        private final String vmVendor;
        private final String sourceCompatibility;
        private final String targetCompatibility;

        public JavaVersion(String createdBy, String vmVendor, String sourceCompatibility, String targetCompatibility) {
            this.createdBy = createdBy;
            this.vmVendor = vmVendor;
            this.sourceCompatibility = sourceCompatibility;
            this.targetCompatibility = targetCompatibility;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public String getVmVendor() {
            return this.vmVendor;
        }

        public String getSourceCompatibility() {
            return this.sourceCompatibility;
        }

        public String getTargetCompatibility() {
            return this.targetCompatibility;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaVersion)) {
                return false;
            }
            JavaVersion other = (JavaVersion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$createdBy = this.getCreatedBy();
            String other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
                return false;
            }
            String this$vmVendor = this.getVmVendor();
            String other$vmVendor = other.getVmVendor();
            if (this$vmVendor == null ? other$vmVendor != null : !this$vmVendor.equals(other$vmVendor)) {
                return false;
            }
            String this$sourceCompatibility = this.getSourceCompatibility();
            String other$sourceCompatibility = other.getSourceCompatibility();
            if (this$sourceCompatibility == null ? other$sourceCompatibility != null : !this$sourceCompatibility.equals(other$sourceCompatibility)) {
                return false;
            }
            String this$targetCompatibility = this.getTargetCompatibility();
            String other$targetCompatibility = other.getTargetCompatibility();
            return !(this$targetCompatibility == null ? other$targetCompatibility != null : !this$targetCompatibility.equals(other$targetCompatibility));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof JavaVersion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $createdBy = this.getCreatedBy();
            result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
            String $vmVendor = this.getVmVendor();
            result = result * 59 + ($vmVendor == null ? 43 : $vmVendor.hashCode());
            String $sourceCompatibility = this.getSourceCompatibility();
            result = result * 59 + ($sourceCompatibility == null ? 43 : $sourceCompatibility.hashCode());
            String $targetCompatibility = this.getTargetCompatibility();
            result = result * 59 + ($targetCompatibility == null ? 43 : $targetCompatibility.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaProvenance.JavaVersion(createdBy=" + this.getCreatedBy() + ", vmVendor=" + this.getVmVendor() + ", sourceCompatibility=" + this.getSourceCompatibility() + ", targetCompatibility=" + this.getTargetCompatibility() + ")";
        }
    }

    public static class Publication {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public Publication(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Publication)) {
                return false;
            }
            Publication other = (Publication)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Publication;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaProvenance.Publication(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }

    public static class BuildTool {
        private final Type type;
        private final String version;

        public BuildTool(Type type, String version) {
            this.type = type;
            this.version = version;
        }

        public Type getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildTool)) {
                return false;
            }
            BuildTool other = (BuildTool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof BuildTool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaProvenance.BuildTool(type=" + (Object)((Object)this.getType()) + ", version=" + this.getVersion() + ")";
        }

        public static enum Type {
            Gradle,
            Maven;

        }
    }
}

