/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.OperatorWrapStyle;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.TypeTree;

public class OperatorWrap
extends Recipe {
    public String getDisplayName() {
        return "Operator wrapping";
    }

    public String getDescription() {
        return "Fixes line wrapping policies on operators.";
    }

    public Set<String> getTags() {
        return Collections.singleton("OperatorWrapCheck");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new OperatorWrapVisitor();
    }

    private static class OperatorWrapVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        OperatorWrapStyle operatorWrapStyle;

        private OperatorWrapVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.operatorWrapStyle = cu.getStyle(OperatorWrapStyle.class) == null ? Checkstyle.operatorWrapStyle() : (OperatorWrapStyle)cu.getStyle(OperatorWrapStyle.class);
            return super.visitCompilationUnit(cu, ctx);
        }

        @Override
        public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
            J b = super.visitBinary(binary, ctx);
            J.Binary.Type op = ((J.Binary)b).getOperator();
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getDiv()) && op == J.Binary.Type.Division || Boolean.TRUE.equals(this.operatorWrapStyle.getStar()) && op == J.Binary.Type.Multiplication || Boolean.TRUE.equals(this.operatorWrapStyle.getPlus()) && op == J.Binary.Type.Addition || Boolean.TRUE.equals(this.operatorWrapStyle.getMinus()) && op == J.Binary.Type.Subtraction || Boolean.TRUE.equals(this.operatorWrapStyle.getMod()) && op == J.Binary.Type.Modulo || Boolean.TRUE.equals(this.operatorWrapStyle.getSr()) && op == J.Binary.Type.RightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getSl()) && op == J.Binary.Type.LeftShift || Boolean.TRUE.equals(this.operatorWrapStyle.getBsr()) && op == J.Binary.Type.UnsignedRightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getEqual()) && op == J.Binary.Type.Equal || Boolean.TRUE.equals(this.operatorWrapStyle.getNotEqual()) && op == J.Binary.Type.NotEqual || Boolean.TRUE.equals(this.operatorWrapStyle.getGt()) && op == J.Binary.Type.GreaterThan || Boolean.TRUE.equals(this.operatorWrapStyle.getGe()) && op == J.Binary.Type.GreaterThanOrEqual || Boolean.TRUE.equals(this.operatorWrapStyle.getLt()) && op == J.Binary.Type.LessThan || Boolean.TRUE.equals(this.operatorWrapStyle.getLe()) && op == J.Binary.Type.LessThanOrEqual || Boolean.TRUE.equals(this.operatorWrapStyle.getBand()) && op == J.Binary.Type.BitAnd || Boolean.TRUE.equals(this.operatorWrapStyle.getBxor()) && op == J.Binary.Type.BitXor || Boolean.TRUE.equals(this.operatorWrapStyle.getBor()) && op == J.Binary.Type.BitOr || Boolean.TRUE.equals(this.operatorWrapStyle.getLand()) && op == J.Binary.Type.And || Boolean.TRUE.equals(this.operatorWrapStyle.getLor()) && op == J.Binary.Type.Or) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.Binary)b).getRight().getPrefix().getWhitespace().contains("\n")) {
                        b = ((J.Binary)b).getPadding().withOperator(((J.Binary)b).getPadding().getOperator().withBefore(((J.Binary)b).getRight().getPrefix()));
                        b = ((J.Binary)b).withRight((Expression)((J.Binary)b).getRight().withPrefix(((J.Binary)b).getRight().getPrefix().withWhitespace(" ")));
                    }
                } else if (((J.Binary)b).getPadding().getOperator().getBefore().getWhitespace().contains("\n")) {
                    b = ((J.Binary)b).withRight((Expression)((J.Binary)b).getRight().withPrefix(((J.Binary)b).getPadding().getOperator().getBefore()));
                    b = ((J.Binary)b).getPadding().withOperator(((J.Binary)b).getPadding().getOperator().withBefore(((J.Binary)b).getRight().getPrefix().withWhitespace(" ")));
                }
            }
            return b;
        }

        @Override
        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, ExecutionContext ctx) {
            J tp = super.visitTypeParameter(typeParam, ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getTypeExtensionAnd()) && ((J.TypeParameter)tp).getPadding().getBounds() != null) {
                int typeBoundsSize = ((J.TypeParameter)tp).getPadding().getBounds().getPadding().getElements().size();
                tp = ((J.TypeParameter)tp).getPadding().withBounds(((J.TypeParameter)tp).getPadding().getBounds().getPadding().withElements(ListUtils.map(((J.TypeParameter)tp).getPadding().getBounds().getPadding().getElements(), (index, elemContainer) -> {
                    JRightPadded<TypeTree> previous;
                    if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                        if (index != typeBoundsSize - 1 && typeParam.getPadding().getBounds() != null) {
                            JRightPadded<TypeTree> next = typeParam.getPadding().getBounds().getPadding().getElements().get(index + 1);
                            if (next.getElement().getPrefix().getWhitespace().contains("\n")) {
                                elemContainer = elemContainer.withAfter(next.getElement().getPrefix());
                            }
                        } else if (((TypeTree)elemContainer.getElement()).getPrefix().getWhitespace().contains("\n")) {
                            elemContainer = elemContainer.withElement((TypeTree)((TypeTree)elemContainer.getElement()).withPrefix(((TypeTree)elemContainer.getElement()).getPrefix().withWhitespace(" ")));
                        }
                    } else if (index != typeBoundsSize - 1) {
                        if (elemContainer.getAfter().getWhitespace().contains("\n")) {
                            elemContainer = elemContainer.withAfter(elemContainer.getAfter().withWhitespace(" "));
                        }
                    } else if (typeBoundsSize > 1 && typeParam.getPadding().getBounds() != null && (previous = typeParam.getPadding().getBounds().getPadding().getElements().get(index - 1)).getAfter().getWhitespace().contains("\n")) {
                        elemContainer = elemContainer.withElement((TypeTree)((TypeTree)elemContainer.getElement()).withPrefix(previous.getAfter()));
                    }
                    return elemContainer;
                })));
            }
            return tp;
        }

        @Override
        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, ExecutionContext ctx) {
            J i = super.visitInstanceOf(instanceOf, ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getLiteralInstanceof())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.InstanceOf)i).getClazz().getPrefix().getWhitespace().contains("\n")) {
                        i = ((J.InstanceOf)i).getPadding().withExpr(((J.InstanceOf)i).getPadding().getExpr().withAfter(((J.InstanceOf)i).getClazz().getPrefix()));
                        i = ((J.InstanceOf)i).withClazz((J)((J.InstanceOf)i).getClazz().withPrefix(((J.InstanceOf)i).getClazz().getPrefix().withWhitespace(" ")));
                    }
                } else if (((J.InstanceOf)i).getPadding().getExpr().getAfter().getWhitespace().contains("\n")) {
                    i = ((J.InstanceOf)i).withClazz((J)((J.InstanceOf)i).getClazz().withPrefix(((J.InstanceOf)i).getPadding().getExpr().getAfter()));
                    i = ((J.InstanceOf)i).getPadding().withExpr(((J.InstanceOf)i).getPadding().getExpr().withAfter(((J.InstanceOf)i).getPadding().getExpr().getAfter().withWhitespace(" ")));
                }
            }
            return i;
        }

        @Override
        public J.Ternary visitTernary(J.Ternary ternary, ExecutionContext ctx) {
            J t = super.visitTernary(ternary, ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getQuestion())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.Ternary)t).getTruePart().getPrefix().getWhitespace().contains("\n")) {
                        t = ((J.Ternary)t).getPadding().withTruePart(((J.Ternary)t).getPadding().getTruePart().withBefore(((J.Ternary)t).getPadding().getTruePart().getElement().getPrefix()));
                        t = ((J.Ternary)t).getPadding().withTruePart(((J.Ternary)t).getPadding().getTruePart().withElement((Expression)((J.Ternary)t).getPadding().getTruePart().getElement().withPrefix(((J.Ternary)t).getPadding().getTruePart().getElement().getPrefix().withWhitespace(" "))));
                    }
                } else if (((J.Ternary)t).getPadding().getTruePart().getBefore().getWhitespace().contains("\n")) {
                    t = ((J.Ternary)t).getPadding().withTruePart(((J.Ternary)t).getPadding().getTruePart().withElement((Expression)((J.Ternary)t).getPadding().getTruePart().getElement().withPrefix(((J.Ternary)t).getPadding().getTruePart().getBefore())));
                    t = ((J.Ternary)t).getPadding().withTruePart(((J.Ternary)t).getPadding().getTruePart().withBefore(((J.Ternary)t).getPadding().getTruePart().getElement().getPrefix().withWhitespace(" ")));
                }
            }
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getColon())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.Ternary)t).getPadding().getFalsePart().getElement().getPrefix().getWhitespace().contains("\n")) {
                        t = ((J.Ternary)t).getPadding().withFalsePart(((J.Ternary)t).getPadding().getFalsePart().withBefore(((J.Ternary)t).getPadding().getFalsePart().getElement().getPrefix()));
                        t = ((J.Ternary)t).getPadding().withFalsePart(((J.Ternary)t).getPadding().getFalsePart().withElement((Expression)((J.Ternary)t).getPadding().getFalsePart().getElement().withPrefix(((J.Ternary)t).getPadding().getFalsePart().getElement().getPrefix().withWhitespace(" "))));
                    }
                } else if (((J.Ternary)t).getPadding().getFalsePart().getBefore().getWhitespace().contains("\n")) {
                    t = ((J.Ternary)t).getPadding().withFalsePart(((J.Ternary)t).getPadding().getFalsePart().withElement((Expression)((J.Ternary)t).getPadding().getFalsePart().getElement().withPrefix(((J.Ternary)t).getPadding().getFalsePart().getBefore())));
                    t = ((J.Ternary)t).getPadding().withFalsePart(((J.Ternary)t).getPadding().getFalsePart().withBefore(((J.Ternary)t).getPadding().getFalsePart().getElement().getPrefix().withWhitespace(" ")));
                }
            }
            return t;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
            J m = super.visitMemberReference(memberRef, ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getMethodRef())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.MemberReference)m).getPadding().getReference().getBefore().getWhitespace().contains("\n")) {
                        m = ((J.MemberReference)m).getPadding().withContaining(((J.MemberReference)m).getPadding().getContaining().withAfter(((J.MemberReference)m).getPadding().getReference().getBefore()));
                        m = ((J.MemberReference)m).getPadding().withReference(((J.MemberReference)m).getPadding().getReference().withBefore(((J.MemberReference)m).getPadding().getReference().getBefore().withWhitespace("")));
                    }
                } else if (((J.MemberReference)m).getPadding().getContaining().getAfter().getWhitespace().contains("\n")) {
                    m = ((J.MemberReference)m).getPadding().withReference(((J.MemberReference)m).getPadding().getReference().withBefore(((J.MemberReference)m).getPadding().getContaining().getAfter()));
                    m = ((J.MemberReference)m).getPadding().withContaining(((J.MemberReference)m).getPadding().getContaining().withAfter(((J.MemberReference)m).getPadding().getReference().getBefore().withWhitespace("")));
                }
            }
            return m;
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J a = super.visitAssignment(assignment, ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getAssign())) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.Assignment)a).getPadding().getAssignment().getElement().getPrefix().getWhitespace().contains("\n")) {
                        a = ((J.Assignment)a).getPadding().withAssignment(((J.Assignment)a).getPadding().getAssignment().withBefore(((J.Assignment)a).getPadding().getAssignment().getElement().getPrefix()));
                        a = ((J.Assignment)a).getPadding().withAssignment(((J.Assignment)a).getPadding().getAssignment().withElement((Expression)((J.Assignment)a).getPadding().getAssignment().getElement().withPrefix(((J.Assignment)a).getPadding().getAssignment().getElement().getPrefix().withWhitespace(" "))));
                    }
                } else if (((J.Assignment)a).getPadding().getAssignment().getBefore().getWhitespace().contains("\n")) {
                    a = ((J.Assignment)a).getPadding().withAssignment(((J.Assignment)a).getPadding().getAssignment().withElement((Expression)((J.Assignment)a).getPadding().getAssignment().getElement().withPrefix(((J.Assignment)a).getPadding().getAssignment().getBefore())));
                    a = ((J.Assignment)a).getPadding().withAssignment(((J.Assignment)a).getPadding().getAssignment().withBefore(((J.Assignment)a).getPadding().getAssignment().getBefore().withWhitespace(" ")));
                }
            }
            return a;
        }

        @Override
        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, ExecutionContext ctx) {
            J a = super.visitAssignmentOperation(assignOp, ctx);
            J.AssignmentOperation.Type op = ((J.AssignmentOperation)a).getOperator();
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getPlusAssign()) && op == J.AssignmentOperation.Type.Addition || Boolean.TRUE.equals(this.operatorWrapStyle.getMinusAssign()) && op == J.AssignmentOperation.Type.Subtraction || Boolean.TRUE.equals(this.operatorWrapStyle.getStarAssign()) && op == J.AssignmentOperation.Type.Multiplication || Boolean.TRUE.equals(this.operatorWrapStyle.getDivAssign()) && op == J.AssignmentOperation.Type.Division || Boolean.TRUE.equals(this.operatorWrapStyle.getModAssign()) && op == J.AssignmentOperation.Type.Modulo || Boolean.TRUE.equals(this.operatorWrapStyle.getSrAssign()) && op == J.AssignmentOperation.Type.RightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getSlAssign()) && op == J.AssignmentOperation.Type.LeftShift || Boolean.TRUE.equals(this.operatorWrapStyle.getBsrAssign()) && op == J.AssignmentOperation.Type.UnsignedRightShift || Boolean.TRUE.equals(this.operatorWrapStyle.getBandAssign()) && op == J.AssignmentOperation.Type.BitAnd || Boolean.TRUE.equals(this.operatorWrapStyle.getBxorAssign()) && op == J.AssignmentOperation.Type.BitXor || Boolean.TRUE.equals(this.operatorWrapStyle.getBorAssign()) && op == J.AssignmentOperation.Type.BitOr) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.AssignmentOperation)a).getAssignment().getPrefix().getWhitespace().contains("\n")) {
                        a = ((J.AssignmentOperation)a).getPadding().withOperator(((J.AssignmentOperation)a).getPadding().getOperator().withBefore(((J.AssignmentOperation)a).getAssignment().getPrefix()));
                        a = ((J.AssignmentOperation)a).withAssignment((Expression)((J.AssignmentOperation)a).getAssignment().withPrefix(((J.AssignmentOperation)a).getAssignment().getPrefix().withWhitespace(" ")));
                    }
                } else if (((J.AssignmentOperation)a).getPadding().getOperator().getBefore().getWhitespace().contains("\n")) {
                    a = ((J.AssignmentOperation)a).withAssignment((Expression)((J.AssignmentOperation)a).getAssignment().withPrefix(((J.AssignmentOperation)a).getPadding().getOperator().getBefore()));
                    a = ((J.AssignmentOperation)a).getPadding().withOperator(((J.AssignmentOperation)a).getPadding().getOperator().withBefore(((J.AssignmentOperation)a).getAssignment().getPrefix().withWhitespace(" ")));
                }
            }
            return a;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J v = super.visitVariable(variable, ctx);
            if (Boolean.TRUE.equals(this.operatorWrapStyle.getAssign()) && ((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer() != null) {
                if (OperatorWrapStyle.WrapOption.NL.equals((Object)this.operatorWrapStyle.getWrapOption())) {
                    if (((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement().getPrefix().getWhitespace().contains("\n") && ((J.VariableDeclarations.NamedVariable)(v = ((J.VariableDeclarations.NamedVariable)v).getPadding().withInitializer(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().withBefore(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement().getPrefix())))).getPadding().getInitializer() != null && ((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement() != null) {
                        v = ((J.VariableDeclarations.NamedVariable)v).getPadding().withInitializer(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().withElement((Expression)((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement().withPrefix(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement().getPrefix().withWhitespace(" "))));
                    }
                } else if (((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getBefore().getWhitespace().contains("\n") && ((J.VariableDeclarations.NamedVariable)(v = ((J.VariableDeclarations.NamedVariable)v).getPadding().withInitializer(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().withElement((Expression)((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement().withPrefix(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getBefore()))))).getPadding().getInitializer() != null && ((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getBefore() != null) {
                    v = ((J.VariableDeclarations.NamedVariable)v).getPadding().withInitializer(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().withBefore(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement().getPrefix().withWhitespace(" ")));
                }
            }
            return v;
        }
    }
}

