/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class JavaVisitor<P>
extends TreeVisitor<J, P> {
    public String getLanguage() {
        return "java";
    }

    @Incubating(since="7.0.0")
    public JavaTemplate.Builder template(String code) {
        return JavaTemplate.builder(() -> ((JavaVisitor)this).getCursor(), code);
    }

    public void maybeAddImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeAddImport(clazz.getFullyQualifiedName());
        }
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, P p) {
        return this.maybeAutoFormat(before, after, p, this.getCursor());
    }

    public <J2 extends J> J2 maybeAutoFormat(J2 before, J2 after, P p, Cursor cursor) {
        if (before != after) {
            return (J2)new AutoFormatVisitor().visit((Tree)after, (Object)p, cursor);
        }
        return after;
    }

    public <J2 extends J> J2 autoFormat(J2 j, P p) {
        return this.autoFormat(j, p, this.getCursor());
    }

    public <J2 extends J> J2 autoFormat(J2 j, P p, Cursor cursor) {
        return (J2)new AutoFormatVisitor().visit((Tree)j, (Object)p, cursor);
    }

    public void maybeAddImport(String fullyQualifiedName) {
        AddImport op = new AddImport(fullyQualifiedName, null, true);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeAddImport(String fullyQualifiedName, String statik) {
        AddImport op = new AddImport(fullyQualifiedName, statik, true);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeRemoveImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeRemoveImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeRemoveImport(String fullyQualifiedName) {
        RemoveImport op = new RemoveImport(fullyQualifiedName);
        if (!this.getAfterVisit().contains((Object)op)) {
            this.doAfterVisit(op);
        }
    }

    public J visitExpression(Expression expression, P p) {
        return expression;
    }

    public J visitStatement(Statement statement, P p) {
        return statement;
    }

    public Space visitSpace(Space space, Space.Location loc, P p) {
        return space;
    }

    public <N extends NameTree> N visitTypeName(N nameTree, P p) {
        return nameTree;
    }

    @Nullable
    private <N extends NameTree> JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement(this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    @Nullable
    private <N extends NameTree> JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement(this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    @Nullable
    private <J2 extends J> JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map(nameTrees.getPadding().getElements(), t -> t.getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build(nameTrees.getBefore(), js, Markers.EMPTY);
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, p));
        a = (J.AnnotatedType)this.visitAndCast(a, p, this::visitExpression);
        a = a.withAnnotations(ListUtils.map(a.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)));
        a = a.withTypeExpression((TypeTree)this.visitAndCast(a.getTypeExpression(), p));
        a = a.withTypeExpression(this.visitTypeName(a.getTypeExpression(), p));
        return a;
    }

    public J visitAnnotation(J.Annotation annotation, P p) {
        J.Annotation a = annotation;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATION_PREFIX, p));
        if ((a = (J.Annotation)this.visitAndCast(a, p, this::visitExpression)).getPadding().getArguments() != null) {
            a = a.getPadding().withArguments(this.visitContainer(a.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, p));
        }
        a = a.withAnnotationType((NameTree)this.visitAndCast(a.getAnnotationType(), p));
        a = a.withAnnotationType(this.visitTypeName(a.getAnnotationType(), p));
        return a;
    }

    public J visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J.ArrayAccess a = arrayAccess;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_ACCESS_PREFIX, p));
        a = (J.ArrayAccess)this.visitAndCast(a, p, this::visitExpression);
        a = a.withIndexed((Expression)this.visitAndCast(a.getIndexed(), p));
        a = a.withDimension((J.ArrayDimension)this.visitAndCast(a.getDimension(), p));
        return a;
    }

    public J visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        J.ArrayDimension a = arrayDimension;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.DIMENSION_PREFIX, p));
        a = a.getPadding().withIndex(this.visitRightPadded(a.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, p));
        return a;
    }

    public J visitArrayType(J.ArrayType arrayType, P p) {
        J.ArrayType a = arrayType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ARRAY_TYPE_PREFIX, p));
        a = (J.ArrayType)this.visitAndCast(a, p, this::visitExpression);
        a = a.withElementType((TypeTree)this.visitAndCast(a.getElementType(), p));
        a = a.withElementType(this.visitTypeName(a.getElementType(), p));
        a = a.withDimensions(ListUtils.map(a.getDimensions(), dim -> this.visitRightPadded(dim.withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p)), JRightPadded.Location.DIMENSION, p)));
        return a;
    }

    public J visitAssert(J.Assert azzert, P p) {
        J.Assert a = azzert;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSERT_PREFIX, p));
        a = (J.Assert)this.visitAndCast(a, p, this::visitStatement);
        a = a.withCondition((Expression)this.visitAndCast(a.getCondition(), p));
        return a;
    }

    public J visitAssignment(J.Assignment assignment, P p) {
        J.Assignment a = assignment;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, p));
        a = (J.Assignment)this.visitAndCast(a, p, this::visitStatement);
        a = (J.Assignment)this.visitAndCast(a, p, this::visitExpression);
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        a = a.getPadding().withAssignment(this.visitLeftPadded(a.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, p));
        return a;
    }

    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        J.AssignmentOperation a = assignOp;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p));
        a = (J.AssignmentOperation)this.visitAndCast(a, p, this::visitStatement);
        a = (J.AssignmentOperation)this.visitAndCast(a, p, this::visitExpression);
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        a = a.getPadding().withOperator(this.visitLeftPadded(a.getPadding().getOperator(), JLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p));
        a = a.withAssignment((Expression)this.visitAndCast(a.getAssignment(), p));
        return a;
    }

    public J visitBinary(J.Binary binary, P p) {
        J.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BINARY_PREFIX, p));
        b = (J.Binary)this.visitAndCast(b, p, this::visitExpression);
        b = b.withLeft((Expression)this.visitAndCast(b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), JLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast(b.getRight(), p));
        return b;
    }

    public J visitBlock(J.Block block, P p) {
        J.Block b = block;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BLOCK_PREFIX, p));
        b = b.getPadding().withStatic(this.visitRightPadded(b.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p));
        b = (J.Block)this.visitAndCast(b, p, this::visitStatement);
        b = b.getPadding().withStatements(ListUtils.map(b.getPadding().getStatements(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.BLOCK_STATEMENT, p)));
        b = b.withEnd(this.visitSpace(b.getEnd(), Space.Location.BLOCK_END, p));
        return b;
    }

    public J visitBreak(J.Break breakStatement, P p) {
        J.Break b = breakStatement;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), Space.Location.BREAK_PREFIX, p));
        b = (J.Break)this.visitAndCast(b, p, this::visitStatement);
        b = b.withLabel((J.Identifier)this.visitAndCast(b.getLabel(), p));
        return b;
    }

    public J visitCase(J.Case caze, P p) {
        J.Case c = caze;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CASE_PREFIX, p));
        c = (J.Case)this.visitAndCast(c, p, this::visitStatement);
        c = c.withPattern((Expression)this.visitAndCast(c.getPattern(), p));
        c = c.getPadding().withStatements(this.visitContainer(c.getPadding().getStatements(), JContainer.Location.CASE, p));
        return c;
    }

    public J visitCatch(J.Try.Catch catzh, P p) {
        J.Try.Catch c = catzh;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CATCH_PREFIX, p));
        c = c.withParameter((J.ControlParentheses)this.visitAndCast(c.getParameter(), p));
        c = c.withBody((J.Block)this.visitAndCast(c.getBody(), p));
        return c;
    }

    public J visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration c = classDecl;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CLASS_DECLARATION_PREFIX, p));
        c = (J.ClassDeclaration)this.visitAndCast(c, p, this::visitStatement);
        c = c.withLeadingAnnotations(ListUtils.map(c.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p)));
        c = c.getAnnotations().withKind(classDecl.getAnnotations().getKind().withAnnotations(ListUtils.map(classDecl.getAnnotations().getKind().getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        c = c.getAnnotations().withKind(c.getAnnotations().getKind().withPrefix(this.visitSpace(c.getAnnotations().getKind().getPrefix(), Space.Location.CLASS_KIND, p)));
        if ((c = c.withName((J.Identifier)this.visitAndCast(c.getName(), p))).getPadding().getTypeParameters() != null) {
            c = c.getPadding().withTypeParameters(this.visitContainer(c.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        if (c.getPadding().getExtends() != null) {
            c = c.getPadding().withExtends(this.visitLeftPadded(c.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p));
        }
        if ((c = c.getPadding().withExtends(this.visitTypeName(c.getPadding().getExtends(), p))).getPadding().getImplements() != null) {
            c = c.getPadding().withImplements(this.visitContainer(c.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, p));
        }
        c = c.getPadding().withImplements(this.visitTypeNames(c.getPadding().getImplements(), p));
        c = c.withBody((J.Block)this.visitAndCast(c.getBody(), p));
        return c;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit c = cu;
        if ((c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p))).getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration(this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, p));
        }
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withClasses(ListUtils.map(c.getClasses(), e -> (J.ClassDeclaration)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitContinue(J.Continue continueStatement, P p) {
        J.Continue c = continueStatement;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CONTINUE_PREFIX, p));
        c = (J.Continue)this.visitAndCast(c, p, this::visitStatement);
        c = c.withLabel((J.Identifier)this.visitAndCast(c.getLabel(), p));
        return c;
    }

    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        J.ControlParentheses cp = controlParens;
        cp = cp.withPrefix(this.visitSpace(cp.getPrefix(), Space.Location.CONTROL_PARENTHESES_PREFIX, p));
        cp = (J.ControlParentheses)this.visitAndCast(cp, p, this::visitExpression);
        cp = cp.getPadding().withTree(this.visitRightPadded(cp.getPadding().getTree(), JRightPadded.Location.PARENTHESES, p));
        return cp;
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J.DoWhileLoop d = doWhileLoop;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DO_WHILE_PREFIX, p));
        d = (J.DoWhileLoop)this.visitAndCast(d, p, this::visitStatement);
        d = d.getPadding().withWhileCondition(this.visitLeftPadded(d.getPadding().getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, p));
        d = d.getPadding().withBody(this.visitRightPadded(d.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p));
        return d;
    }

    public J visitEmpty(J.Empty empty, P p) {
        J.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EMPTY_PREFIX, p));
        e = (J.Empty)this.visitAndCast(e, p, this::visitStatement);
        e = (J.Empty)this.visitAndCast(e, p, this::visitExpression);
        return e;
    }

    public J visitEnumValue(J.EnumValue enoom, P p) {
        J.EnumValue e = enoom;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_PREFIX, p));
        e = e.withName((J.Identifier)this.visitAndCast(e.getName(), p));
        e = e.withInitializer((J.NewClass)this.visitAndCast(e.getInitializer(), p));
        return e;
    }

    public J visitEnumValueSet(J.EnumValueSet enums, P p) {
        J.EnumValueSet e = enums;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ENUM_VALUE_SET_PREFIX, p));
        e = (J.EnumValueSet)this.visitAndCast(e, p, this::visitStatement);
        e = e.getPadding().withEnums(ListUtils.map(e.getPadding().getEnums(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.ENUM_VALUE, p)));
        return e;
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J.FieldAccess f = fieldAccess;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p));
        f = this.visitTypeName(f, p);
        f = (J.FieldAccess)this.visitAndCast(f, p, this::visitExpression);
        f = f.withTarget((Expression)this.visitAndCast(f.getTarget(), p));
        f = f.getPadding().withName(this.visitLeftPadded(f.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p));
        return f;
    }

    public J visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J.ForEachLoop f = forLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_EACH_LOOP_PREFIX, p));
        f = (J.ForEachLoop)this.visitAndCast(f, p, this::visitStatement);
        f = f.withControl((J.ForEachLoop.Control)this.visitAndCast(f.getControl(), p));
        f = f.getPadding().withBody(this.visitRightPadded(f.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p));
        return f;
    }

    public J visitForEachControl(J.ForEachLoop.Control control, P p) {
        J.ForEachLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p));
        c = c.getPadding().withVariable(this.visitRightPadded(c.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, p));
        c = c.getPadding().withIterable(this.visitRightPadded(c.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, p));
        return c;
    }

    public J visitForLoop(J.ForLoop forLoop, P p) {
        J.ForLoop f = forLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FOR_PREFIX, p));
        f = (J.ForLoop)this.visitAndCast(f, p, this::visitStatement);
        f = f.withControl((J.ForLoop.Control)this.visitAndCast(f.getControl(), p));
        f = f.getPadding().withBody(this.visitRightPadded(f.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p));
        return f;
    }

    public J visitForControl(J.ForLoop.Control control, P p) {
        J.ForLoop.Control c = control;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.FOR_CONTROL_PREFIX, p));
        c = c.getPadding().withInit(this.visitRightPadded(c.getPadding().getInit(), JRightPadded.Location.FOR_INIT, p));
        c = c.getPadding().withCondition(this.visitRightPadded(c.getPadding().getCondition(), JRightPadded.Location.FOR_CONDITION, p));
        c = c.getPadding().withUpdate(ListUtils.map(c.getPadding().getUpdate(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.FOR_UPDATE, p)));
        return c;
    }

    public J visitIdentifier(J.Identifier ident, P p) {
        J.Identifier i = ident;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p));
        i = (J.Identifier)this.visitAndCast(i, p, this::visitExpression);
        return i;
    }

    public J visitElse(J.If.Else elze, P p) {
        J.If.Else e = elze;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.ELSE_PREFIX, p));
        e = e.getPadding().withBody(this.visitRightPadded(e.getPadding().getBody(), JRightPadded.Location.IF_ELSE, p));
        return e;
    }

    public J visitIf(J.If iff, P p) {
        J.If i = iff;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IF_PREFIX, p));
        i = (J.If)this.visitAndCast(i, p, this::visitStatement);
        i = i.withIfCondition((J.ControlParentheses)this.visitAndCast(i.getIfCondition(), p));
        i = i.getPadding().withThenPart(this.visitRightPadded(i.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, p));
        i = i.withElsePart((J.If.Else)this.visitAndCast(i.getElsePart(), p));
        return i;
    }

    public J visitImport(J.Import impoort, P p) {
        J.Import i = impoort;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IMPORT_PREFIX, p));
        i = i.getPadding().withStatic(this.visitLeftPadded(i.getPadding().getStatic(), JLeftPadded.Location.STATIC_IMPORT, p));
        i = i.withQualid((J.FieldAccess)this.visitAndCast(i.getQualid(), p));
        return i;
    }

    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        J.InstanceOf i = instanceOf;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.INSTANCEOF_PREFIX, p));
        i = (J.InstanceOf)this.visitAndCast(i, p, this::visitExpression);
        i = i.getPadding().withExpr(this.visitRightPadded(i.getPadding().getExpr(), JRightPadded.Location.INSTANCEOF, p));
        i = i.withClazz((J)this.visitAndCast(i.getClazz(), p));
        return i;
    }

    public J visitLabel(J.Label label, P p) {
        J.Label l = label;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LABEL_PREFIX, p));
        l = (J.Label)this.visitAndCast(l, p, this::visitStatement);
        l = l.getPadding().withLabel(this.visitRightPadded(l.getPadding().getLabel(), JRightPadded.Location.LABEL, p));
        l = l.withStatement((Statement)this.visitAndCast(l.getStatement(), p));
        return l;
    }

    public J visitLambda(J.Lambda lambda, P p) {
        J.Lambda l = lambda;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LAMBDA_PREFIX, p));
        l = (J.Lambda)this.visitAndCast(l, p, this::visitExpression);
        l = l.withParameters(l.getParameters().withPrefix(this.visitSpace(l.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p)));
        l = l.withParameters(l.getParameters().getPadding().withParams(ListUtils.map(l.getParameters().getPadding().getParams(), param -> this.visitRightPadded((JRightPadded)param, JRightPadded.Location.LAMBDA_PARAM, p))));
        l = l.withParameters((J.Lambda.Parameters)this.visitAndCast(l.getParameters(), p));
        l = l.withArrow(this.visitSpace(l.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p));
        l = l.withBody((J)this.visitAndCast(l.getBody(), p));
        return l;
    }

    public J visitLiteral(J.Literal literal, P p) {
        J.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LITERAL_PREFIX, p));
        l = (J.Literal)this.visitAndCast(l, p, this::visitExpression);
        return l;
    }

    public J visitMemberReference(J.MemberReference memberRef, P p) {
        J.MemberReference m = memberRef;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, p));
        if ((m = m.withContaining((Expression)this.visitAndCast(m.getContaining(), p))).getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        m = m.getPadding().withReference(this.visitLeftPadded(m.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p));
        return m;
    }

    public J visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, p));
        m = (J.MethodDeclaration)this.visitAndCast(m, p, this::visitStatement);
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        J.TypeParameters typeParameters = (m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))))).getAnnotations().getTypeParameters();
        if (typeParameters != null) {
            m = m.getAnnotations().withTypeParameters(typeParameters.withAnnotations(ListUtils.map(typeParameters.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        }
        if ((typeParameters = m.getAnnotations().getTypeParameters()) != null) {
            m = m.getAnnotations().withTypeParameters(typeParameters.getPadding().withTypeParameters(ListUtils.map(typeParameters.getPadding().getTypeParameters(), tp -> this.visitRightPadded((JRightPadded)tp, JRightPadded.Location.TYPE_PARAMETER, p))));
        }
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast(m.getReturnTypeExpression(), p))).getReturnTypeExpression() == null ? null : this.visitTypeName(m.getReturnTypeExpression(), p));
        m = m.withName((J.Identifier)this.visitAndCast(m.getName(), p));
        if ((m = m.getPadding().withParameters(this.visitContainer(m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, p))).getPadding().getThrows() != null) {
            m = m.getPadding().withThrows(this.visitContainer(m.getPadding().getThrows(), JContainer.Location.THROWS, p));
        }
        m = m.getPadding().withThrows(this.visitTypeNames(m.getPadding().getThrows(), p));
        if ((m = m.withBody((J.Block)this.visitAndCast(m.getBody(), p))).getPadding().getDefaultValue() != null) {
            m = m.getPadding().withDefaultValue(this.visitLeftPadded(m.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p));
        }
        return m;
    }

    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, p));
        m = (J.MethodInvocation)this.visitAndCast(m, p, this::visitStatement);
        if ((m = (J.MethodInvocation)this.visitAndCast(m, p, this::visitExpression)).getPadding().getSelect() != null && m.getPadding().getSelect().getElement() instanceof NameTree && method.getType() != null && method.getType().hasFlags(Flag.Static)) {
            m = m.getPadding().withSelect(this.visitTypeName(m.getPadding().getSelect(), p));
        }
        if (m.getPadding().getSelect() != null) {
            m = m.getPadding().withSelect(this.visitRightPadded(m.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, p));
        }
        if (m.getPadding().getTypeParameters() != null) {
            m = m.getPadding().withTypeParameters(this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        m = m.getPadding().withTypeParameters(this.visitTypeNames(m.getPadding().getTypeParameters(), p));
        m = m.withName((J.Identifier)this.visitAndCast(m.getName(), p));
        m = m.getPadding().withArguments(this.visitContainer(m.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, p));
        return m;
    }

    public J visitMultiCatch(J.MultiCatch multiCatch, P p) {
        J.MultiCatch m = multiCatch;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.MULTI_CATCH_PREFIX, p));
        m = m.getPadding().withAlternatives(ListUtils.map(m.getPadding().getAlternatives(), t -> this.visitTypeName(this.visitRightPadded((JRightPadded)t, JRightPadded.Location.CATCH_ALTERNATIVE, p), p)));
        return m;
    }

    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations m = multiVariable;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.VARIABLE_DECLARATIONS_PREFIX, p));
        m = (J.VariableDeclarations)this.visitAndCast(m, p, this::visitStatement);
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        m = m.withTypeExpression((TypeTree)this.visitAndCast(m.getTypeExpression(), p));
        m = m.withTypeExpression((m = m.withDimensionsBeforeName(ListUtils.map(m.getDimensionsBeforeName(), dim -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p))))).getTypeExpression() == null ? null : this.visitTypeName(m.getTypeExpression(), p));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), Space.Location.VARARGS, p));
        m = m.getPadding().withVariables(ListUtils.map(m.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.NAMED_VARIABLE, p)));
        return m;
    }

    public J visitNewArray(J.NewArray newArray, P p) {
        J.NewArray n = newArray;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_ARRAY_PREFIX, p));
        n = (J.NewArray)this.visitAndCast(n, p, this::visitExpression);
        n = n.withTypeExpression((n = n.withTypeExpression((TypeTree)this.visitAndCast(n.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(n.getTypeExpression(), p));
        if ((n = n.withDimensions(ListUtils.map(n.getDimensions(), d -> (J.ArrayDimension)this.visitAndCast((Tree)d, p)))).getPadding().getInitializer() != null) {
            n = n.getPadding().withInitializer(this.visitContainer(n.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, p));
        }
        return n;
    }

    public J visitNewClass(J.NewClass newClass, P p) {
        J.NewClass n = newClass;
        if ((n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.NEW_CLASS_PREFIX, p))).getPadding().getEnclosing() != null) {
            n = n.getPadding().withEnclosing(this.visitRightPadded(n.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, p));
        }
        n = (J.NewClass)this.visitAndCast(n, p, this::visitStatement);
        n = (J.NewClass)this.visitAndCast(n, p, this::visitExpression);
        n = n.withNew(this.visitSpace(n.getNew(), Space.Location.NEW_PREFIX, p));
        if ((n = n.withClazz((n = n.withClazz((TypeTree)this.visitAndCast(n.getClazz(), p))).getClazz() == null ? null : this.visitTypeName(n.getClazz(), p))).getPadding().getArguments() != null) {
            n = n.getPadding().withArguments(this.visitContainer(n.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, p));
        }
        n = n.withBody((J.Block)this.visitAndCast(n.getBody(), p));
        return n;
    }

    public J visitPackage(J.Package pkg, P p) {
        J.Package pa = pkg;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.PACKAGE_PREFIX, p));
        pa = pa.withExpression((Expression)this.visitAndCast(pa.getExpression(), p));
        return pa;
    }

    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = type;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, p));
        pt = (J.ParameterizedType)this.visitAndCast(pt, p, this::visitExpression);
        pt = pt.withClazz((NameTree)this.visitAndCast(pt.getClazz(), p));
        if ((pt = pt.withClazz(this.visitTypeName(pt.getClazz(), p))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer(pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), p));
        return pt;
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        J.Parentheses pa = parens;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), Space.Location.PARENTHESES_PREFIX, p));
        pa = (J.Parentheses)this.visitAndCast(pa, p, this::visitExpression);
        pa = pa.getPadding().withTree(this.visitRightPadded(pa.getPadding().getTree(), JRightPadded.Location.PARENTHESES, p));
        return pa;
    }

    public J visitPrimitive(J.Primitive primitive, P p) {
        J.Primitive pr = primitive;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), Space.Location.PRIMITIVE_PREFIX, p));
        pr = (J.Primitive)this.visitAndCast(pr, p, this::visitExpression);
        return pr;
    }

    public J visitReturn(J.Return retrn, P p) {
        J.Return r = retrn;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.RETURN_PREFIX, p));
        r = (J.Return)this.visitAndCast(r, p, this::visitStatement);
        r = r.withExpression((Expression)this.visitAndCast(r.getExpression(), p));
        return r;
    }

    public J visitSwitch(J.Switch switzh, P p) {
        J.Switch s = switzh;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SWITCH_PREFIX, p));
        s = (J.Switch)this.visitAndCast(s, p, this::visitStatement);
        s = s.withSelector((J.ControlParentheses)this.visitAndCast(s.getSelector(), p));
        s = s.withCases((J.Block)this.visitAndCast(s.getCases(), p));
        return s;
    }

    public J visitSynchronized(J.Synchronized synch, P p) {
        J.Synchronized s = synch;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SYNCHRONIZED_PREFIX, p));
        s = (J.Synchronized)this.visitAndCast(s, p, this::visitStatement);
        s = s.withLock((J.ControlParentheses)this.visitAndCast(s.getLock(), p));
        s = s.withBody((J.Block)this.visitAndCast(s.getBody(), p));
        return s;
    }

    public J visitTernary(J.Ternary ternary, P p) {
        J.Ternary t = ternary;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TERNARY_PREFIX, p));
        t = (J.Ternary)this.visitAndCast(t, p, this::visitExpression);
        t = t.withCondition((Expression)this.visitAndCast(t.getCondition(), p));
        t = t.getPadding().withTruePart(this.visitLeftPadded(t.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p));
        t = t.getPadding().withFalsePart(this.visitLeftPadded(t.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p));
        return t;
    }

    public J visitThrow(J.Throw thrown, P p) {
        J.Throw t = thrown;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.THROW_PREFIX, p));
        t = (J.Throw)this.visitAndCast(t, p, this::visitStatement);
        t = t.withException((Expression)this.visitAndCast(t.getException(), p));
        return t;
    }

    public J visitTry(J.Try tryable, P p) {
        J.Try t = tryable;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TRY_PREFIX, p));
        if ((t = (J.Try)this.visitAndCast(t, p, this::visitStatement)).getPadding().getResources() != null) {
            t = t.getPadding().withResources(this.visitContainer(t.getPadding().getResources().getPadding().withElements(ListUtils.map(t.getPadding().getResources().getPadding().getElements(), res -> res.withElement(((J.Try.Resource)res.getElement()).withPrefix(this.visitSpace(((J.Try.Resource)res.getElement()).getPrefix(), Space.Location.TRY_RESOURCE, p))))), JContainer.Location.TRY_RESOURCES, p));
        }
        t = t.withBody((J.Block)this.visitAndCast(t.getBody(), p));
        if ((t = t.withCatches(ListUtils.map(t.getCatches(), c -> (J.Try.Catch)this.visitAndCast((Tree)c, p)))).getPadding().getFinally() != null) {
            t = t.getPadding().withFinally(this.visitLeftPadded(t.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, p));
        }
        return t;
    }

    public J visitTypeCast(J.TypeCast typeCast, P p) {
        J.TypeCast t = typeCast;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_CAST_PREFIX, p));
        t = (J.TypeCast)this.visitAndCast(t, p, this::visitExpression);
        t = t.withClazz((J.ControlParentheses)this.visitAndCast(t.getClazz(), p));
        t = t.withClazz(t.getClazz().withTree(this.visitTypeName(t.getClazz().getTree(), p)));
        t = t.withExpression((Expression)this.visitAndCast(t.getExpression(), p));
        return t;
    }

    public J visitTypeParameter(J.TypeParameter typeParam, P p) {
        J.TypeParameter t = typeParam;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, p));
        t = t.withAnnotations(ListUtils.map(t.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        if ((t = t.withName((Expression)this.visitAndCast(t.getName(), p))).getName() instanceof NameTree) {
            t = t.withName((Expression)((Object)this.visitTypeName((NameTree)((Object)t.getName()), p)));
        }
        if (t.getPadding().getBounds() != null) {
            t = t.getPadding().withBounds(this.visitContainer(t.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, p));
        }
        t = t.getPadding().withBounds(this.visitTypeNames(t.getPadding().getBounds(), p));
        return t;
    }

    public J visitUnary(J.Unary unary, P p) {
        J.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY_PREFIX, p));
        u = (J.Unary)this.visitAndCast(u, p, this::visitStatement);
        u = (J.Unary)this.visitAndCast(u, p, this::visitExpression);
        u = u.getPadding().withOperator(this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p));
        u = u.withExpression((Expression)this.visitAndCast(u.getExpression(), p));
        return u;
    }

    public J visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = variable;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), Space.Location.VARIABLE_PREFIX, p));
        v = v.withName((J.Identifier)this.visitAndCast(v.getName(), p));
        if ((v = v.withDimensionsAfterName(ListUtils.map(v.getDimensionsAfterName(), dim -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement(this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p))))).getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(v.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p));
        }
        return v;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J.WhileLoop w = whileLoop;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WHILE_PREFIX, p));
        w = (J.WhileLoop)this.visitAndCast(w, p, this::visitStatement);
        w = w.withCondition((J.ControlParentheses)this.visitAndCast(w.getCondition(), p));
        w = w.getPadding().withBody(this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p));
        return w;
    }

    public J visitWildcard(J.Wildcard wildcard, P p) {
        J.Wildcard w = wildcard;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WILDCARD_PREFIX, p));
        if ((w = (J.Wildcard)this.visitAndCast(w, p, this::visitExpression)).getPadding().getBound() != null) {
            w = w.getPadding().withBound(w.getPadding().getBound().withBefore(this.visitSpace(w.getPadding().getBound().getBefore(), Space.Location.WILDCARD_BOUND, p)));
        }
        if ((w = w.withBoundedType((NameTree)this.visitAndCast(w.getBoundedType(), p))).getBoundedType() != null) {
            w = w.withBoundedType(this.visitTypeName(w.getBoundedType(), p));
        }
        return w;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((J)right.getElement(), p);
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && t == right.getElement() ? right : new JRightPadded<T>(t, after, right.getMarkers());
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, JLeftPadded.Location loc, P p) {
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((J)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        return before == left.getBefore() && t == left.getElement() ? left : new JLeftPadded<T>(before, t, left.getMarkers());
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    protected boolean isInSameNameScope(Cursor base, Cursor child) {
        Tree baseScope = (Tree)base.dropParentUntil(t -> t instanceof J.Block || t instanceof J.MethodDeclaration || t instanceof J.Try || t instanceof J.ForLoop || t instanceof J.ForEachLoop).getValue();
        Iterator it = child.getPath();
        while (it.hasNext()) {
            J.ClassDeclaration childClass;
            Object childScope = it.next();
            if (childScope instanceof J.ClassDeclaration && (!(childClass = (J.ClassDeclaration)childScope).getKind().equals((Object)J.ClassDeclaration.Kind.Type.Class) || childClass.hasModifier(J.Modifier.Type.Static))) {
                return false;
            }
            if (!(childScope instanceof Tree) || !baseScope.isScope((Tree)childScope)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInSameNameScope(Cursor child) {
        return this.isInSameNameScope(this.getCursor(), child);
    }
}

