/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class Comment {
    private final Style style;
    private final String text;
    private final String suffix;

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Comment;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public Comment(Style style, String text, String suffix) {
        this.style = style;
        this.text = text;
        this.suffix = suffix;
    }

    public Style getStyle() {
        return this.style;
    }

    public String getText() {
        return this.text;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @NonNull
    public String toString() {
        return "Comment(style=" + (Object)((Object)this.getStyle()) + ", text=" + this.getText() + ", suffix=" + this.getSuffix() + ")";
    }

    @NonNull
    public Comment withStyle(Style style) {
        return this.style == style ? this : new Comment(style, this.text, this.suffix);
    }

    @NonNull
    public Comment withText(String text) {
        return this.text == text ? this : new Comment(this.style, text, this.suffix);
    }

    @NonNull
    public Comment withSuffix(String suffix) {
        return this.suffix == suffix ? this : new Comment(this.style, this.text, suffix);
    }

    public static enum Style {
        LINE,
        BLOCK,
        JAVADOC;

    }
}

