/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.stream.Collectors;
import org.openrewrite.TreePrinter;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class VariableDeclarationsToString {
    private static final JavaPrinter<Void> VARIABLE_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, Void unused) {
            this.visitModifiers(Space.formatFirstPrefix(multiVariable.getModifiers(), Space.EMPTY), unused);
            StringBuilder acc = this.getPrinter();
            if (!multiVariable.getModifiers().isEmpty()) {
                acc.append(' ');
            }
            if (multiVariable.getTypeExpression() != null) {
                acc.append(multiVariable.getTypeExpression().printTrimmed()).append(' ');
            }
            acc.append(multiVariable.getDimensionsBeforeName().stream().map(d -> "[]").collect(Collectors.joining("")));
            if (multiVariable.getVarargs() != null) {
                acc.append("...");
            }
            acc.append(multiVariable.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getSimpleName).collect(Collectors.joining(", ")));
            return multiVariable;
        }
    };

    public static String toString(J.VariableDeclarations v) {
        return VARIABLE_PRINTER.print(v, null);
    }
}

