/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;

public class FindFields
extends Recipe {
    private final String fullyQualifiedTypeName;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (multiVariable.getTypeExpression() instanceof J.MultiCatch) {
                    return multiVariable;
                }
                if (multiVariable.getTypeExpression() != null && TypeUtils.hasElementType(multiVariable.getTypeExpression().getType(), FindFields.this.fullyQualifiedTypeName)) {
                    return (J.VariableDeclarations)multiVariable.withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindFields.this)});
                }
                return multiVariable;
            }
        };
    }

    public static Set<J.VariableDeclarations> find(J j, final String fullyQualifiedTypeName) {
        JavaIsoVisitor<Set<J.VariableDeclarations>> findVisitor = new JavaIsoVisitor<Set<J.VariableDeclarations>>(){

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Set<J.VariableDeclarations> vs) {
                if (multiVariable.getTypeExpression() instanceof J.MultiCatch) {
                    return multiVariable;
                }
                if (multiVariable.getTypeExpression() != null && TypeUtils.hasElementType(multiVariable.getTypeExpression().getType(), fullyQualifiedTypeName)) {
                    vs.add(multiVariable);
                }
                return multiVariable;
            }
        };
        HashSet<J.VariableDeclarations> vs = new HashSet<J.VariableDeclarations>();
        findVisitor.visit(j, vs);
        return vs;
    }

    public FindFields(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @NonNull
    public String toString() {
        return "FindFields(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFields)) {
            return false;
        }
        FindFields other = (FindFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindFields;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }
}

