/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Incubating(since="7.0.0")
public class HideUtilityClassConstructorVisitor<P>
extends JavaIsoVisitor<P> {
    private final HideUtilityClassConstructorStyle style;

    public HideUtilityClassConstructorVisitor(HideUtilityClassConstructorStyle style) {
        this.style = style;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        if (UtilityClassUtilities.isRefactorableUtilityClass((J.ClassDeclaration)c, this.style)) {
            c = this.maybeAutoFormat(c, (J.ClassDeclaration)new UtilityClassWithImplicitDefaultConstructorVisitor().visit(c, p, this.getCursor()), p);
            c = this.maybeAutoFormat(c, (J.ClassDeclaration)new UtilityClassWithExposedConstructorInspectionVisitor().visit(c, p, this.getCursor()), p);
        }
        return c;
    }

    private static final class UtilityClassUtilities {
        private UtilityClassUtilities() {
        }

        static boolean hasIgnorableAnnotation(J.ClassDeclaration c, Collection<String> ignorableAnnotations) {
            return c.getAnnotations().stream().anyMatch(classAnn -> ignorableAnnotations.stream().anyMatch(ignorableAnn -> new AnnotationMatcher((String)ignorableAnn).matches((J.Annotation)classAnn)));
        }

        static boolean hasMainMethod(J.ClassDeclaration c) {
            return c.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(md -> !md.isConstructor()).filter(md -> md.hasModifier(J.Modifier.Type.Public)).filter(md -> md.hasModifier(J.Modifier.Type.Static)).filter(md -> md.getReturnTypeExpression() != null).filter(md -> JavaType.Primitive.Void.equals(md.getReturnTypeExpression().getType())).anyMatch(md -> new MethodMatcher("* main(String)").matches((J.MethodDeclaration)md, c));
        }

        static boolean hasImplicitDefaultConstructor(J.ClassDeclaration c) {
            return c.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).noneMatch(J.MethodDeclaration::isConstructor);
        }

        static boolean isRefactorableUtilityClass(J.ClassDeclaration c, HideUtilityClassConstructorStyle style) {
            return UtilityClassUtilities.isUtilityClass(c) && !UtilityClassUtilities.hasIgnorableAnnotation(c, style.getIgnoreIfAnnotatedBy()) && !UtilityClassUtilities.hasMainMethod(c);
        }

        static boolean isUtilityClass(J.ClassDeclaration c) {
            if (c.getImplements() != null || c.getExtends() != null) {
                return false;
            }
            List<J.MethodDeclaration> methods = c.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).collect(Collectors.toList());
            int staticMethodCount = UtilityClassUtilities.countStaticMethods(methods);
            if (staticMethodCount < 0) {
                return false;
            }
            List<J.VariableDeclarations> fields = c.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).collect(Collectors.toList());
            int staticFieldCount = UtilityClassUtilities.countStaticFields(fields);
            if (staticFieldCount < 0) {
                return false;
            }
            return staticMethodCount != 0 || staticFieldCount != 0;
        }

        private static int countStaticFields(Collection<J.VariableDeclarations> fields) {
            int count = 0;
            for (J.VariableDeclarations field : fields) {
                if (!field.hasModifier(J.Modifier.Type.Static)) {
                    return -1;
                }
                if (field.hasModifier(J.Modifier.Type.Private)) continue;
                ++count;
            }
            return count;
        }

        private static int countStaticMethods(Collection<J.MethodDeclaration> methods) {
            int count = 0;
            for (J.MethodDeclaration method : methods) {
                if (method.isConstructor()) continue;
                if (!method.hasModifier(J.Modifier.Type.Static)) {
                    return -1;
                }
                if (method.hasModifier(J.Modifier.Type.Private)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class UtilityClassWithExposedConstructorInspectionVisitor<P>
    extends JavaIsoVisitor<P> {
        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
            J md = super.visitMethodDeclaration(method, (Object)p);
            if (((J.MethodDeclaration)md).isConstructor() && !((J.MethodDeclaration)md).hasModifier(J.Modifier.Type.Private) && !((J.MethodDeclaration)md).hasModifier(J.Modifier.Type.Protected) && !((J.MethodDeclaration)(md = ((J.MethodDeclaration)md).withModifiers(ListUtils.map(((J.MethodDeclaration)md).getModifiers(), mod -> mod.getType() == J.Modifier.Type.Public ? mod.withType(J.Modifier.Type.Private) : mod)))).hasModifier(J.Modifier.Type.Private)) {
                J.Modifier mod2 = new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private);
                md = ((J.MethodDeclaration)md).withModifiers(ListUtils.concat(((J.MethodDeclaration)md).getModifiers(), (Object)mod2));
            }
            return md;
        }
    }

    private static class UtilityClassWithImplicitDefaultConstructorVisitor<P>
    extends JavaIsoVisitor<P> {
        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            J c = super.visitClassDeclaration(classDecl, (Object)p);
            if (UtilityClassUtilities.hasImplicitDefaultConstructor((J.ClassDeclaration)c)) {
                c = (J.ClassDeclaration)c.withTemplate(this.template("private #{}() {}").build(), ((J.ClassDeclaration)c).getBody().getCoordinates().lastStatement(), classDecl.getSimpleName());
            }
            return c;
        }
    }
}

