/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import org.openrewrite.java.JavaStyle;

public class TabsAndIndentsStyle
implements JavaStyle {
    private final boolean useTabCharacter;
    private final int tabSize;
    private final int indentSize;
    private final int continuationIndent;
    private final boolean indentsRelativeToExpressionStart;

    public TabsAndIndentsStyle(boolean useTabCharacter, int tabSize, int indentSize, int continuationIndent, boolean indentsRelativeToExpressionStart) {
        this.useTabCharacter = useTabCharacter;
        this.tabSize = tabSize;
        this.indentSize = indentSize;
        this.continuationIndent = continuationIndent;
        this.indentsRelativeToExpressionStart = indentsRelativeToExpressionStart;
    }

    public boolean isUseTabCharacter() {
        return this.useTabCharacter;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public int getContinuationIndent() {
        return this.continuationIndent;
    }

    public boolean isIndentsRelativeToExpressionStart() {
        return this.indentsRelativeToExpressionStart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabsAndIndentsStyle)) {
            return false;
        }
        TabsAndIndentsStyle other = (TabsAndIndentsStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseTabCharacter() != other.isUseTabCharacter()) {
            return false;
        }
        if (this.getTabSize() != other.getTabSize()) {
            return false;
        }
        if (this.getIndentSize() != other.getIndentSize()) {
            return false;
        }
        if (this.getContinuationIndent() != other.getContinuationIndent()) {
            return false;
        }
        return this.isIndentsRelativeToExpressionStart() == other.isIndentsRelativeToExpressionStart();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TabsAndIndentsStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTabCharacter() ? 79 : 97);
        result = result * 59 + this.getTabSize();
        result = result * 59 + this.getIndentSize();
        result = result * 59 + this.getContinuationIndent();
        result = result * 59 + (this.isIndentsRelativeToExpressionStart() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TabsAndIndentsStyle(useTabCharacter=" + this.isUseTabCharacter() + ", tabSize=" + this.getTabSize() + ", indentSize=" + this.getIndentSize() + ", continuationIndent=" + this.getContinuationIndent() + ", indentsRelativeToExpressionStart=" + this.isIndentsRelativeToExpressionStart() + ")";
    }

    public TabsAndIndentsStyle withUseTabCharacter(boolean useTabCharacter) {
        return this.useTabCharacter == useTabCharacter ? this : new TabsAndIndentsStyle(useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart);
    }

    public TabsAndIndentsStyle withTabSize(int tabSize) {
        return this.tabSize == tabSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, tabSize, this.indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart);
    }

    public TabsAndIndentsStyle withIndentSize(int indentSize) {
        return this.indentSize == indentSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, indentSize, this.continuationIndent, this.indentsRelativeToExpressionStart);
    }

    public TabsAndIndentsStyle withContinuationIndent(int continuationIndent) {
        return this.continuationIndent == continuationIndent ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, continuationIndent, this.indentsRelativeToExpressionStart);
    }

    public TabsAndIndentsStyle withIndentsRelativeToExpressionStart(boolean indentsRelativeToExpressionStart) {
        return this.indentsRelativeToExpressionStart == indentsRelativeToExpressionStart ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, indentsRelativeToExpressionStart);
    }
}

