/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;

public final class FindMethods
extends Recipe {
    private final String methodPattern;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (methodMatcher.matches(method)) {
                    m = (J.MethodInvocation)m.withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindMethods.this)});
                }
                return m;
            }
        };
    }

    public static Set<J.MethodInvocation> find(J j, String methodPattern) {
        final MethodMatcher methodMatcher = new MethodMatcher(methodPattern);
        JavaIsoVisitor<Set<J.MethodInvocation>> findVisitor = new JavaIsoVisitor<Set<J.MethodInvocation>>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<J.MethodInvocation> ms) {
                if (methodMatcher.matches(method)) {
                    ms.add(method);
                }
                return super.visitMethodInvocation(method, ms);
            }
        };
        HashSet<J.MethodInvocation> ms = new HashSet<J.MethodInvocation>();
        findVisitor.visit(j, ms);
        return ms;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMethods)) {
            return false;
        }
        FindMethods other = (FindMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    public FindMethods(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String toString() {
        return "FindMethods(methodPattern=" + this.getMethodPattern() + ")";
    }
}

