/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class WrappingAndBracesVisitor<P>
extends JavaIsoVisitor<P> {
    private final WrappingAndBracesStyle style;

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style) {
        this.style = style;
        this.setCursoringOn();
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        J parentTree = (J)this.getCursor().dropParentUntil(J.class::isInstance).getValue();
        if (parentTree instanceof J.Block && !j.getPrefix().getWhitespace().contains("\n")) {
            j = (Statement)j.withPrefix(this.withNewline(j.getPrefix()));
        }
        return j;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        if (!((J.MethodDeclaration)(m = ((J.MethodDeclaration)m).withAnnotations(this.withNewlines(((J.MethodDeclaration)m).getAnnotations())))).getAnnotations().isEmpty()) {
            if (!((J.MethodDeclaration)m).getModifiers().isEmpty()) {
                m = ((J.MethodDeclaration)m).withModifiers(this.withNewline(((J.MethodDeclaration)m).getModifiers()));
            } else if (((J.MethodDeclaration)m).getPadding().getTypeParameters() != null) {
                if (!((J.MethodDeclaration)m).getPadding().getTypeParameters().getBefore().getWhitespace().contains("\n")) {
                    m = ((J.MethodDeclaration)m).getPadding().withTypeParameters(((J.MethodDeclaration)m).getPadding().getTypeParameters().withBefore(this.withNewline(((J.MethodDeclaration)m).getPadding().getTypeParameters().getBefore())));
                }
            } else if (((J.MethodDeclaration)m).getReturnTypeExpression() != null) {
                if (!((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().getWhitespace().contains("\n")) {
                    m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((J.MethodDeclaration)m).getReturnTypeExpression().withPrefix(this.withNewline(((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix())));
                }
            } else if (!((J.MethodDeclaration)m).getName().getPrefix().getWhitespace().contains("\n")) {
                m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(this.withNewline(((J.MethodDeclaration)m).getName().getPrefix())));
            }
        }
        return m;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J j = super.visitClassDeclaration(classDecl, (Object)p);
        if (!((J.ClassDeclaration)(j = ((J.ClassDeclaration)j).withAnnotations(this.withNewlines(((J.ClassDeclaration)j).getAnnotations())))).getAnnotations().isEmpty()) {
            if (!((J.ClassDeclaration)j).getModifiers().isEmpty()) {
                j = ((J.ClassDeclaration)j).withModifiers(this.withNewline(((J.ClassDeclaration)j).getModifiers()));
            } else {
                J.ClassDeclaration.Padding padding = ((J.ClassDeclaration)j).getPadding();
                JLeftPadded<J.ClassDeclaration.Kind> kind = padding.getKind();
                j = padding.withKind(kind.withBefore(kind.getBefore().withWhitespace("\n" + kind.getBefore().getWhitespace())));
            }
        }
        return j;
    }

    private List<J.Annotation> withNewlines(List<J.Annotation> annotations) {
        if (annotations.isEmpty()) {
            return annotations;
        }
        return ListUtils.map(annotations, (index, a) -> {
            if (index != 0 && !a.getPrefix().getWhitespace().contains("\n")) {
                a = a.withPrefix(this.withNewline(a.getPrefix()));
            }
            return a;
        });
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        if (!((J.Block)b).getEnd().getWhitespace().contains("\n")) {
            b = ((J.Block)b).withEnd(this.withNewline(((J.Block)b).getEnd()));
        }
        return b;
    }

    private Space withNewline(Space space) {
        return space.withWhitespace("\n" + space.getWhitespace());
    }

    private List<J.Modifier> withNewline(List<J.Modifier> modifiers) {
        J.Modifier firstModifier = modifiers.iterator().next();
        if (!firstModifier.getPrefix().getWhitespace().contains("\n")) {
            return ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(this.withNewline(mod.getPrefix())));
        }
        return modifiers;
    }
}

