/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.internal.ClassDeclToString;
import org.openrewrite.java.internal.ImportToString;
import org.openrewrite.java.internal.JavaListMarkersVisitor;
import org.openrewrite.java.internal.JavaPrinter;
import org.openrewrite.java.internal.MethodDeclToString;
import org.openrewrite.java.internal.VariableDeclsToString;
import org.openrewrite.java.search.FindType;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface J
extends Serializable,
Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)(v instanceof JavaVisitor ? this.acceptJava((JavaVisitor)v, p) : v.defaultValue(null, p));
    }

    @Nullable
    default public <P> J acceptJava(JavaVisitor<P> v, P p) {
        return (J)v.defaultValue(this, p);
    }

    default public <P> String print(TreePrinter<P> printer, P p) {
        return new JavaPrinter<P>(printer).print(this, p);
    }

    default public <P> String print(P p) {
        return this.print(TreePrinter.identity(), p);
    }

    public <J2 extends J> J2 withPrefix(Space var1);

    public Space getPrefix();

    @JsonIgnore
    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    default public <J2 extends J> J2 withComments(List<Comment> comments) {
        return this.withPrefix(this.getPrefix().withComments(comments));
    }

    default public <J2 extends J> Set<J2> findMarkedWith(Class<? extends Marker> markerType) {
        HashSet trees = new HashSet();
        new JavaListMarkersVisitor(markerType).visit(this, trees);
        return trees;
    }

    public static final class Wildcard
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JLeftPadded<Bound> bound;
        @Nullable
        private final NameTree boundedType;

        @Override
        public JavaType getType() {
            return null;
        }

        public Wildcard withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWildcard(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wildcard)) {
                return false;
            }
            Wildcard other = (Wildcard)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "bound", "boundedType"})
        public Wildcard(UUID id, Space prefix, Markers markers, JLeftPadded<Bound> bound, NameTree boundedType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JLeftPadded<Bound> getBound() {
            return this.bound;
        }

        public NameTree getBoundedType() {
            return this.boundedType;
        }

        public String toString() {
            return "J.Wildcard(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", bound=" + this.getBound() + ", boundedType=" + this.getBoundedType() + ")";
        }

        public Wildcard withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Wildcard(this.id, prefix, this.markers, this.bound, this.boundedType);
        }

        public Wildcard withMarkers(Markers markers) {
            return this.markers == markers ? this : new Wildcard(this.id, this.prefix, markers, this.bound, this.boundedType);
        }

        public Wildcard withBound(JLeftPadded<Bound> bound) {
            return this.bound == bound ? this : new Wildcard(this.id, this.prefix, this.markers, bound, this.boundedType);
        }

        public Wildcard withBoundedType(NameTree boundedType) {
            return this.boundedType == boundedType ? this : new Wildcard(this.id, this.prefix, this.markers, this.bound, boundedType);
        }

        public static enum Bound {
            Extends,
            Super;

        }
    }

    public static final class WhileLoop
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> condition;
        private final JRightPadded<Statement> body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWhileLoop(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhileLoop)) {
                return false;
            }
            WhileLoop other = (WhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "condition", "body"})
        public WhileLoop(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getCondition() {
            return this.condition;
        }

        public JRightPadded<Statement> getBody() {
            return this.body;
        }

        public String toString() {
            return "J.WhileLoop(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ", body=" + this.getBody() + ")";
        }

        public WhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WhileLoop(this.id, prefix, this.markers, this.condition, this.body);
        }

        public WhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhileLoop(this.id, this.prefix, markers, this.condition, this.body);
        }

        public WhileLoop withCondition(ControlParentheses<Expression> condition) {
            return this.condition == condition ? this : new WhileLoop(this.id, this.prefix, this.markers, condition, this.body);
        }

        public WhileLoop withBody(JRightPadded<Statement> body) {
            return this.body == body ? this : new WhileLoop(this.id, this.prefix, this.markers, this.condition, body);
        }
    }

    public static final class VariableDecls
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeTree typeExpr;
        @Nullable
        private final Space varargs;
        private final List<JLeftPadded<Space>> dimensionsBeforeName;
        private final List<JRightPadded<NamedVar>> vars;

        public VariableDecls withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new VariableDecls(this.id, this.prefix, this.markers, this.annotations, modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMultiVariable(this, p);
        }

        @Nullable
        @JsonIgnore
        public JavaType.Class getTypeAsClass() {
            return this.typeExpr == null ? null : TypeUtils.asClass(this.typeExpr.getType());
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "VariableDecls(" + VariableDeclsToString.toString(this) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableDecls)) {
                return false;
            }
            VariableDecls other = (VariableDecls)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "annotations", "modifiers", "typeExpr", "varargs", "dimensionsBeforeName", "vars"})
        public VariableDecls(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, TypeTree typeExpr, Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVar>> vars) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeExpr = typeExpr;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.vars = vars;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public Space getVarargs() {
            return this.varargs;
        }

        public List<JLeftPadded<Space>> getDimensionsBeforeName() {
            return this.dimensionsBeforeName;
        }

        public List<JRightPadded<NamedVar>> getVars() {
            return this.vars;
        }

        public VariableDecls withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableDecls(this.id, prefix, this.markers, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars);
        }

        public VariableDecls withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableDecls(this.id, this.prefix, markers, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars);
        }

        public VariableDecls withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new VariableDecls(this.id, this.prefix, this.markers, annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars);
        }

        public VariableDecls withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new VariableDecls(this.id, this.prefix, this.markers, this.annotations, this.modifiers, typeExpr, this.varargs, this.dimensionsBeforeName, this.vars);
        }

        public VariableDecls withVarargs(Space varargs) {
            return this.varargs == varargs ? this : new VariableDecls(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeExpr, varargs, this.dimensionsBeforeName, this.vars);
        }

        public VariableDecls withDimensionsBeforeName(List<JLeftPadded<Space>> dimensionsBeforeName) {
            return this.dimensionsBeforeName == dimensionsBeforeName ? this : new VariableDecls(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeExpr, this.varargs, dimensionsBeforeName, this.vars);
        }

        public VariableDecls withVars(List<JRightPadded<NamedVar>> vars) {
            return this.vars == vars ? this : new VariableDecls(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, vars);
        }

        public static final class NamedVar
        implements J,
        NameTree {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Ident name;
            private final List<JLeftPadded<Space>> dimensionsAfterName;
            @Nullable
            private final JLeftPadded<Expression> initializer;
            @Nullable
            private final JavaType type;

            @JsonIgnore
            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitVariable(this, p);
            }

            @JsonIgnore
            public boolean isField(Cursor cursor) {
                return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getValue() instanceof ClassDecl;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NamedVar)) {
                    return false;
                }
                NamedVar other = (NamedVar)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "name", "dimensionsAfterName", "initializer", "type"})
            public NamedVar(UUID id, Space prefix, Markers markers, Ident name, List<JLeftPadded<Space>> dimensionsAfterName, JLeftPadded<Expression> initializer, JavaType type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.type = type;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Ident getName() {
                return this.name;
            }

            public List<JLeftPadded<Space>> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            public JLeftPadded<Expression> getInitializer() {
                return this.initializer;
            }

            @Override
            public JavaType getType() {
                return this.type;
            }

            public String toString() {
                return "J.VariableDecls.NamedVar(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", dimensionsAfterName=" + this.getDimensionsAfterName() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
            }

            public NamedVar withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new NamedVar(this.id, prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, this.type);
            }

            public NamedVar withMarkers(Markers markers) {
                return this.markers == markers ? this : new NamedVar(this.id, this.prefix, markers, this.name, this.dimensionsAfterName, this.initializer, this.type);
            }

            public NamedVar withName(Ident name) {
                return this.name == name ? this : new NamedVar(this.id, this.prefix, this.markers, name, this.dimensionsAfterName, this.initializer, this.type);
            }

            public NamedVar withDimensionsAfterName(List<JLeftPadded<Space>> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new NamedVar(this.id, this.prefix, this.markers, this.name, dimensionsAfterName, this.initializer, this.type);
            }

            public NamedVar withInitializer(JLeftPadded<Expression> initializer) {
                return this.initializer == initializer ? this : new NamedVar(this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, initializer, this.type);
            }

            public NamedVar withType(JavaType type) {
                return this.type == type ? this : new NamedVar(this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, type);
            }
        }
    }

    public static final class Unary
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expr;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.expr.getSideEffects();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "operator", "expr", "type"})
        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expr, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expr = expr;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JLeftPadded<Type> getOperator() {
            return this.operator;
        }

        public Expression getExpr() {
            return this.expr;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.Unary(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", operator=" + this.getOperator() + ", expr=" + this.getExpr() + ", type=" + this.getType() + ")";
        }

        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.id, prefix, this.markers, this.operator, this.expr, this.type);
        }

        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.id, this.prefix, markers, this.operator, this.expr, this.type);
        }

        public Unary withOperator(JLeftPadded<Type> operator) {
            return this.operator == operator ? this : new Unary(this.id, this.prefix, this.markers, operator, this.expr, this.type);
        }

        public Unary withExpr(Expression expr) {
            return this.expr == expr ? this : new Unary(this.id, this.prefix, this.markers, this.operator, expr, this.type);
        }

        public Unary withType(JavaType type) {
            return this.type == type ? this : new Unary(this.id, this.prefix, this.markers, this.operator, this.expr, type);
        }

        public static enum Type {
            PreIncrement,
            PreDecrement,
            PostIncrement,
            PostDecrement,
            Positive,
            Negative,
            Complement,
            Not;

        }
    }

    public static final class TypeParameter
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final Expression name;
        @Nullable
        private final JContainer<TypeTree> bounds;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeParameter(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameter)) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "annotations", "name", "bounds"})
        public TypeParameter(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Expression name, JContainer<TypeTree> bounds) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Expression getName() {
            return this.name;
        }

        public JContainer<TypeTree> getBounds() {
            return this.bounds;
        }

        public String toString() {
            return "J.TypeParameter(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", name=" + this.getName() + ", bounds=" + this.getBounds() + ")";
        }

        public TypeParameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeParameter(this.id, prefix, this.markers, this.annotations, this.name, this.bounds);
        }

        public TypeParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameter(this.id, this.prefix, markers, this.annotations, this.name, this.bounds);
        }

        public TypeParameter withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameter(this.id, this.prefix, this.markers, annotations, this.name, this.bounds);
        }

        public TypeParameter withName(Expression name) {
            return this.name == name ? this : new TypeParameter(this.id, this.prefix, this.markers, this.annotations, name, this.bounds);
        }

        public TypeParameter withBounds(JContainer<TypeTree> bounds) {
            return this.bounds == bounds ? this : new TypeParameter(this.id, this.prefix, this.markers, this.annotations, this.name, bounds);
        }
    }

    public static final class TypeCast
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<TypeTree> clazz;
        private final Expression expr;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public TypeCast withType(@Nullable JavaType type) {
            return this.withClazz((ControlParentheses<TypeTree>)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeCast(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCast)) {
                return false;
            }
            TypeCast other = (TypeCast)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "clazz", "expr"})
        public TypeCast(UUID id, Space prefix, Markers markers, ControlParentheses<TypeTree> clazz, Expression expr) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.expr = expr;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<TypeTree> getClazz() {
            return this.clazz;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public String toString() {
            return "J.TypeCast(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", clazz=" + this.getClazz() + ", expr=" + this.getExpr() + ")";
        }

        public TypeCast withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeCast(this.id, prefix, this.markers, this.clazz, this.expr);
        }

        public TypeCast withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeCast(this.id, this.prefix, markers, this.clazz, this.expr);
        }

        public TypeCast withClazz(ControlParentheses<TypeTree> clazz) {
            return this.clazz == clazz ? this : new TypeCast(this.id, this.prefix, this.markers, clazz, this.expr);
        }

        public TypeCast withExpr(Expression expr) {
            return this.expr == expr ? this : new TypeCast(this.id, this.prefix, this.markers, this.clazz, expr);
        }
    }

    public static final class Try
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JContainer<Resource> resources;
        private final Block body;
        private final List<Catch> catches;
        @Nullable
        private final JLeftPadded<Block> finallie;

        public Try withFinally(@Nullable JLeftPadded<Block> finallie) {
            if (finallie == this.finallie) {
                return this;
            }
            return new Try(this.id, this.prefix, this.markers, this.resources, this.body, this.catches, finallie);
        }

        @JsonProperty(value="finallie")
        @Nullable
        public JLeftPadded<Block> getFinally() {
            return this.finallie;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTry(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Try)) {
                return false;
            }
            Try other = (Try)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "resources", "body", "catches", "finallie"})
        public Try(UUID id, Space prefix, Markers markers, JContainer<Resource> resources, Block body, List<Catch> catches, JLeftPadded<Block> finallie) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        public UUID getId() {
            return this.id;
        }

        public Try withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Try(this.id, prefix, this.markers, this.resources, this.body, this.catches, this.finallie);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Try withMarkers(Markers markers) {
            return this.markers == markers ? this : new Try(this.id, this.prefix, markers, this.resources, this.body, this.catches, this.finallie);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Try withResources(JContainer<Resource> resources) {
            return this.resources == resources ? this : new Try(this.id, this.prefix, this.markers, resources, this.body, this.catches, this.finallie);
        }

        public JContainer<Resource> getResources() {
            return this.resources;
        }

        public Try withBody(Block body) {
            return this.body == body ? this : new Try(this.id, this.prefix, this.markers, this.resources, body, this.catches, this.finallie);
        }

        public Block getBody() {
            return this.body;
        }

        public Try withCatches(List<Catch> catches) {
            return this.catches == catches ? this : new Try(this.id, this.prefix, this.markers, this.resources, this.body, catches, this.finallie);
        }

        public List<Catch> getCatches() {
            return this.catches;
        }

        public static final class Catch
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final ControlParentheses<VariableDecls> param;
            private final Block body;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitCatch(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Catch)) {
                    return false;
                }
                Catch other = (Catch)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "param", "body"})
            public Catch(UUID id, Space prefix, Markers markers, ControlParentheses<VariableDecls> param, Block body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.param = param;
                this.body = body;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public ControlParentheses<VariableDecls> getParam() {
                return this.param;
            }

            public Block getBody() {
                return this.body;
            }

            public String toString() {
                return "J.Try.Catch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", param=" + this.getParam() + ", body=" + this.getBody() + ")";
            }

            public Catch withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Catch(this.id, prefix, this.markers, this.param, this.body);
            }

            public Catch withMarkers(Markers markers) {
                return this.markers == markers ? this : new Catch(this.id, this.prefix, markers, this.param, this.body);
            }

            public Catch withParam(ControlParentheses<VariableDecls> param) {
                return this.param == param ? this : new Catch(this.id, this.prefix, this.markers, param, this.body);
            }

            public Catch withBody(Block body) {
                return this.body == body ? this : new Catch(this.id, this.prefix, this.markers, this.param, body);
            }
        }

        public static final class Resource
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final VariableDecls variableDecls;
            private final boolean terminatedWithSemicolon;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resource)) {
                    return false;
                }
                Resource other = (Resource)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "variableDecls", "terminatedWithSemicolon"})
            public Resource(UUID id, Space prefix, Markers markers, VariableDecls variableDecls, boolean terminatedWithSemicolon) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variableDecls = variableDecls;
                this.terminatedWithSemicolon = terminatedWithSemicolon;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public VariableDecls getVariableDecls() {
                return this.variableDecls;
            }

            public boolean isTerminatedWithSemicolon() {
                return this.terminatedWithSemicolon;
            }

            public String toString() {
                return "J.Try.Resource(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variableDecls=" + this.getVariableDecls() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
            }

            public Resource withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Resource(this.id, prefix, this.markers, this.variableDecls, this.terminatedWithSemicolon);
            }

            public Resource withMarkers(Markers markers) {
                return this.markers == markers ? this : new Resource(this.id, this.prefix, markers, this.variableDecls, this.terminatedWithSemicolon);
            }

            public Resource withVariableDecls(VariableDecls variableDecls) {
                return this.variableDecls == variableDecls ? this : new Resource(this.id, this.prefix, this.markers, variableDecls, this.terminatedWithSemicolon);
            }

            public Resource withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
                return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new Resource(this.id, this.prefix, this.markers, this.variableDecls, terminatedWithSemicolon);
            }
        }
    }

    public static final class Throw
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression exception;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitThrow(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "exception"})
        public Throw(UUID id, Space prefix, Markers markers, Expression exception) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exception = exception;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getException() {
            return this.exception;
        }

        public String toString() {
            return "J.Throw(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", exception=" + this.getException() + ")";
        }

        public Throw withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Throw(this.id, prefix, this.markers, this.exception);
        }

        public Throw withMarkers(Markers markers) {
            return this.markers == markers ? this : new Throw(this.id, this.prefix, markers, this.exception);
        }

        public Throw withException(Expression exception) {
            return this.exception == exception ? this : new Throw(this.id, this.prefix, this.markers, exception);
        }
    }

    public static final class Ternary
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        private final JLeftPadded<Expression> truePart;
        private final JLeftPadded<Expression> falsePart;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTernary(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ternary)) {
                return false;
            }
            Ternary other = (Ternary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "condition", "truePart", "falsePart", "type"})
        public Ternary(UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public JLeftPadded<Expression> getTruePart() {
            return this.truePart;
        }

        public JLeftPadded<Expression> getFalsePart() {
            return this.falsePart;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.Ternary(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ", truePart=" + this.getTruePart() + ", falsePart=" + this.getFalsePart() + ", type=" + this.getType() + ")";
        }

        public Ternary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Ternary(this.id, prefix, this.markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        public Ternary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ternary(this.id, this.prefix, markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        public Ternary withCondition(Expression condition) {
            return this.condition == condition ? this : new Ternary(this.id, this.prefix, this.markers, condition, this.truePart, this.falsePart, this.type);
        }

        public Ternary withTruePart(JLeftPadded<Expression> truePart) {
            return this.truePart == truePart ? this : new Ternary(this.id, this.prefix, this.markers, this.condition, truePart, this.falsePart, this.type);
        }

        public Ternary withFalsePart(JLeftPadded<Expression> falsePart) {
            return this.falsePart == falsePart ? this : new Ternary(this.id, this.prefix, this.markers, this.condition, this.truePart, falsePart, this.type);
        }

        public Ternary withType(JavaType type) {
            return this.type == type ? this : new Ternary(this.id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart, type);
        }
    }

    public static final class Synchronized
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> lock;
        private final Block body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSynchronized(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synchronized)) {
                return false;
            }
            Synchronized other = (Synchronized)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "lock", "body"})
        public Synchronized(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> lock, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lock = lock;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getLock() {
            return this.lock;
        }

        public Block getBody() {
            return this.body;
        }

        public String toString() {
            return "J.Synchronized(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lock=" + this.getLock() + ", body=" + this.getBody() + ")";
        }

        public Synchronized withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Synchronized(this.id, prefix, this.markers, this.lock, this.body);
        }

        public Synchronized withMarkers(Markers markers) {
            return this.markers == markers ? this : new Synchronized(this.id, this.prefix, markers, this.lock, this.body);
        }

        public Synchronized withLock(ControlParentheses<Expression> lock) {
            return this.lock == lock ? this : new Synchronized(this.id, this.prefix, this.markers, lock, this.body);
        }

        public Synchronized withBody(Block body) {
            return this.body == body ? this : new Synchronized(this.id, this.prefix, this.markers, this.lock, body);
        }
    }

    public static final class Switch
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> selector;
        private final Block cases;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSwitch(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch other = (Switch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "selector", "cases"})
        public Switch(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> selector, Block cases) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.cases = cases;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        public Block getCases() {
            return this.cases;
        }

        public String toString() {
            return "J.Switch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ")";
        }

        public Switch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Switch(this.id, prefix, this.markers, this.selector, this.cases);
        }

        public Switch withMarkers(Markers markers) {
            return this.markers == markers ? this : new Switch(this.id, this.prefix, markers, this.selector, this.cases);
        }

        public Switch withSelector(ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new Switch(this.id, this.prefix, this.markers, selector, this.cases);
        }

        public Switch withCases(Block cases) {
            return this.cases == cases ? this : new Switch(this.id, this.prefix, this.markers, this.selector, cases);
        }
    }

    public static final class Return
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Expression expr;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitReturn(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "expr"})
        public Return(UUID id, Space prefix, Markers markers, Expression expr) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expr = expr;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public String toString() {
            return "J.Return(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expr=" + this.getExpr() + ")";
        }

        public Return withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Return(this.id, prefix, this.markers, this.expr);
        }

        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.id, this.prefix, markers, this.expr);
        }

        public Return withExpr(Expression expr) {
            return this.expr == expr ? this : new Return(this.id, this.prefix, this.markers, expr);
        }
    }

    public static final class Primitive
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JavaType.Primitive type;

        public Primitive withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (!(type instanceof JavaType.Primitive)) {
                throw new IllegalArgumentException("Cannot apply a non-primitive type to Primitive");
            }
            return new Primitive(this.id, this.prefix, this.markers, (JavaType.Primitive)type);
        }

        @Override
        @NonNull
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "type"})
        public Primitive(UUID id, Space prefix, Markers markers, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public Primitive withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Primitive(this.id, prefix, this.markers, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Primitive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Primitive(this.id, this.prefix, markers, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ControlParentheses<J2 extends J>
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitControlParentheses(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getType() : (this.tree instanceof NameTree ? ((NameTree)((Object)this.tree)).getType() : null);
        }

        public ControlParentheses<J2> withType(@Nullable JavaType type) {
            return this.tree instanceof Expression ? (ControlParentheses)((Expression)((Object)this.tree)).withType(type) : (this.tree instanceof NameTree ? (ControlParentheses)((NameTree)((Object)this.tree)).withType(type) : this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlParentheses)) {
                return false;
            }
            ControlParentheses other = (ControlParentheses)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "tree"})
        public ControlParentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<J2> getTree() {
            return this.tree;
        }

        public String toString() {
            return "J.ControlParentheses(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ")";
        }

        public ControlParentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ControlParentheses<J2>(this.id, prefix, this.markers, this.tree);
        }

        public ControlParentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new ControlParentheses<J2>(this.id, this.prefix, markers, this.tree);
        }

        public ControlParentheses<J2> withTree(JRightPadded<J2> tree) {
            return this.tree == tree ? this : new ControlParentheses<J2>(this.id, this.prefix, this.markers, tree);
        }
    }

    public static class Parentheses<J2 extends J>
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParentheses(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree instanceof Expression ? ((Expression)((Object)this.tree)).getType() : (this.tree instanceof NameTree ? ((NameTree)((Object)this.tree)).getType() : null);
        }

        public Parentheses<J2> withType(@Nullable JavaType type) {
            return this.tree instanceof Expression ? (Parentheses)((Expression)((Object)this.tree)).withType(type) : (this.tree instanceof NameTree ? (Parentheses)((NameTree)((Object)this.tree)).withType(type) : this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parentheses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "tree"})
        public Parentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<J2> getTree() {
            return this.tree;
        }

        public String toString() {
            return "J.Parentheses(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ")";
        }

        public Parentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parentheses<J2>(this.id, prefix, this.markers, this.tree);
        }

        public Parentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses<J2>(this.id, this.prefix, markers, this.tree);
        }

        public Parentheses<J2> withTree(JRightPadded<J2> tree) {
            return this.tree == tree ? this : new Parentheses<J2>(this.id, this.prefix, this.markers, tree);
        }
    }

    public static final class ParameterizedType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree clazz;
        @Nullable
        private final JContainer<Expression> typeParameters;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public ParameterizedType withType(@Nullable JavaType type) {
            if (type == this.clazz.getType()) {
                return this;
            }
            return this.withClazz((NameTree)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParameterizedType(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "clazz", "typeParameters"})
        public ParameterizedType(UUID id, Space prefix, Markers markers, NameTree clazz, JContainer<Expression> typeParameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public NameTree getClazz() {
            return this.clazz;
        }

        public JContainer<Expression> getTypeParameters() {
            return this.typeParameters;
        }

        public String toString() {
            return "J.ParameterizedType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", clazz=" + this.getClazz() + ", typeParameters=" + this.getTypeParameters() + ")";
        }

        public ParameterizedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ParameterizedType(this.id, prefix, this.markers, this.clazz, this.typeParameters);
        }

        public ParameterizedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ParameterizedType(this.id, this.prefix, markers, this.clazz, this.typeParameters);
        }

        public ParameterizedType withClazz(NameTree clazz) {
            return this.clazz == clazz ? this : new ParameterizedType(this.id, this.prefix, this.markers, clazz, this.typeParameters);
        }

        public ParameterizedType withTypeParameters(JContainer<Expression> typeParameters) {
            return this.typeParameters == typeParameters ? this : new ParameterizedType(this.id, this.prefix, this.markers, this.clazz, typeParameters);
        }
    }

    public static final class Package
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expr;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPackage(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "expr"})
        public Package(UUID id, Space prefix, Markers markers, Expression expr) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expr = expr;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public String toString() {
            return "J.Package(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expr=" + this.getExpr() + ")";
        }

        public Package withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Package(this.id, prefix, this.markers, this.expr);
        }

        public Package withMarkers(Markers markers) {
            return this.markers == markers ? this : new Package(this.id, this.prefix, markers, this.expr);
        }

        public Package withExpr(Expression expr) {
            return this.expr == expr ? this : new Package(this.id, this.prefix, this.markers, expr);
        }
    }

    public static final class NewClass
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> encl;
        private final Space nooh;
        @Nullable
        private final TypeTree clazz;
        @Nullable
        private final JContainer<Expression> args;
        @Nullable
        private final Block body;
        @Nullable
        private final JavaType type;

        public NewClass withNew(Space nooh) {
            if (nooh == this.nooh) {
                return this;
            }
            return new NewClass(this.id, this.prefix, this.markers, this.encl, nooh, this.clazz, this.args, this.body, this.type);
        }

        @JsonProperty(value="nooh")
        public Space getNew() {
            return this.nooh;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewClass(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewClass)) {
                return false;
            }
            NewClass other = (NewClass)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "encl", "nooh", "clazz", "args", "body", "type"})
        public NewClass(UUID id, Space prefix, Markers markers, JRightPadded<Expression> encl, Space nooh, TypeTree clazz, JContainer<Expression> args, Block body, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.encl = encl;
            this.nooh = nooh;
            this.clazz = clazz;
            this.args = args;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public NewClass withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewClass(this.id, prefix, this.markers, this.encl, this.nooh, this.clazz, this.args, this.body, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public NewClass withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewClass(this.id, this.prefix, markers, this.encl, this.nooh, this.clazz, this.args, this.body, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public NewClass withEncl(JRightPadded<Expression> encl) {
            return this.encl == encl ? this : new NewClass(this.id, this.prefix, this.markers, encl, this.nooh, this.clazz, this.args, this.body, this.type);
        }

        public JRightPadded<Expression> getEncl() {
            return this.encl;
        }

        public NewClass withClazz(TypeTree clazz) {
            return this.clazz == clazz ? this : new NewClass(this.id, this.prefix, this.markers, this.encl, this.nooh, clazz, this.args, this.body, this.type);
        }

        public TypeTree getClazz() {
            return this.clazz;
        }

        public NewClass withArgs(JContainer<Expression> args) {
            return this.args == args ? this : new NewClass(this.id, this.prefix, this.markers, this.encl, this.nooh, this.clazz, args, this.body, this.type);
        }

        public JContainer<Expression> getArgs() {
            return this.args;
        }

        public NewClass withBody(Block body) {
            return this.body == body ? this : new NewClass(this.id, this.prefix, this.markers, this.encl, this.nooh, this.clazz, this.args, body, this.type);
        }

        public Block getBody() {
            return this.body;
        }

        public NewClass withType(JavaType type) {
            return this.type == type ? this : new NewClass(this.id, this.prefix, this.markers, this.encl, this.nooh, this.clazz, this.args, this.body, type);
        }

        @Override
        public JavaType getType() {
            return this.type;
        }
    }

    public static final class ArrayDimension
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> index;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayDimension(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayDimension)) {
                return false;
            }
            ArrayDimension other = (ArrayDimension)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "index"})
        public ArrayDimension(UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<Expression> getIndex() {
            return this.index;
        }

        public String toString() {
            return "J.ArrayDimension(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", index=" + this.getIndex() + ")";
        }

        public ArrayDimension withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayDimension(this.id, prefix, this.markers, this.index);
        }

        public ArrayDimension withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayDimension(this.id, this.prefix, markers, this.index);
        }

        public ArrayDimension withIndex(JRightPadded<Expression> index) {
            return this.index == index ? this : new ArrayDimension(this.id, this.prefix, this.markers, index);
        }
    }

    public static final class NewArray
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final TypeTree typeExpr;
        private final List<ArrayDimension> dimensions;
        @Nullable
        private final JContainer<Expression> initializer;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewArray(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewArray)) {
                return false;
            }
            NewArray other = (NewArray)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "typeExpr", "dimensions", "initializer", "type"})
        public NewArray(UUID id, Space prefix, Markers markers, TypeTree typeExpr, List<ArrayDimension> dimensions, JContainer<Expression> initializer, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpr = typeExpr;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public List<ArrayDimension> getDimensions() {
            return this.dimensions;
        }

        public JContainer<Expression> getInitializer() {
            return this.initializer;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.NewArray(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", typeExpr=" + this.getTypeExpr() + ", dimensions=" + this.getDimensions() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
        }

        public NewArray withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewArray(this.id, prefix, this.markers, this.typeExpr, this.dimensions, this.initializer, this.type);
        }

        public NewArray withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewArray(this.id, this.prefix, markers, this.typeExpr, this.dimensions, this.initializer, this.type);
        }

        public NewArray withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new NewArray(this.id, this.prefix, this.markers, typeExpr, this.dimensions, this.initializer, this.type);
        }

        public NewArray withDimensions(List<ArrayDimension> dimensions) {
            return this.dimensions == dimensions ? this : new NewArray(this.id, this.prefix, this.markers, this.typeExpr, dimensions, this.initializer, this.type);
        }

        public NewArray withInitializer(JContainer<Expression> initializer) {
            return this.initializer == initializer ? this : new NewArray(this.id, this.prefix, this.markers, this.typeExpr, this.dimensions, initializer, this.type);
        }

        public NewArray withType(JavaType type) {
            return this.type == type ? this : new NewArray(this.id, this.prefix, this.markers, this.typeExpr, this.dimensions, this.initializer, type);
        }
    }

    public static final class MultiCatch
    implements J,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<NameTree>> alternatives;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMultiCatch(this, p);
        }

        public MultiCatch withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        @JsonIgnore
        public JavaType getType() {
            return new JavaType.MultiCatch(this.alternatives.stream().filter(Objects::nonNull).map(alt -> ((NameTree)alt.getElem()).getType()).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "alternatives"})
        public MultiCatch(UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<JRightPadded<NameTree>> getAlternatives() {
            return this.alternatives;
        }

        public String toString() {
            return "J.MultiCatch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", alternatives=" + this.getAlternatives() + ")";
        }

        public MultiCatch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MultiCatch(this.id, prefix, this.markers, this.alternatives);
        }

        public MultiCatch withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiCatch(this.id, this.prefix, markers, this.alternatives);
        }

        public MultiCatch withAlternatives(List<JRightPadded<NameTree>> alternatives) {
            return this.alternatives == alternatives ? this : new MultiCatch(this.id, this.prefix, this.markers, alternatives);
        }
    }

    public static final class Modifier
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;

        public static boolean hasModifier(Collection<Modifier> modifiers, String modifier) {
            return modifiers.stream().anyMatch(m -> m.getClass().getSimpleName().toLowerCase().equals(modifier));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "type"})
        public Modifier(UUID id, Space prefix, Markers markers, Type type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "J.Modifier(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", type=" + (Object)((Object)this.getType()) + ")";
        }

        public Modifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Modifier(this.id, prefix, this.markers, this.type);
        }

        public Modifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Modifier(this.id, this.prefix, markers, this.type);
        }

        public Modifier withType(Type type) {
            return this.type == type ? this : new Modifier(this.id, this.prefix, this.markers, type);
        }

        public static enum Type {
            Default,
            Public,
            Protected,
            Private,
            Abstract,
            Static,
            Final,
            Native,
            Strictfp,
            Synchronized,
            Transient,
            Volatile;

        }
    }

    public static final class MethodInvocation
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> select;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final Ident name;
        private final JContainer<Expression> args;
        @Nullable
        private final JavaType.Method type;

        public MethodInvocation withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type instanceof JavaType.Method) {
                return new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, this.name, this.args, (JavaType.Method)type);
            }
            return this;
        }

        public MethodInvocation withDeclaringType(JavaType.FullyQualified type) {
            if (this.type == null) {
                return this;
            }
            return this.withType(this.type.withDeclaringType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodInvocation(this, p);
        }

        @JsonIgnore
        @Nullable
        public JavaType getReturnType() {
            return this.type == null ? null : (this.type.getResolvedSignature() == null ? null : this.type.getResolvedSignature().getReturnType());
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInvocation)) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "select", "typeParameters", "name", "args", "type"})
        public MethodInvocation(UUID id, Space prefix, Markers markers, JRightPadded<Expression> select, JContainer<Expression> typeParameters, Ident name, JContainer<Expression> args, JavaType.Method type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.args = args;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<Expression> getSelect() {
            return this.select;
        }

        public JContainer<Expression> getTypeParameters() {
            return this.typeParameters;
        }

        public Ident getName() {
            return this.name;
        }

        public JContainer<Expression> getArgs() {
            return this.args;
        }

        @Override
        public JavaType.Method getType() {
            return this.type;
        }

        public String toString() {
            return "J.MethodInvocation(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", select=" + this.getSelect() + ", typeParameters=" + this.getTypeParameters() + ", name=" + this.getName() + ", args=" + this.getArgs() + ", type=" + this.getType() + ")";
        }

        public MethodInvocation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodInvocation(this.id, prefix, this.markers, this.select, this.typeParameters, this.name, this.args, this.type);
        }

        public MethodInvocation withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodInvocation(this.id, this.prefix, markers, this.select, this.typeParameters, this.name, this.args, this.type);
        }

        public MethodInvocation withSelect(JRightPadded<Expression> select) {
            return this.select == select ? this : new MethodInvocation(this.id, this.prefix, this.markers, select, this.typeParameters, this.name, this.args, this.type);
        }

        public MethodInvocation withTypeParameters(JContainer<Expression> typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodInvocation(this.id, this.prefix, this.markers, this.select, typeParameters, this.name, this.args, this.type);
        }

        public MethodInvocation withName(Ident name) {
            return this.name == name ? this : new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, name, this.args, this.type);
        }

        public MethodInvocation withArgs(JContainer<Expression> args) {
            return this.args == args ? this : new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, this.name, args, this.type);
        }
    }

    public static final class MethodDecl
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final JContainer<TypeParameter> typeParameters;
        @Nullable
        private final TypeTree returnTypeExpr;
        private final Ident name;
        private final JContainer<Statement> params;
        @Nullable
        private final JContainer<NameTree> throwz;
        @Nullable
        private final Block body;
        @Nullable
        private final JLeftPadded<Expression> defaultValue;
        @Nullable
        private final JavaType.Method type;

        public MethodDecl withThrows(@Nullable JContainer<NameTree> throwz) {
            if (throwz == this.throwz) {
                return this;
            }
            return new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, throwz, this.body, this.defaultValue, this.type);
        }

        @JsonProperty(value="throwz")
        @Nullable
        public JContainer<NameTree> getThrows() {
            return this.throwz;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethod(this, p);
        }

        @JsonIgnore
        public boolean isAbstract() {
            return this.body == null;
        }

        @JsonIgnore
        public boolean isConstructor() {
            return this.getReturnTypeExpr() == null;
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "MethodDecl(" + MethodDeclToString.toString(this) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDecl)) {
                return false;
            }
            MethodDecl other = (MethodDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "annotations", "modifiers", "typeParameters", "returnTypeExpr", "name", "params", "throwz", "body", "defaultValue", "type"})
        public MethodDecl(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, JContainer<TypeParameter> typeParameters, TypeTree returnTypeExpr, Ident name, JContainer<Statement> params, JContainer<NameTree> throwz, Block body, JLeftPadded<Expression> defaultValue, JavaType.Method type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpr = returnTypeExpr;
            this.name = name;
            this.params = params;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public MethodDecl withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodDecl(this.id, prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public MethodDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodDecl(this.id, this.prefix, markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public MethodDecl withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new MethodDecl(this.id, this.prefix, this.markers, annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public MethodDecl withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public MethodDecl withTypeParameters(JContainer<TypeParameter> typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public JContainer<TypeParameter> getTypeParameters() {
            return this.typeParameters;
        }

        public MethodDecl withReturnTypeExpr(TypeTree returnTypeExpr) {
            return this.returnTypeExpr == returnTypeExpr ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public TypeTree getReturnTypeExpr() {
            return this.returnTypeExpr;
        }

        public MethodDecl withName(Ident name) {
            return this.name == name ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, name, this.params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public Ident getName() {
            return this.name;
        }

        public MethodDecl withParams(JContainer<Statement> params) {
            return this.params == params ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, params, this.throwz, this.body, this.defaultValue, this.type);
        }

        public JContainer<Statement> getParams() {
            return this.params;
        }

        public MethodDecl withBody(Block body) {
            return this.body == body ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, body, this.defaultValue, this.type);
        }

        public Block getBody() {
            return this.body;
        }

        public MethodDecl withDefaultValue(JLeftPadded<Expression> defaultValue) {
            return this.defaultValue == defaultValue ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, defaultValue, this.type);
        }

        public JLeftPadded<Expression> getDefaultValue() {
            return this.defaultValue;
        }

        public MethodDecl withType(JavaType.Method type) {
            return this.type == type ? this : new MethodDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, type);
        }

        public JavaType.Method getType() {
            return this.type;
        }
    }

    public static final class MemberReference
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression containing;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final JLeftPadded<Ident> reference;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMemberReference(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberReference)) {
                return false;
            }
            MemberReference other = (MemberReference)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "containing", "typeParameters", "reference", "type"})
        public MemberReference(UUID id, Space prefix, Markers markers, Expression containing, JContainer<Expression> typeParameters, JLeftPadded<Ident> reference, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getContaining() {
            return this.containing;
        }

        public JContainer<Expression> getTypeParameters() {
            return this.typeParameters;
        }

        public JLeftPadded<Ident> getReference() {
            return this.reference;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.MemberReference(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", containing=" + this.getContaining() + ", typeParameters=" + this.getTypeParameters() + ", reference=" + this.getReference() + ", type=" + this.getType() + ")";
        }

        public MemberReference withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MemberReference(this.id, prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type);
        }

        public MemberReference withMarkers(Markers markers) {
            return this.markers == markers ? this : new MemberReference(this.id, this.prefix, markers, this.containing, this.typeParameters, this.reference, this.type);
        }

        public MemberReference withContaining(Expression containing) {
            return this.containing == containing ? this : new MemberReference(this.id, this.prefix, this.markers, containing, this.typeParameters, this.reference, this.type);
        }

        public MemberReference withTypeParameters(JContainer<Expression> typeParameters) {
            return this.typeParameters == typeParameters ? this : new MemberReference(this.id, this.prefix, this.markers, this.containing, typeParameters, this.reference, this.type);
        }

        public MemberReference withReference(JLeftPadded<Ident> reference) {
            return this.reference == reference ? this : new MemberReference(this.id, this.prefix, this.markers, this.containing, this.typeParameters, reference, this.type);
        }

        public MemberReference withType(JavaType type) {
            return this.type == type ? this : new MemberReference(this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, type);
        }
    }

    public static final class Literal
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Object value;
        private final String valueSource;
        private final JavaType.Primitive type;

        public Literal withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type instanceof JavaType.Primitive) {
                return new Literal(this.id, this.prefix, this.markers, this.value, this.valueSource, (JavaType.Primitive)type);
            }
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        public <T> String transformValue(Function<T, Object> transform) {
            Matcher valueMatcher = Pattern.compile("(.*)" + Pattern.quote(this.value == null ? "null" : this.value.toString()) + "(.*)").matcher(this.printTrimmed().replace("\\", ""));
            if (valueMatcher.find()) {
                String prefix = valueMatcher.group(1);
                String suffix = valueMatcher.group(2);
                return prefix + transform.apply(this.value) + suffix;
            }
            throw new IllegalStateException("Encountered a literal `" + this + "` that could not be transformed");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "value", "valueSource", "type"})
        public Literal(UUID id, Space prefix, Markers markers, Object value, String valueSource, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        @Override
        public JavaType.Primitive getType() {
            return this.type;
        }

        public String toString() {
            return "J.Literal(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ", valueSource=" + this.getValueSource() + ", type=" + this.getType() + ")";
        }

        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.value, this.valueSource, this.type);
        }

        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.value, this.valueSource, this.type);
        }

        public Literal withValue(Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, value, this.valueSource, this.type);
        }

        public Literal withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.prefix, this.markers, this.value, valueSource, this.type);
        }
    }

    public static final class Lambda
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Parameters parameters;
        private final Space arrow;
        private final J body;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLambda(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lambda)) {
                return false;
            }
            Lambda other = (Lambda)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "parameters", "arrow", "body", "type"})
        public Lambda(UUID id, Space prefix, Markers markers, Parameters parameters, Space arrow, J body, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public Space getArrow() {
            return this.arrow;
        }

        public J getBody() {
            return this.body;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.Lambda(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parameters=" + this.getParameters() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ")";
        }

        public Lambda withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Lambda(this.id, prefix, this.markers, this.parameters, this.arrow, this.body, this.type);
        }

        public Lambda withMarkers(Markers markers) {
            return this.markers == markers ? this : new Lambda(this.id, this.prefix, markers, this.parameters, this.arrow, this.body, this.type);
        }

        public Lambda withParameters(Parameters parameters) {
            return this.parameters == parameters ? this : new Lambda(this.id, this.prefix, this.markers, parameters, this.arrow, this.body, this.type);
        }

        public Lambda withArrow(Space arrow) {
            return this.arrow == arrow ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, arrow, this.body, this.type);
        }

        public Lambda withBody(J body) {
            return this.body == body ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, body, this.type);
        }

        public Lambda withType(JavaType type) {
            return this.type == type ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, this.body, type);
        }

        public static final class Parameters
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final boolean parenthesized;
            private final List<JRightPadded<J>> params;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "parenthesized", "params"})
            public Parameters(UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> params) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.params = params;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public boolean isParenthesized() {
                return this.parenthesized;
            }

            public List<JRightPadded<J>> getParams() {
                return this.params;
            }

            public String toString() {
                return "J.Lambda.Parameters(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parenthesized=" + this.isParenthesized() + ", params=" + this.getParams() + ")";
            }

            public Parameters withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Parameters(this.id, prefix, this.markers, this.parenthesized, this.params);
            }

            public Parameters withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameters(this.id, this.prefix, markers, this.parenthesized, this.params);
            }

            public Parameters withParenthesized(boolean parenthesized) {
                return this.parenthesized == parenthesized ? this : new Parameters(this.id, this.prefix, this.markers, parenthesized, this.params);
            }

            public Parameters withParams(List<JRightPadded<J>> params) {
                return this.params == params ? this : new Parameters(this.id, this.prefix, this.markers, this.parenthesized, params);
            }
        }
    }

    public static final class Label
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Ident> label;
        private final Statement statement;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLabel(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Label)) {
                return false;
            }
            Label other = (Label)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "label", "statement"})
        public Label(UUID id, Space prefix, Markers markers, JRightPadded<Ident> label, Statement statement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<Ident> getLabel() {
            return this.label;
        }

        public Statement getStatement() {
            return this.statement;
        }

        public String toString() {
            return "J.Label(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", label=" + this.getLabel() + ", statement=" + this.getStatement() + ")";
        }

        public Label withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Label(this.id, prefix, this.markers, this.label, this.statement);
        }

        public Label withMarkers(Markers markers) {
            return this.markers == markers ? this : new Label(this.id, this.prefix, markers, this.label, this.statement);
        }

        public Label withLabel(JRightPadded<Ident> label) {
            return this.label == label ? this : new Label(this.id, this.prefix, this.markers, label, this.statement);
        }

        public Label withStatement(Statement statement) {
            return this.statement == statement ? this : new Label(this.id, this.prefix, this.markers, this.label, statement);
        }
    }

    public static final class InstanceOf
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> expr;
        private final J clazz;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitInstanceOf(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            InstanceOf other = (InstanceOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "expr", "clazz", "type"})
        public InstanceOf(UUID id, Space prefix, Markers markers, JRightPadded<Expression> expr, J clazz, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expr = expr;
            this.clazz = clazz;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<Expression> getExpr() {
            return this.expr;
        }

        public J getClazz() {
            return this.clazz;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.InstanceOf(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expr=" + this.getExpr() + ", clazz=" + this.getClazz() + ", type=" + this.getType() + ")";
        }

        public InstanceOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new InstanceOf(this.id, prefix, this.markers, this.expr, this.clazz, this.type);
        }

        public InstanceOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new InstanceOf(this.id, this.prefix, markers, this.expr, this.clazz, this.type);
        }

        public InstanceOf withExpr(JRightPadded<Expression> expr) {
            return this.expr == expr ? this : new InstanceOf(this.id, this.prefix, this.markers, expr, this.clazz, this.type);
        }

        public InstanceOf withClazz(J clazz) {
            return this.clazz == clazz ? this : new InstanceOf(this.id, this.prefix, this.markers, this.expr, clazz, this.type);
        }

        public InstanceOf withType(JavaType type) {
            return this.type == type ? this : new InstanceOf(this.id, this.prefix, this.markers, this.expr, this.clazz, type);
        }
    }

    public static final class Import
    implements J,
    Comparable<Import> {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Space statik;
        private final FieldAccess qualid;

        public boolean isStatic() {
            return this.statik != null;
        }

        @JsonProperty(value="statik")
        @Nullable
        public Space getStatic() {
            return this.statik;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitImport(this, p);
        }

        @JsonIgnore
        public boolean isFromType(String clazz) {
            if ("*".equals(this.qualid.getSimpleName())) {
                return this.qualid.target.printTrimmed().equals(Arrays.stream(clazz.split("\\.")).filter(pkgOrNam -> Character.isLowerCase(pkgOrNam.charAt(0))).collect(Collectors.joining(".")));
            }
            return (this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed()).equals(clazz);
        }

        public String getTypeName() {
            return this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed();
        }

        @JsonIgnore
        public String getPackageName() {
            JavaType.Class importType = TypeUtils.asClass(this.qualid.getType());
            if (importType != null) {
                return importType.getPackageName();
            }
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.qualid.getTarget().printTrimmed().split("\\.")).filter(pkg -> {
                takeWhile.set(takeWhile.get() && !pkg.isEmpty() && Character.isLowerCase(pkg.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        @Override
        public int compareTo(Import o) {
            String p1 = this.getPackageName();
            String p2 = o.getPackageName();
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : this.getQualid().getSimpleName().compareTo(o.getQualid().getSimpleName());
        }

        public String toString() {
            return "Import(" + ImportToString.toString(this) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "statik", "qualid"})
        public Import(UUID id, Space prefix, Markers markers, Space statik, FieldAccess qualid) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Import withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Import(this.id, prefix, this.markers, this.statik, this.qualid);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.id, this.prefix, markers, this.statik, this.qualid);
        }

        public Import withStatik(Space statik) {
            return this.statik == statik ? this : new Import(this.id, this.prefix, this.markers, statik, this.qualid);
        }

        public Import withQualid(FieldAccess qualid) {
            return this.qualid == qualid ? this : new Import(this.id, this.prefix, this.markers, this.statik, qualid);
        }

        public FieldAccess getQualid() {
            return this.qualid;
        }
    }

    public static final class If
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> ifCondition;
        private final JRightPadded<Statement> thenPart;
        @Nullable
        private final Else elsePart;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIf(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof If)) {
                return false;
            }
            If other = (If)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "ifCondition", "thenPart", "elsePart"})
        public If(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, Else elsePart) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getIfCondition() {
            return this.ifCondition;
        }

        public JRightPadded<Statement> getThenPart() {
            return this.thenPart;
        }

        public Else getElsePart() {
            return this.elsePart;
        }

        public String toString() {
            return "J.If(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", ifCondition=" + this.getIfCondition() + ", thenPart=" + this.getThenPart() + ", elsePart=" + this.getElsePart() + ")";
        }

        public If withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new If(this.id, prefix, this.markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        public If withMarkers(Markers markers) {
            return this.markers == markers ? this : new If(this.id, this.prefix, markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        public If withIfCondition(ControlParentheses<Expression> ifCondition) {
            return this.ifCondition == ifCondition ? this : new If(this.id, this.prefix, this.markers, ifCondition, this.thenPart, this.elsePart);
        }

        public If withThenPart(JRightPadded<Statement> thenPart) {
            return this.thenPart == thenPart ? this : new If(this.id, this.prefix, this.markers, this.ifCondition, thenPart, this.elsePart);
        }

        public If withElsePart(Else elsePart) {
            return this.elsePart == elsePart ? this : new If(this.id, this.prefix, this.markers, this.ifCondition, this.thenPart, elsePart);
        }

        public static final class Else
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Statement> body;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitElse(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Else)) {
                    return false;
                }
                Else other = (Else)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "body"})
            public Else(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public JRightPadded<Statement> getBody() {
                return this.body;
            }

            public String toString() {
                return "J.If.Else(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ")";
            }

            public Else withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Else(this.id, prefix, this.markers, this.body);
            }

            public Else withMarkers(Markers markers) {
                return this.markers == markers ? this : new Else(this.id, this.prefix, markers, this.body);
            }

            public Else withBody(JRightPadded<Statement> body) {
                return this.body == body ? this : new Else(this.id, this.prefix, this.markers, body);
            }
        }
    }

    public static final class Ident
    implements J,
    TypeTree,
    Expression {
        private static final Map<String, Map<JavaType, IdentFlyweight>> flyweights = new HashMap<String, Map<JavaType, IdentFlyweight>>();
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final IdentFlyweight ident;

        private Ident(UUID id, IdentFlyweight ident, Space prefix, Markers markers) {
            this.id = id;
            this.ident = ident;
            this.prefix = prefix;
            this.markers = markers;
        }

        @Override
        public JavaType getType() {
            return this.ident.getType();
        }

        public Ident withType(@Nullable JavaType type) {
            if (type == this.getType()) {
                return this;
            }
            return Ident.build(this.id, this.prefix, this.markers, this.getSimpleName(), type);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.ident.getSimpleName();
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        public Ident withName(String name) {
            if (name.equals(this.ident.getSimpleName())) {
                return this;
            }
            return Ident.build(this.id, this.prefix, this.markers, name, this.getType());
        }

        public Ident withMarkers(Markers markers) {
            if (markers == this.markers) {
                return this;
            }
            return Ident.build(this.id, this.prefix, markers, this.ident.getSimpleName(), this.getType());
        }

        public Ident withPrefix(Space prefix) {
            if (prefix == this.prefix) {
                return this;
            }
            return Ident.build(this.id, prefix, this.markers, this.ident.getSimpleName(), this.getType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Ident build(@JsonProperty(value="id") UUID id, @JsonProperty(value="prefix") Space prefix, @JsonProperty(value="metadata") Markers markers, @JsonProperty(value="simpleName") String simpleName, @JsonProperty(value="type") @Nullable JavaType type) {
            Map<String, Map<JavaType, IdentFlyweight>> map = flyweights;
            synchronized (map) {
                return new Ident(id, flyweights.computeIfAbsent(simpleName, n -> new HashMap()).computeIfAbsent(type, t -> new IdentFlyweight(simpleName, (JavaType)t)), prefix, markers);
            }
        }

        public String toString() {
            return "Ident(" + this.printTrimmed() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ident)) {
                return false;
            }
            Ident other = (Ident)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public IdentFlyweight getIdent() {
            return this.ident;
        }

        public static final class IdentFlyweight
        implements Serializable {
            private final String simpleName;
            @Nullable
            private final JavaType type;

            @ConstructorProperties(value={"simpleName", "type"})
            public IdentFlyweight(String simpleName, JavaType type) {
                this.simpleName = simpleName;
                this.type = type;
            }

            public String getSimpleName() {
                return this.simpleName;
            }

            public JavaType getType() {
                return this.type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdentFlyweight)) {
                    return false;
                }
                IdentFlyweight other = (IdentFlyweight)o;
                String this$simpleName = this.getSimpleName();
                String other$simpleName = other.getSimpleName();
                if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
                    return false;
                }
                JavaType this$type = this.getType();
                JavaType other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $simpleName = this.getSimpleName();
                result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
                JavaType $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public String toString() {
                return "J.Ident.IdentFlyweight(simpleName=" + this.getSimpleName() + ", type=" + this.getType() + ")";
            }
        }
    }

    public static final class ForLoop
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForLoop(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "control", "body"})
        public ForLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Control getControl() {
            return this.control;
        }

        public JRightPadded<Statement> getBody() {
            return this.body;
        }

        public String toString() {
            return "J.ForLoop(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        public ForLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForLoop(this.id, prefix, this.markers, this.control, this.body);
        }

        public ForLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForLoop(this.id, this.prefix, markers, this.control, this.body);
        }

        public ForLoop withControl(Control control) {
            return this.control == control ? this : new ForLoop(this.id, this.prefix, this.markers, control, this.body);
        }

        public ForLoop withBody(JRightPadded<Statement> body) {
            return this.body == body ? this : new ForLoop(this.id, this.prefix, this.markers, this.control, body);
        }

        public static final class Control
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Statement> init;
            private final JRightPadded<Expression> condition;
            private final List<JRightPadded<Statement>> update;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForControl(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "init", "condition", "update"})
            public Control(UUID id, Space prefix, Markers markers, JRightPadded<Statement> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public JRightPadded<Statement> getInit() {
                return this.init;
            }

            public JRightPadded<Expression> getCondition() {
                return this.condition;
            }

            public List<JRightPadded<Statement>> getUpdate() {
                return this.update;
            }

            public String toString() {
                return "J.ForLoop.Control(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", init=" + this.getInit() + ", condition=" + this.getCondition() + ", update=" + this.getUpdate() + ")";
            }

            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.id, prefix, this.markers, this.init, this.condition, this.update);
            }

            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.id, this.prefix, markers, this.init, this.condition, this.update);
            }

            public Control withInit(JRightPadded<Statement> init) {
                return this.init == init ? this : new Control(this.id, this.prefix, this.markers, init, this.condition, this.update);
            }

            public Control withCondition(JRightPadded<Expression> condition) {
                return this.condition == condition ? this : new Control(this.id, this.prefix, this.markers, this.init, condition, this.update);
            }

            public Control withUpdate(List<JRightPadded<Statement>> update) {
                return this.update == update ? this : new Control(this.id, this.prefix, this.markers, this.init, this.condition, update);
            }
        }
    }

    public static final class ForEachLoop
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForEachLoop(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForEachLoop)) {
                return false;
            }
            ForEachLoop other = (ForEachLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "control", "body"})
        public ForEachLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Control getControl() {
            return this.control;
        }

        public JRightPadded<Statement> getBody() {
            return this.body;
        }

        public String toString() {
            return "J.ForEachLoop(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        public ForEachLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForEachLoop(this.id, prefix, this.markers, this.control, this.body);
        }

        public ForEachLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForEachLoop(this.id, this.prefix, markers, this.control, this.body);
        }

        public ForEachLoop withControl(Control control) {
            return this.control == control ? this : new ForEachLoop(this.id, this.prefix, this.markers, control, this.body);
        }

        public ForEachLoop withBody(JRightPadded<Statement> body) {
            return this.body == body ? this : new ForEachLoop(this.id, this.prefix, this.markers, this.control, body);
        }

        public static final class Control
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<VariableDecls> variable;
            private final JRightPadded<Expression> iterable;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForEachControl(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "prefix", "markers", "variable", "iterable"})
            public Control(UUID id, Space prefix, Markers markers, JRightPadded<VariableDecls> variable, JRightPadded<Expression> iterable) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public JRightPadded<VariableDecls> getVariable() {
                return this.variable;
            }

            public JRightPadded<Expression> getIterable() {
                return this.iterable;
            }

            public String toString() {
                return "J.ForEachLoop.Control(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variable=" + this.getVariable() + ", iterable=" + this.getIterable() + ")";
            }

            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.id, prefix, this.markers, this.variable, this.iterable);
            }

            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.id, this.prefix, markers, this.variable, this.iterable);
            }

            public Control withVariable(JRightPadded<VariableDecls> variable) {
                return this.variable == variable ? this : new Control(this.id, this.prefix, this.markers, variable, this.iterable);
            }

            public Control withIterable(JRightPadded<Expression> iterable) {
                return this.iterable == iterable ? this : new Control(this.id, this.prefix, this.markers, this.variable, iterable);
            }
        }
    }

    public static final class FieldAccess
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression target;
        private final JLeftPadded<Ident> name;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitFieldAccess(this, p);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getElem().getSimpleName();
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.target.getSideEffects();
        }

        public String toString() {
            return "FieldAccess(" + this.printTrimmed() + ")";
        }

        @Nullable
        public NameTree asClassReference() {
            if (this.target instanceof NameTree) {
                String fqn = null;
                if (this.type instanceof JavaType.Class) {
                    fqn = ((JavaType.Class)this.type).getFullyQualifiedName();
                } else if (this.type instanceof JavaType.ShallowClass) {
                    fqn = ((JavaType.ShallowClass)this.type).getFullyQualifiedName();
                }
                return "java.lang.Class".equals(fqn) ? (NameTree)((Object)this.target) : null;
            }
            return null;
        }

        public boolean isFullyQualifiedClassReference(String className) {
            return this.isFullyQualifiedClassReference(this, className);
        }

        public boolean isFullyQualifiedClassReference(MethodMatcher methodMatcher) {
            String hopefullyFullyQualifiedMethod = methodMatcher.getTargetTypePattern().pattern() + "." + methodMatcher.getMethodNamePattern().pattern();
            return this.isFullyQualifiedClassReference(this, hopefullyFullyQualifiedMethod);
        }

        private boolean isFullyQualifiedClassReference(FieldAccess fieldAccess, String className) {
            if (!className.contains(".")) {
                return false;
            }
            if (!fieldAccess.getName().getElem().getSimpleName().equals(className.substring(className.lastIndexOf(46) + 1))) {
                return false;
            }
            if (fieldAccess.getTarget() instanceof FieldAccess) {
                return this.isFullyQualifiedClassReference((FieldAccess)fieldAccess.getTarget(), className.substring(0, className.lastIndexOf(46)));
            }
            if (fieldAccess.getTarget() instanceof Ident) {
                return ((Ident)fieldAccess.getTarget()).getSimpleName().equals(className.substring(0, className.lastIndexOf(46)));
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess other = (FieldAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "target", "name", "type"})
        public FieldAccess(UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Ident> name, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getTarget() {
            return this.target;
        }

        public JLeftPadded<Ident> getName() {
            return this.name;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public FieldAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FieldAccess(this.id, prefix, this.markers, this.target, this.name, this.type);
        }

        public FieldAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new FieldAccess(this.id, this.prefix, markers, this.target, this.name, this.type);
        }

        public FieldAccess withTarget(Expression target) {
            return this.target == target ? this : new FieldAccess(this.id, this.prefix, this.markers, target, this.name, this.type);
        }

        public FieldAccess withName(JLeftPadded<Ident> name) {
            return this.name == name ? this : new FieldAccess(this.id, this.prefix, this.markers, this.target, name, this.type);
        }

        public FieldAccess withType(JavaType type) {
            return this.type == type ? this : new FieldAccess(this.id, this.prefix, this.markers, this.target, this.name, type);
        }
    }

    public static final class EnumValueSet
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<EnumValue>> enums;
        private final boolean terminatedWithSemicolon;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValueSet(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValueSet)) {
                return false;
            }
            EnumValueSet other = (EnumValueSet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "enums", "terminatedWithSemicolon"})
        public EnumValueSet(UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<JRightPadded<EnumValue>> getEnums() {
            return this.enums;
        }

        public boolean isTerminatedWithSemicolon() {
            return this.terminatedWithSemicolon;
        }

        public String toString() {
            return "J.EnumValueSet(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", enums=" + this.getEnums() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
        }

        public EnumValueSet withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValueSet(this.id, prefix, this.markers, this.enums, this.terminatedWithSemicolon);
        }

        public EnumValueSet withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValueSet(this.id, this.prefix, markers, this.enums, this.terminatedWithSemicolon);
        }

        public EnumValueSet withEnums(List<JRightPadded<EnumValue>> enums) {
            return this.enums == enums ? this : new EnumValueSet(this.id, this.prefix, this.markers, enums, this.terminatedWithSemicolon);
        }
    }

    public static final class EnumValue
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Ident name;
        @Nullable
        private final NewClass initializer;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValue(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue other = (EnumValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "name", "initializer"})
        public EnumValue(UUID id, Space prefix, Markers markers, Ident name, NewClass initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.initializer = initializer;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Ident getName() {
            return this.name;
        }

        public NewClass getInitializer() {
            return this.initializer;
        }

        public String toString() {
            return "J.EnumValue(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", initializer=" + this.getInitializer() + ")";
        }

        public EnumValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValue(this.id, prefix, this.markers, this.name, this.initializer);
        }

        public EnumValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValue(this.id, this.prefix, markers, this.name, this.initializer);
        }

        public EnumValue withName(Ident name) {
            return this.name == name ? this : new EnumValue(this.id, this.prefix, this.markers, name, this.initializer);
        }

        public EnumValue withInitializer(NewClass initializer) {
            return this.initializer == initializer ? this : new EnumValue(this.id, this.prefix, this.markers, this.name, initializer);
        }
    }

    public static final class Empty
    implements J,
    Statement,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public Empty withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers"})
        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Empty(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static final class DoWhileLoop
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Statement> body;
        private final JLeftPadded<ControlParentheses<Expression>> whileCondition;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitDoWhileLoop(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileLoop)) {
                return false;
            }
            DoWhileLoop other = (DoWhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "body", "whileCondition"})
        public DoWhileLoop(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JRightPadded<Statement> getBody() {
            return this.body;
        }

        public JLeftPadded<ControlParentheses<Expression>> getWhileCondition() {
            return this.whileCondition;
        }

        public String toString() {
            return "J.DoWhileLoop(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ", whileCondition=" + this.getWhileCondition() + ")";
        }

        public DoWhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DoWhileLoop(this.id, prefix, this.markers, this.body, this.whileCondition);
        }

        public DoWhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new DoWhileLoop(this.id, this.prefix, markers, this.body, this.whileCondition);
        }

        public DoWhileLoop withBody(JRightPadded<Statement> body) {
            return this.body == body ? this : new DoWhileLoop(this.id, this.prefix, this.markers, body, this.whileCondition);
        }

        public DoWhileLoop withWhileCondition(JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            return this.whileCondition == whileCondition ? this : new DoWhileLoop(this.id, this.prefix, this.markers, this.body, whileCondition);
        }
    }

    public static final class Continue
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Ident label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitContinue(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue other = (Continue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "label"})
        public Continue(UUID id, Space prefix, Markers markers, Ident label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Ident getLabel() {
            return this.label;
        }

        public String toString() {
            return "J.Continue(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", label=" + this.getLabel() + ")";
        }

        public Continue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Continue(this.id, prefix, this.markers, this.label);
        }

        public Continue withMarkers(Markers markers) {
            return this.markers == markers ? this : new Continue(this.id, this.prefix, markers, this.label);
        }

        public Continue withLabel(Ident label) {
            return this.label == label ? this : new Continue(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class CompilationUnit
    implements J,
    SourceFile {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final JRightPadded<Package> packageDecl;
        private final List<JRightPadded<Import>> imports;
        private final List<ClassDecl> classes;
        private final Space eof;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public Set<NameTree> findType(String clazz) {
            return FindType.find(this, clazz);
        }

        @JsonIgnore
        public Path getSourceSet() {
            int packageLevelsUp = this.getPackageDecl() == null ? 0 : (int)this.getPackageDecl().getElem().printTrimmed().chars().filter(c -> c == 46).count();
            return this.sourcePath.getParent().resolve(IntStream.range(0, packageLevelsUp + 1).mapToObj(n -> "../").collect(Collectors.joining(""))).normalize();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "sourcePath", "packageDecl", "imports", "classes", "eof"})
        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, JRightPadded<Package> packageDecl, List<JRightPadded<Import>> imports, List<ClassDecl> classes, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.packageDecl = packageDecl;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public JRightPadded<Package> getPackageDecl() {
            return this.packageDecl;
        }

        public List<JRightPadded<Import>> getImports() {
            return this.imports;
        }

        public List<ClassDecl> getClasses() {
            return this.classes;
        }

        public Space getEof() {
            return this.eof;
        }

        public String toString() {
            return "J.CompilationUnit(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", packageDecl=" + this.getPackageDecl() + ", imports=" + this.getImports() + ", classes=" + this.getClasses() + ", eof=" + this.getEof() + ")";
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.id, prefix, this.markers, this.sourcePath, this.packageDecl, this.imports, this.classes, this.eof);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.id, this.prefix, markers, this.sourcePath, this.packageDecl, this.imports, this.classes, this.eof);
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.id, this.prefix, this.markers, sourcePath, this.packageDecl, this.imports, this.classes, this.eof);
        }

        public CompilationUnit withPackageDecl(JRightPadded<Package> packageDecl) {
            return this.packageDecl == packageDecl ? this : new CompilationUnit(this.id, this.prefix, this.markers, this.sourcePath, packageDecl, this.imports, this.classes, this.eof);
        }

        public CompilationUnit withImports(List<JRightPadded<Import>> imports) {
            return this.imports == imports ? this : new CompilationUnit(this.id, this.prefix, this.markers, this.sourcePath, this.packageDecl, imports, this.classes, this.eof);
        }

        public CompilationUnit withClasses(List<ClassDecl> classes) {
            return this.classes == classes ? this : new CompilationUnit(this.id, this.prefix, this.markers, this.sourcePath, this.packageDecl, this.imports, classes, this.eof);
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.id, this.prefix, this.markers, this.sourcePath, this.packageDecl, this.imports, this.classes, eof);
        }
    }

    public static final class ClassDecl
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        private final JLeftPadded<Kind> kind;
        private final Ident name;
        @Nullable
        private final JContainer<TypeParameter> typeParameters;
        @Nullable
        private final JLeftPadded<TypeTree> extendings;
        @Nullable
        private final JContainer<TypeTree> implementings;
        private final Block body;
        @Nullable
        private final JavaType.Class type;

        public ClassDecl withExtends(@Nullable JLeftPadded<TypeTree> extendings) {
            if (extendings == this.extendings) {
                return this;
            }
            return new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, extendings, this.implementings, this.body, this.type);
        }

        @JsonProperty(value="extendings")
        @Nullable
        public JLeftPadded<TypeTree> getExtends() {
            return this.extendings;
        }

        public ClassDecl withImplements(@Nullable JContainer<TypeTree> implementings) {
            if (implementings == this.implementings) {
                return this;
            }
            return new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, implementings, this.body, this.type);
        }

        @JsonProperty(value="implementings")
        @Nullable
        public JContainer<TypeTree> getImplements() {
            return this.implementings;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitClassDecl(this, p);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Nullable
        public EnumValueSet getEnumValues() {
            for (JRightPadded<Statement> stat : this.body.getStatements()) {
                if (!(stat.getElem() instanceof EnumValueSet)) continue;
                return (EnumValueSet)stat.getElem();
            }
            return null;
        }

        @JsonIgnore
        public List<VariableDecls> getFields() {
            ArrayList<VariableDecls> list = new ArrayList<VariableDecls>();
            for (JRightPadded<Statement> stat : this.body.getStatements()) {
                if (!(stat.getElem() instanceof VariableDecls)) continue;
                VariableDecls variableDecls = (VariableDecls)stat.getElem();
                list.add(variableDecls);
            }
            return list;
        }

        @JsonIgnore
        public List<MethodDecl> getMethods() {
            ArrayList<MethodDecl> list = new ArrayList<MethodDecl>();
            for (JRightPadded<Statement> stat : this.body.getStatements()) {
                if (!(stat.getElem() instanceof MethodDecl)) continue;
                MethodDecl methodDecl = (MethodDecl)stat.getElem();
                list.add(methodDecl);
            }
            return list;
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "ClassDecl(" + ClassDeclToString.toString(this) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDecl)) {
                return false;
            }
            ClassDecl other = (ClassDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "annotations", "modifiers", "kind", "name", "typeParameters", "extendings", "implementings", "body", "type"})
        public ClassDecl(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, JLeftPadded<Kind> kind, Ident name, JContainer<TypeParameter> typeParameters, JLeftPadded<TypeTree> extendings, JContainer<TypeTree> implementings, Block body, JavaType.Class type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public ClassDecl withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ClassDecl(this.id, prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ClassDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new ClassDecl(this.id, this.prefix, markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ClassDecl withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new ClassDecl(this.id, this.prefix, this.markers, annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public ClassDecl withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ClassDecl(this.id, this.prefix, this.markers, this.annotations, modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public ClassDecl withKind(JLeftPadded<Kind> kind) {
            return this.kind == kind ? this : new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public JLeftPadded<Kind> getKind() {
            return this.kind;
        }

        public ClassDecl withName(Ident name) {
            return this.name == name ? this : new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, name, this.typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public Ident getName() {
            return this.name;
        }

        public ClassDecl withTypeParameters(JContainer<TypeParameter> typeParameters) {
            return this.typeParameters == typeParameters ? this : new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, typeParameters, this.extendings, this.implementings, this.body, this.type);
        }

        public JContainer<TypeParameter> getTypeParameters() {
            return this.typeParameters;
        }

        public ClassDecl withBody(Block body) {
            return this.body == body ? this : new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, body, this.type);
        }

        public Block getBody() {
            return this.body;
        }

        public ClassDecl withType(JavaType.Class type) {
            return this.type == type ? this : new ClassDecl(this.id, this.prefix, this.markers, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, type);
        }

        public JavaType.Class getType() {
            return this.type;
        }

        public static enum Kind {
            Class,
            Enum,
            Interface,
            Annotation;

        }
    }

    public static final class Case
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression pattern;
        private final JContainer<Statement> statements;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCase(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Case)) {
                return false;
            }
            Case other = (Case)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "pattern", "statements"})
        public Case(UUID id, Space prefix, Markers markers, Expression pattern, JContainer<Statement> statements) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.statements = statements;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getPattern() {
            return this.pattern;
        }

        public JContainer<Statement> getStatements() {
            return this.statements;
        }

        public String toString() {
            return "J.Case(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", pattern=" + this.getPattern() + ", statements=" + this.getStatements() + ")";
        }

        public Case withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Case(this.id, prefix, this.markers, this.pattern, this.statements);
        }

        public Case withMarkers(Markers markers) {
            return this.markers == markers ? this : new Case(this.id, this.prefix, markers, this.pattern, this.statements);
        }

        public Case withPattern(Expression pattern) {
            return this.pattern == pattern ? this : new Case(this.id, this.prefix, this.markers, pattern, this.statements);
        }

        public Case withStatements(JContainer<Statement> statements) {
            return this.statements == statements ? this : new Case(this.id, this.prefix, this.markers, this.pattern, statements);
        }
    }

    public static final class Break
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Ident label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBreak(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Break)) {
                return false;
            }
            Break other = (Break)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "label"})
        public Break(UUID id, Space prefix, Markers markers, Ident label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Ident getLabel() {
            return this.label;
        }

        public String toString() {
            return "J.Break(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", label=" + this.getLabel() + ")";
        }

        public Break withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Break(this.id, prefix, this.markers, this.label);
        }

        public Break withMarkers(Markers markers) {
            return this.markers == markers ? this : new Break(this.id, this.prefix, markers, this.label);
        }

        public Break withLabel(Ident label) {
            return this.label == label ? this : new Break(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class Block
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Space statik;
        private final List<JRightPadded<Statement>> statements;
        private final Space end;

        @JsonProperty(value="statik")
        @Nullable
        public Space getStatic() {
            return this.statik;
        }

        public Block withStatic(@Nullable Space statik) {
            return new Block(this.id, this.prefix, this.markers, statik, this.statements, this.end);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBlock(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "statik", "statements", "end"})
        public Block(UUID id, Space prefix, Markers markers, Space statik, List<JRightPadded<Statement>> statements, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Block withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Block(this.id, prefix, this.markers, this.statik, this.statements, this.end);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Block withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block(this.id, this.prefix, markers, this.statik, this.statements, this.end);
        }

        public Block withStatik(Space statik) {
            return this.statik == statik ? this : new Block(this.id, this.prefix, this.markers, statik, this.statements, this.end);
        }

        public List<JRightPadded<Statement>> getStatements() {
            return this.statements;
        }

        public Block withStatements(List<JRightPadded<Statement>> statements) {
            return this.statements == statements ? this : new Block(this.id, this.prefix, this.markers, this.statik, statements, this.end);
        }

        public Space getEnd() {
            return this.end;
        }

        public Block withEnd(Space end) {
            return this.end == end ? this : new Block(this.id, this.prefix, this.markers, this.statik, this.statements, end);
        }
    }

    public static final class Binary
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            ArrayList<Tree> sideEffects = new ArrayList<Tree>(2);
            sideEffects.addAll(this.left.getSideEffects());
            sideEffects.addAll(this.right.getSideEffects());
            return sideEffects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "left", "operator", "right", "type"})
        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public JLeftPadded<Type> getOperator() {
            return this.operator;
        }

        public Expression getRight() {
            return this.right;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.Binary(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + this.getOperator() + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        public Binary withOperator(JLeftPadded<Type> operator) {
            return this.operator == operator ? this : new Binary(this.id, this.prefix, this.markers, this.left, operator, this.right, this.type);
        }

        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        public Binary withType(JavaType type) {
            return this.type == type ? this : new Binary(this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            LessThan,
            GreaterThan,
            LessThanOrEqual,
            GreaterThanOrEqual,
            Equal,
            NotEqual,
            BitAnd,
            BitOr,
            BitXor,
            LeftShift,
            RightShift,
            UnsignedRightShift,
            Or,
            And;

        }
    }

    public static final class AssignOp
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Type> operator;
        private final Expression assignment;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignOp(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignOp)) {
                return false;
            }
            AssignOp other = (AssignOp)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "variable", "operator", "assignment", "type"})
        public AssignOp(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getVariable() {
            return this.variable;
        }

        public JLeftPadded<Type> getOperator() {
            return this.operator;
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.AssignOp(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variable=" + this.getVariable() + ", operator=" + this.getOperator() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ")";
        }

        public AssignOp withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AssignOp(this.id, prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        public AssignOp withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssignOp(this.id, this.prefix, markers, this.variable, this.operator, this.assignment, this.type);
        }

        public AssignOp withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignOp(this.id, this.prefix, this.markers, variable, this.operator, this.assignment, this.type);
        }

        public AssignOp withOperator(JLeftPadded<Type> operator) {
            return this.operator == operator ? this : new AssignOp(this.id, this.prefix, this.markers, this.variable, operator, this.assignment, this.type);
        }

        public AssignOp withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignOp(this.id, this.prefix, this.markers, this.variable, this.operator, assignment, this.type);
        }

        public AssignOp withType(JavaType type) {
            return this.type == type ? this : new AssignOp(this.id, this.prefix, this.markers, this.variable, this.operator, this.assignment, type);
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            BitAnd,
            BitOr,
            BitXor,
            LeftShift,
            RightShift,
            UnsignedRightShift;

        }
    }

    public static final class Assign
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Expression> assignment;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssign(this, p);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assign)) {
                return false;
            }
            Assign other = (Assign)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "variable", "assignment", "type"})
        public Assign(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getVariable() {
            return this.variable;
        }

        public JLeftPadded<Expression> getAssignment() {
            return this.assignment;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.Assign(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variable=" + this.getVariable() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ")";
        }

        public Assign withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assign(this.id, prefix, this.markers, this.variable, this.assignment, this.type);
        }

        public Assign withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assign(this.id, this.prefix, markers, this.variable, this.assignment, this.type);
        }

        public Assign withVariable(Expression variable) {
            return this.variable == variable ? this : new Assign(this.id, this.prefix, this.markers, variable, this.assignment, this.type);
        }

        public Assign withAssignment(JLeftPadded<Expression> assignment) {
            return this.assignment == assignment ? this : new Assign(this.id, this.prefix, this.markers, this.variable, assignment, this.type);
        }

        public Assign withType(JavaType type) {
            return this.type == type ? this : new Assign(this.id, this.prefix, this.markers, this.variable, this.assignment, type);
        }
    }

    public static final class Assert
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssert(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert other = (Assert)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "condition"})
        public Assert(UUID id, Space prefix, Markers markers, Expression condition) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public String toString() {
            return "J.Assert(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ")";
        }

        public Assert withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assert(this.id, prefix, this.markers, this.condition);
        }

        public Assert withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assert(this.id, this.prefix, markers, this.condition);
        }

        public Assert withCondition(Expression condition) {
            return this.condition == condition ? this : new Assert(this.id, this.prefix, this.markers, condition);
        }
    }

    public static final class ArrayType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree elementType;
        private final List<JRightPadded<Space>> dimensions;

        @Override
        public JavaType getType() {
            return this.elementType.getType();
        }

        public ArrayType withType(@Nullable JavaType type) {
            if (type == this.getType()) {
                return this;
            }
            return this.withElementType((TypeTree)this.elementType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayType(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "elementType", "dimensions"})
        public ArrayType(UUID id, Space prefix, Markers markers, TypeTree elementType, List<JRightPadded<Space>> dimensions) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elementType = elementType;
            this.dimensions = dimensions;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeTree getElementType() {
            return this.elementType;
        }

        public List<JRightPadded<Space>> getDimensions() {
            return this.dimensions;
        }

        public String toString() {
            return "J.ArrayType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", elementType=" + this.getElementType() + ", dimensions=" + this.getDimensions() + ")";
        }

        public ArrayType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayType(this.id, prefix, this.markers, this.elementType, this.dimensions);
        }

        public ArrayType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayType(this.id, this.prefix, markers, this.elementType, this.dimensions);
        }

        public ArrayType withElementType(TypeTree elementType) {
            return this.elementType == elementType ? this : new ArrayType(this.id, this.prefix, this.markers, elementType, this.dimensions);
        }

        public ArrayType withDimensions(List<JRightPadded<Space>> dimensions) {
            return this.dimensions == dimensions ? this : new ArrayType(this.id, this.prefix, this.markers, this.elementType, dimensions);
        }
    }

    public static final class ArrayAccess
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression indexed;
        private final ArrayDimension dimension;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayAccess(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "indexed", "dimension", "type"})
        public ArrayAccess(UUID id, Space prefix, Markers markers, Expression indexed, ArrayDimension dimension, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.indexed = indexed;
            this.dimension = dimension;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getIndexed() {
            return this.indexed;
        }

        public ArrayDimension getDimension() {
            return this.dimension;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "J.ArrayAccess(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", indexed=" + this.getIndexed() + ", dimension=" + this.getDimension() + ", type=" + this.getType() + ")";
        }

        public ArrayAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayAccess(this.id, prefix, this.markers, this.indexed, this.dimension, this.type);
        }

        public ArrayAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayAccess(this.id, this.prefix, markers, this.indexed, this.dimension, this.type);
        }

        public ArrayAccess withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new ArrayAccess(this.id, this.prefix, this.markers, indexed, this.dimension, this.type);
        }

        public ArrayAccess withDimension(ArrayDimension dimension) {
            return this.dimension == dimension ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, dimension, this.type);
        }

        public ArrayAccess withType(JavaType type) {
            return this.type == type ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, this.dimension, type);
        }
    }

    public static final class Annotation
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree annotationType;
        @Nullable
        private final JContainer<Expression> args;

        @Override
        @JsonIgnore
        public JavaType getType() {
            return this.annotationType.getType();
        }

        public Annotation withType(@Nullable JavaType type) {
            return this.withAnnotationType((NameTree)this.annotationType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotation(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation other = (Annotation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "annotationType", "args"})
        public Annotation(UUID id, Space prefix, Markers markers, NameTree annotationType, JContainer<Expression> args) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.args = args;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public NameTree getAnnotationType() {
            return this.annotationType;
        }

        public JContainer<Expression> getArgs() {
            return this.args;
        }

        public String toString() {
            return "J.Annotation(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotationType=" + this.getAnnotationType() + ", args=" + this.getArgs() + ")";
        }

        public Annotation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Annotation(this.id, prefix, this.markers, this.annotationType, this.args);
        }

        public Annotation withMarkers(Markers markers) {
            return this.markers == markers ? this : new Annotation(this.id, this.prefix, markers, this.annotationType, this.args);
        }

        public Annotation withAnnotationType(NameTree annotationType) {
            return this.annotationType == annotationType ? this : new Annotation(this.id, this.prefix, this.markers, annotationType, this.args);
        }

        public Annotation withArgs(JContainer<Expression> args) {
            return this.args == args ? this : new Annotation(this.id, this.prefix, this.markers, this.annotationType, args);
        }
    }

    public static final class AnnotatedType
    implements J,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final TypeTree typeExpr;

        @Override
        public JavaType getType() {
            return this.typeExpr.getType();
        }

        public AnnotatedType withType(@Nullable JavaType type) {
            return this.withTypeExpr((TypeTree)this.typeExpr.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotatedType(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedType)) {
                return false;
            }
            AnnotatedType other = (AnnotatedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "prefix", "markers", "annotations", "typeExpr"})
        public AnnotatedType(UUID id, Space prefix, Markers markers, List<Annotation> annotations, TypeTree typeExpr) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeExpr = typeExpr;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public String toString() {
            return "J.AnnotatedType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", typeExpr=" + this.getTypeExpr() + ")";
        }

        public AnnotatedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AnnotatedType(this.id, prefix, this.markers, this.annotations, this.typeExpr);
        }

        public AnnotatedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotatedType(this.id, this.prefix, markers, this.annotations, this.typeExpr);
        }

        public AnnotatedType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedType(this.id, this.prefix, this.markers, annotations, this.typeExpr);
        }

        public AnnotatedType withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new AnnotatedType(this.id, this.prefix, this.markers, this.annotations, typeExpr);
        }
    }
}

