/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.internal.grammar.AnnotationSignatureParser;
import org.openrewrite.java.internal.grammar.AspectJLexer;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class FindAnnotation
extends Recipe {
    private final String annotationPattern;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindAnnotationVisitor(this.annotationPattern);
    }

    public static Set<J.Annotation> find(J j, String clazz) {
        return ((J)new FindAnnotationVisitor(clazz).visit(j, ExecutionContext.builder().build())).findMarkedWith(SearchResult.class);
    }

    @ConstructorProperties(value={"annotationPattern"})
    public FindAnnotation(String annotationPattern) {
        this.annotationPattern = annotationPattern;
    }

    public String getAnnotationPattern() {
        return this.annotationPattern;
    }

    public String toString() {
        return "FindAnnotation(annotationPattern=" + this.getAnnotationPattern() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAnnotation)) {
            return false;
        }
        FindAnnotation other = (FindAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationPattern = this.getAnnotationPattern();
        String other$annotationPattern = other.getAnnotationPattern();
        return !(this$annotationPattern == null ? other$annotationPattern != null : !this$annotationPattern.equals(other$annotationPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationPattern = this.getAnnotationPattern();
        result = result * 59 + ($annotationPattern == null ? 43 : $annotationPattern.hashCode());
        return result;
    }

    private static class FindAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final AnnotationMatcher matcher;

        public FindAnnotationVisitor(String signature) {
            this.matcher = new AnnotationMatcher(signature);
        }

        @Override
        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J a = super.visitAnnotation(annotation, ctx);
            if (this.matcher.matches(annotation)) {
                a = (J.Annotation)a.mark(new Marker[]{new SearchResult()});
            }
            return a;
        }

        private static class AnnotationMatcher {
            private final AnnotationSignatureParser.AnnotationContext match;

            public AnnotationMatcher(String signature) {
                this.match = new AnnotationSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new AspectJLexer((CharStream)CharStreams.fromString((String)signature)))).annotation();
            }

            public boolean matches(J.Annotation annotation) {
                return this.matchesAnnotationName(annotation) && this.matchesSingleParameter(annotation) && this.matchesNamedParameters(annotation);
            }

            private boolean matchesAnnotationName(J.Annotation annotation) {
                JavaType.Class typeAsClass = TypeUtils.asClass(annotation.getType());
                return this.match.annotationName().getText().equals(typeAsClass == null ? null : typeAsClass.getFullyQualifiedName());
            }

            private boolean matchesNamedParameters(J.Annotation annotation) {
                AnnotationSignatureParser.ElementValuePairsContext pairs = this.match.elementValuePairs();
                if (pairs == null || pairs.elementValuePair() == null) {
                    return true;
                }
                List matchArgs = pairs.elementValuePair().stream().map(pair -> new AnnotationParameter(pair.Identifier().getText(), pair.elementValue().getText())).collect(Collectors.toList());
                return annotation.getArgs() != null && annotation.getArgs().getElem().stream().map(arg -> {
                    J.Assign assign = (J.Assign)arg.getElem();
                    return new AnnotationParameter(assign.getVariable().printTrimmed(), assign.getAssignment().getElem().printTrimmed());
                }).allMatch(param -> matchArgs.stream().anyMatch(param::equals));
            }

            private boolean matchesSingleParameter(J.Annotation annotation) {
                if (this.match.elementValue() == null) {
                    return true;
                }
                return annotation.getArgs() == null || annotation.getArgs().getElem().stream().findAny().map(JRightPadded::getElem).map(arg -> {
                    if (arg instanceof J.Assign) {
                        return ((J.Assign)arg).getAssignment().getElem().printTrimmed().equals(this.match.elementValue().getText());
                    }
                    if (arg instanceof J.Literal) {
                        return ((J.Literal)arg).getValueSource().equals(this.match.elementValue().getText());
                    }
                    return false;
                }).orElse(true) != false;
            }

            private static class AnnotationParameter {
                private final String id;
                private final String value;

                @ConstructorProperties(value={"id", "value"})
                public AnnotationParameter(String id, String value) {
                    this.id = id;
                    this.value = value;
                }

                public String getId() {
                    return this.id;
                }

                public String getValue() {
                    return this.value;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AnnotationParameter)) {
                        return false;
                    }
                    AnnotationParameter other = (AnnotationParameter)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$id = this.getId();
                    String other$id = other.getId();
                    if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                        return false;
                    }
                    String this$value = this.getValue();
                    String other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof AnnotationParameter;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : $id.hashCode());
                    String $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }

                public String toString() {
                    return "FindAnnotation.FindAnnotationVisitor.AnnotationMatcher.AnnotationParameter(id=" + this.getId() + ", value=" + this.getValue() + ")";
                }
            }
        }
    }
}

