/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class ReorderMethodArguments
extends Recipe {
    private final String methodPattern;
    private final String[] orderedArgumentNames;
    @Nullable
    private String[] originalOrderedArgumentNames = new String[0];

    public ReorderMethodArguments(String methodPattern, String[] orderedArgumentNames) {
        this.methodPattern = methodPattern;
        this.orderedArgumentNames = orderedArgumentNames;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ReorderMethodArgumentsVisitor(new MethodMatcher(this.methodPattern));
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String[] getOrderedArgumentNames() {
        return this.orderedArgumentNames;
    }

    public String[] getOriginalOrderedArgumentNames() {
        return this.originalOrderedArgumentNames;
    }

    public void setOriginalOrderedArgumentNames(String[] originalOrderedArgumentNames) {
        this.originalOrderedArgumentNames = originalOrderedArgumentNames;
    }

    public String toString() {
        return "ReorderMethodArguments(methodPattern=" + this.getMethodPattern() + ", orderedArgumentNames=" + Arrays.deepToString(this.getOrderedArgumentNames()) + ", originalOrderedArgumentNames=" + Arrays.deepToString(this.getOriginalOrderedArgumentNames()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderMethodArguments)) {
            return false;
        }
        ReorderMethodArguments other = (ReorderMethodArguments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOrderedArgumentNames(), other.getOrderedArgumentNames())) {
            return false;
        }
        return Arrays.deepEquals(this.getOriginalOrderedArgumentNames(), other.getOriginalOrderedArgumentNames());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReorderMethodArguments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOrderedArgumentNames());
        result = result * 59 + Arrays.deepHashCode(this.getOriginalOrderedArgumentNames());
        return result;
    }

    @ConstructorProperties(value={"methodPattern", "orderedArgumentNames", "originalOrderedArgumentNames"})
    public ReorderMethodArguments(String methodPattern, String[] orderedArgumentNames, String[] originalOrderedArgumentNames) {
        this.methodPattern = methodPattern;
        this.orderedArgumentNames = orderedArgumentNames;
        this.originalOrderedArgumentNames = originalOrderedArgumentNames;
    }

    private class ReorderMethodArgumentsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private ReorderMethodArgumentsVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m) && ((J.MethodInvocation)m).getType() != null) {
                void var13_16;
                List<String> paramNames;
                List<String> list = paramNames = ReorderMethodArguments.this.originalOrderedArgumentNames.length == 0 ? ((J.MethodInvocation)m).getType().getParamNames() : Arrays.asList(ReorderMethodArguments.this.originalOrderedArgumentNames);
                if (paramNames == null) {
                    throw new IllegalStateException("There is no source attachment for method " + ((J.MethodInvocation)m).getType().getDeclaringType().getFullyQualifiedName() + "." + ((J.MethodInvocation)m).getSimpleName() + "(..). Provide a reference for original parameter names by calling setOriginalParamNames(..)");
                }
                List<JRightPadded<Expression>> originalArgs = ((J.MethodInvocation)m).getArgs().getElem();
                int resolvedParamCount = ((J.MethodInvocation)m).getType().getResolvedSignature() == null ? originalArgs.size() : ((J.MethodInvocation)m).getType().getResolvedSignature().getParamTypes().size();
                int i = 0;
                ArrayList reordered = new ArrayList(originalArgs.size());
                ArrayList<Space> formattings = new ArrayList<Space>(originalArgs.size());
                ArrayList<Space> rightFormattings = new ArrayList<Space>(originalArgs.size());
                String[] stringArray = ReorderMethodArguments.this.orderedArgumentNames;
                int n = stringArray.length;
                boolean bl = false;
                while (var13_16 < n) {
                    String name = stringArray[var13_16];
                    int fromPos = paramNames.indexOf(name);
                    if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                        List<JRightPadded<Expression>> varargs = originalArgs.subList(fromPos, originalArgs.size());
                        reordered.addAll(varargs);
                        for (JRightPadded<Expression> exp : originalArgs.subList(i, i++ + varargs.size())) {
                            formattings.add(exp.getElem().getPrefix());
                            rightFormattings.add(exp.getAfter());
                        }
                    } else if (fromPos >= 0 && originalArgs.size() > fromPos) {
                        reordered.add(originalArgs.get(fromPos));
                        formattings.add(originalArgs.get(i).getElem().getPrefix());
                        rightFormattings.add(originalArgs.get(i++).getAfter());
                    }
                    ++var13_16;
                }
                boolean changed = false;
                i = 0;
                for (JRightPadded jRightPadded : reordered) {
                    int index = i;
                    reordered.set(i, jRightPadded.map(e -> (Expression)e.withPrefix((Space)formattings.get(index))).withAfter((Space)rightFormattings.get(index)));
                    if (reordered.get(i) != originalArgs.get(i)) {
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    m = ((J.MethodInvocation)m).withArgs(((J.MethodInvocation)m).getArgs().withElem(reordered));
                }
            }
            return m;
        }
    }
}

